/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.JUnit3TestGenerator;
import org.netbeans.modules.junit.JUnit4TestGenerator;
import org.netbeans.modules.junit.JUnitVersion;
import org.netbeans.modules.junit.TestGeneratorSetup;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.TestabilityJudge;
import org.netbeans.modules.junit.TestabilityResult;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestCreator
implements TestabilityJudge {
    static final Set<Modifier> ACCESS_MODIFIERS = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
    private final TestGeneratorSetup setup;
    private final JUnitVersion junitVersion;

    TestCreator(boolean bl, JUnitVersion jUnitVersion) {
        this.setup = new TestGeneratorSetup(bl);
        this.junitVersion = jUnitVersion;
    }

    TestCreator(Map<JUnitPlugin.CreateTestParam, Object> map, JUnitVersion jUnitVersion) {
        this.setup = new TestGeneratorSetup(map);
        this.junitVersion = jUnitVersion;
    }

    public void createEmptyTest(FileObject fileObject) throws IOException {
        AbstractTestGenerator abstractTestGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                abstractTestGenerator = new JUnit3TestGenerator(this.setup, TestUtil.getSourceLevel(fileObject));
                break;
            }
            case JUNIT4: {
                abstractTestGenerator = new JUnit4TestGenerator(this.setup);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        ModificationResult modificationResult = JavaSource.forFileObject((FileObject)fileObject).runModificationTask((Task)abstractTestGenerator);
        modificationResult.commit();
    }

    public void createSimpleTest(ElementHandle<TypeElement> elementHandle, FileObject fileObject, boolean bl) throws IOException {
        AbstractTestGenerator abstractTestGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                abstractTestGenerator = new JUnit3TestGenerator(this.setup, Collections.singletonList(elementHandle), null, bl, TestUtil.getSourceLevel(fileObject));
                break;
            }
            case JUNIT4: {
                abstractTestGenerator = new JUnit4TestGenerator(this.setup, Collections.singletonList(elementHandle), null, bl);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        ModificationResult modificationResult = JavaSource.forFileObject((FileObject)fileObject).runModificationTask((Task)abstractTestGenerator);
        modificationResult.commit();
    }

    public List<String> createTestSuite(List<String> list, FileObject fileObject, boolean bl) throws IOException {
        AbstractTestGenerator abstractTestGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                abstractTestGenerator = new JUnit3TestGenerator(this.setup, null, list, bl, TestUtil.getSourceLevel(fileObject));
                break;
            }
            case JUNIT4: {
                abstractTestGenerator = new JUnit4TestGenerator(this.setup, null, list, bl);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        ModificationResult modificationResult = JavaSource.forFileObject((FileObject)fileObject).runModificationTask((Task)abstractTestGenerator);
        modificationResult.commit();
        return abstractTestGenerator.getProcessedClassNames();
    }

    @Override
    public TestabilityResult isClassTestable(CompilationInfo compilationInfo, TypeElement typeElement) {
        return this.setup.isClassTestable(compilationInfo, typeElement);
    }

    @Override
    public boolean isMethodTestable(ExecutableElement executableElement) {
        return this.setup.isMethodTestable(executableElement);
    }
}

