/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml.editor.completion;

import java.util.ArrayList;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.IncrementalEmbeddingModel;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhtmlModel {
    private final Document doc;
    private final ArrayList<CodeBlockData> codeBlocks = new ArrayList();
    private String rubyCode;
    private boolean documentDirty = true;
    private int prevAstOffset;
    private int prevLexOffset;

    public static RhtmlModel get(Document document) {
        RhtmlModel rhtmlModel = (RhtmlModel)document.getProperty(RhtmlModel.class);
        if (rhtmlModel == null) {
            rhtmlModel = new RhtmlModel(document);
            document.putProperty(RhtmlModel.class, rhtmlModel);
        }
        return rhtmlModel;
    }

    RhtmlModel(Document document) {
        this.doc = document;
        if (document != null) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            tokenHierarchy.addTokenHierarchyListener(new TokenHierarchyListener(){

                public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
                    RhtmlModel.this.documentDirty = true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRubyCode() {
        if (this.documentDirty) {
            this.documentDirty = false;
            this.codeBlocks.clear();
            StringBuilder stringBuilder = new StringBuilder();
            BaseDocument baseDocument = (BaseDocument)this.doc;
            try {
                baseDocument.readLock();
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence(RhtmlTokenId.language());
                this.eruby(stringBuilder, (TokenHierarchy<Document>)tokenHierarchy, (TokenSequence<RhtmlTokenId>)tokenSequence);
            }
            finally {
                baseDocument.readUnlock();
            }
            this.rubyCode = stringBuilder.toString();
        }
        return this.rubyCode;
    }

    void eruby(StringBuilder stringBuilder, TokenHierarchy<Document> tokenHierarchy, TokenSequence<RhtmlTokenId> tokenSequence) {
        String string;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append("class ActionView::Base\n");
        stringBuilder2.append("_buf='';");
        this.codeBlocks.add(new CodeBlockData(0, 0, 0, stringBuilder2.length()));
        boolean bl = false;
        while (tokenSequence.moveNext()) {
            int n;
            String string2;
            int n2;
            int n3;
            int n4;
            string = tokenSequence.token();
            if (string.id() == RhtmlTokenId.HTML) {
                int n5;
                int n6;
                n4 = string.offset(tokenHierarchy);
                n3 = n4 + string.length();
                n2 = stringBuilder2.length();
                string2 = ((Object)string.text()).toString();
                n = 0;
                for (n6 = 0; n6 < string2.length(); ++n6) {
                    n5 = string2.charAt(n6);
                    if (n5 == 10) {
                        ++n6;
                        n = 1;
                        break;
                    }
                    if (!Character.isWhitespace((char)n5)) break;
                }
                if (n != 0) {
                    stringBuilder2.append(string2.substring(0, n6));
                    string2 = string2.substring(n6);
                } else {
                    stringBuilder2.append(';');
                }
                stringBuilder2.append("_buf << '");
                if (bl && string2.startsWith("\n")) {
                    string2 = string2.substring(1);
                    --n3;
                }
                string2 = string2.replace("'", "\\'");
                stringBuilder2.append(string2);
                stringBuilder2.append("';\n");
                n5 = stringBuilder2.length();
                CodeBlockData codeBlockData = new CodeBlockData(n4, n3, n2, n5);
                this.codeBlocks.add(codeBlockData);
                bl = false;
                continue;
            }
            if (string.id() == RhtmlTokenId.RUBY) {
                n4 = string.offset(tokenHierarchy);
                n3 = n4 + string.length();
                n2 = stringBuilder2.length();
                string2 = ((Object)string.text()).toString();
                bl = false;
                if (string2.endsWith("-")) {
                    string2 = string2.substring(0, string2.length() - 1);
                    bl = true;
                }
                stringBuilder2.append(string2);
                n = stringBuilder2.length();
                CodeBlockData codeBlockData = new CodeBlockData(n4, n3, n2, n);
                this.codeBlocks.add(codeBlockData);
                bl = false;
                continue;
            }
            if (string.id() != RhtmlTokenId.RUBY_EXPR) continue;
            stringBuilder2.append("_buf << (");
            n4 = string.offset(tokenHierarchy);
            n3 = n4 + string.length();
            n2 = stringBuilder2.length();
            string2 = ((Object)string.text()).toString();
            bl = false;
            if (string2.endsWith("-")) {
                string2 = string2.substring(0, string2.length() - 1);
                bl = true;
            }
            stringBuilder2.append(string2);
            n = stringBuilder2.length();
            CodeBlockData codeBlockData = new CodeBlockData(n4, n3, n2, n);
            this.codeBlocks.add(codeBlockData);
            stringBuilder2.append(").to_s;");
        }
        string = "\nend\n";
        stringBuilder2.append(string);
        if (this.doc != null) {
            this.codeBlocks.add(new CodeBlockData(this.doc.getLength(), this.doc.getLength(), stringBuilder2.length() - string.length(), stringBuilder2.length()));
        }
    }

    public int sourceToGeneratedPos(int n) {
        if (this.prevLexOffset == n) {
            return this.prevAstOffset;
        }
        this.prevLexOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtSourceOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.sourceStart;
        int n3 = codeBlockData.generatedStart + n2;
        this.prevAstOffset = n3 <= codeBlockData.generatedEnd ? n3 : codeBlockData.generatedEnd;
        return this.prevAstOffset;
    }

    public int generatedToSourcePos(int n) {
        if (this.prevAstOffset == n) {
            return this.prevLexOffset;
        }
        this.prevAstOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtGeneratedOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.generatedStart;
        int n3 = codeBlockData.sourceStart + n2;
        this.prevLexOffset = n3 <= codeBlockData.sourceEnd ? n3 : codeBlockData.sourceEnd;
        return this.prevLexOffset;
    }

    private CodeBlockData getCodeBlockAtSourceOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.sourceStart > n || codeBlockData.sourceEnd < n) continue;
            return codeBlockData;
        }
        return null;
    }

    private CodeBlockData getCodeBlockAtGeneratedOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.generatedStart > n || codeBlockData.generatedEnd < n) continue;
            return codeBlockData;
        }
        return null;
    }

    IncrementalEmbeddingModel.UpdateState incrementalUpdate(EditHistory editHistory) {
        this.prevLexOffset = editHistory.convertOriginalToEdited(this.prevLexOffset);
        int n = editHistory.getStart();
        int n2 = editHistory.getOriginalEnd();
        int n3 = editHistory.getSizeDelta();
        boolean bl = false;
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.sourceEnd <= n) continue;
            if (codeBlockData.sourceStart >= n2) {
                codeBlockData.sourceStart += n3;
                codeBlockData.sourceEnd += n3;
                continue;
            }
            if (codeBlockData.sourceStart <= n && codeBlockData.sourceEnd >= n2) {
                codeBlockData.sourceEnd += n3;
                bl = true;
                continue;
            }
            return IncrementalEmbeddingModel.UpdateState.FAILED;
        }
        return bl ? IncrementalEmbeddingModel.UpdateState.UPDATED : IncrementalEmbeddingModel.UpdateState.COMPLETED;
    }

    private class CodeBlockData {
        private int sourceStart;
        private int sourceEnd;
        private int generatedStart;
        private int generatedEnd;

        public CodeBlockData(int n, int n2, int n3, int n4) {
            this.sourceStart = n;
            this.generatedStart = n3;
            this.sourceEnd = n2;
            this.generatedEnd = n4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CodeBlockData[");
            stringBuilder.append("\n  RHTML(" + this.sourceStart + "," + this.sourceEnd + ")");
            stringBuilder.append(",\n  RUBY(" + this.generatedStart + "," + this.generatedEnd + ")");
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

