/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

class TextImporterUI
extends JPanel {
    private String smallIconPath;
    private String largeIconPath;
    private JButton btnSelectLargeIcon;
    private JButton btnSelectSmallIcon;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JLabel lblLargeIcon;
    private JLabel lblSmallIcon;
    private JTextArea txtContent;
    private JTextField txtName;
    private JTextField txtTooltip;
    private static File defaultFolder;

    public TextImporterUI(String string, final JButton jButton) {
        this.initComponents();
        this.txtContent.setText(string);
        this.txtContent.setCaretPosition(0);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                TextImporterUI.this.updateButton(jButton);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                TextImporterUI.this.updateButton(jButton);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                TextImporterUI.this.updateButton(jButton);
            }
        };
        this.updateButton(jButton);
        this.txtName.getDocument().addDocumentListener(documentListener);
        this.txtContent.getDocument().addDocumentListener(documentListener);
    }

    String getItemName() {
        return this.txtName.getText();
    }

    String getItemTooltip() {
        return this.txtTooltip.getText();
    }

    String getItemContent() {
        return this.txtContent.getText();
    }

    String getItemSmallIconPath() {
        return this.smallIconPath;
    }

    String getItemLargeIconPath() {
        return this.largeIconPath;
    }

    private void updateButton(final JButton jButton) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = TextImporterUI.this.txtName.getText().length() > 0;
                jButton.setEnabled(bl &= TextImporterUI.this.txtContent.getText().length() > 0);
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtName = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtTooltip = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtContent = new JTextArea();
        this.lblLargeIcon = new JLabel();
        this.btnSelectLargeIcon = new JButton();
        this.lblSmallIcon = new JLabel();
        this.btnSelectSmallIcon = new JButton();
        this.jLabel1.setDisplayedMnemonic('N');
        this.jLabel1.setLabelFor(this.txtName);
        this.jLabel1.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.jLabel1.text"));
        this.txtName.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.txtName.text"));
        this.jLabel2.setDisplayedMnemonic('T');
        this.jLabel2.setLabelFor(this.txtTooltip);
        this.jLabel2.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.jLabel2.text"));
        this.txtTooltip.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.txtTooltip.text"));
        this.jLabel3.setLabelFor(this.lblSmallIcon);
        this.jLabel3.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.jLabel3.text"));
        this.jLabel4.setLabelFor(this.lblLargeIcon);
        this.jLabel4.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.jLabel4.text"));
        this.jLabel5.setDisplayedMnemonic('C');
        this.jLabel5.setLabelFor(this.txtContent);
        this.jLabel5.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.jLabel5.text"));
        this.txtContent.setColumns(20);
        this.txtContent.setRows(5);
        this.jScrollPane1.setViewportView(this.txtContent);
        this.txtContent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.txtContent.AccessibleContext.accessibleDescription"));
        this.lblLargeIcon.setHorizontalAlignment(0);
        this.lblLargeIcon.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/palette/resources/unknown32.gif")));
        this.lblLargeIcon.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.lblLargeIcon.text"));
        this.lblLargeIcon.setBorder(BorderFactory.createEtchedBorder());
        this.lblLargeIcon.setHorizontalTextPosition(0);
        this.lblLargeIcon.setIconTextGap(0);
        this.lblLargeIcon.setPreferredSize(new Dimension(40, 40));
        this.btnSelectLargeIcon.setMnemonic('e');
        this.btnSelectLargeIcon.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.btnSelectLargeIcon.text"));
        this.btnSelectLargeIcon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextImporterUI.this.btnSelectLargeIconActionPerformed(actionEvent);
            }
        });
        this.lblSmallIcon.setHorizontalAlignment(0);
        this.lblSmallIcon.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/palette/resources/unknown16.gif")));
        this.lblSmallIcon.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.lblSmallIcon.text"));
        this.lblSmallIcon.setBorder(BorderFactory.createEtchedBorder());
        this.lblSmallIcon.setFocusable(false);
        this.lblSmallIcon.setHorizontalTextPosition(0);
        this.lblSmallIcon.setIconTextGap(0);
        this.lblSmallIcon.setPreferredSize(new Dimension(40, 40));
        this.btnSelectSmallIcon.setMnemonic('S');
        this.btnSelectSmallIcon.setText(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.btnSelectSmallIcon.text"));
        this.btnSelectSmallIcon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextImporterUI.this.btnSelectSmallIconActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 449, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtTooltip, -1, 409, Short.MAX_VALUE).add((Component)this.txtName, -1, 409, Short.MAX_VALUE))).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.lblSmallIcon, -2, -1, -2).addPreferredGap(0).add((Component)this.btnSelectSmallIcon).add(14, 14, 14).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.lblLargeIcon, -2, -1, -2).addPreferredGap(0).add((Component)this.btnSelectLargeIcon)).add(1, (Component)this.jLabel5)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.txtName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.txtTooltip, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblSmallIcon, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.btnSelectSmallIcon).add((Component)this.jLabel4).add((Component)this.lblLargeIcon, -2, -1, -2).add((Component)this.btnSelectLargeIcon)).add(18, 18, 18).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 138, Short.MAX_VALUE).addContainerGap()));
        this.txtName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.txtName.AccessibleContext.accessibleName"));
        this.txtName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.txtName.AccessibleContext.accessibleDescription"));
        this.txtTooltip.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.txtTooltip.AccessibleContext.accessibleDescription"));
        this.lblLargeIcon.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.lblLargeIcon.AccessibleContext.accessibleName"));
        this.lblLargeIcon.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.lblLargeIcon.AccessibleContext.accessibleDescription"));
        this.btnSelectLargeIcon.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.btnSelectLargeIcon.AccessibleContext.accessibleDescription"));
        this.lblSmallIcon.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.lblSmallIcon.AccessibleContext.accessibleName"));
        this.lblSmallIcon.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.lblSmallIcon.AccessibleContext.accessibleDescription"));
        this.btnSelectSmallIcon.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TextImporterUI.class, (String)"TextImporterUI.btnSelectSmallIcon.AccessibleContext.accessibleDescription"));
    }

    private void btnSelectLargeIconActionPerformed(ActionEvent actionEvent) {
        Icon icon;
        File file = this.selectIconFile();
        if (null != file && null != (icon = this.readIconFromFile(file))) {
            this.lblLargeIcon.setIcon(icon);
            try {
                this.largeIconPath = file.toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private void btnSelectSmallIconActionPerformed(ActionEvent actionEvent) {
        Icon icon;
        File file = this.selectIconFile();
        if (null != file && null != (icon = this.readIconFromFile(file))) {
            this.lblSmallIcon.setIcon(icon);
            try {
                this.smallIconPath = file.toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private File selectIconFile() {
        JFileChooser jFileChooser = new JFileChooser(defaultFolder);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog(this) != 0) {
            return null;
        }
        defaultFolder = jFileChooser.getCurrentDirectory();
        return jFileChooser.getSelectedFile();
    }

    private Icon readIconFromFile(File file) {
        try {
            BufferedImage bufferedImage = ImageIO.read(file.toURL());
            if (null != bufferedImage) {
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                if (imageIcon.getIconWidth() > 32 || imageIcon.getIconHeight() > 32) {
                    JOptionPane.showMessageDialog(this, NbBundle.getMessage(TextImporterUI.class, (String)"Err_IconTooBig"), NbBundle.getMessage(TextImporterUI.class, (String)"Err_Title"), 0);
                    return null;
                }
                return imageIcon;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this, NbBundle.getMessage(TextImporterUI.class, (String)"Err_CannotLoadIconFromFile", (Object)file.getName()), NbBundle.getMessage(TextImporterUI.class, (String)"Err_Title"), 0);
        return null;
    }
}

