/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.ui.EditServerListDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class EditPathMapDialog
extends JPanel
implements ActionListener {
    private Dialog presenter;
    private String currentHkey;
    private DefaultComboBoxModel serverListModel;
    private final String pathToValidate;
    private final Map<String, DefaultTableModel> cache = new HashMap<String, DefaultTableModel>();
    private JComboBox cbHostsList;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblHostName;
    private JTable tblPathMappings;
    private JTextPane txtErrors;
    private JTextPane txtExplanation;

    public static boolean showMe(String string, String string2) {
        Dialog dialog;
        EditPathMapDialog editPathMapDialog = new EditPathMapDialog(string, string2);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editPathMapDialog, NbBundle.getMessage(EditServerListDialog.class, (String)"EditPathMapDialogTitle"), true, 2, null, (ActionListener)editPathMapDialog);
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        editPathMapDialog.presenter = dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            editPathMapDialog.applyChanges();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public EditPathMapDialog(String string, String string2) {
        void var3_6;
        this.pathToValidate = string2;
        this.currentHkey = string;
        this.serverListModel = new DefaultComboBoxModel();
        for (String string3 : RemoteServerList.getInstance().getServerNames()) {
            if ("localhost".equals(string3)) continue;
            this.serverListModel.addElement(string3);
        }
        this.initTableModel(this.currentHkey);
        this.initComponents();
        this.tblPathMappings.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblPathMappings.getTableHeader().setPreferredSize(new Dimension(0, 20));
        this.setColumnNames();
        this.cbHostsList.setSelectedItem(this.currentHkey);
        if (string2 != null) {
            String string4 = NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_ExplanationWithPath", (Object)string2);
        } else {
            String string5 = NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Explanation");
        }
        this.txtExplanation.setText((String)var3_6);
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.jScrollPane1.setOpaque(false);
            this.jScrollPane2.setOpaque(false);
            this.jScrollPane3.setOpaque(false);
        }
    }

    private static RemotePathMap getRemotePathMap(String string) {
        return RemotePathMap.getMapper(string);
    }

    private void initTableModel(String string) {
        DefaultTableModel defaultTableModel = this.cache.get(string);
        if (defaultTableModel == null) {
            RemotePathMap remotePathMap = EditPathMapDialog.getRemotePathMap(string);
            defaultTableModel = new DefaultTableModel(0, 2);
            for (String string2 : remotePathMap.keySet()) {
                defaultTableModel.addRow(new String[]{string2, (String)remotePathMap.get(string2)});
            }
            if (defaultTableModel.getRowCount() < 4) {
                for (int i = 4; i > defaultTableModel.getRowCount(); --i) {
                    defaultTableModel.addRow(new String[]{null, null});
                }
            } else {
                defaultTableModel.addRow(new String[]{null, null});
            }
            this.cache.put(string, defaultTableModel);
        }
        if (this.tblPathMappings != null) {
            this.tblPathMappings.setModel(defaultTableModel);
            this.setColumnNames();
        }
    }

    private void setColumnNames() {
        this.tblPathMappings.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(EditPathMapDialog.class, (String)"LocalPathColumnName"));
        this.tblPathMappings.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(EditPathMapDialog.class, (String)"RemotePathColumnName"));
    }

    void applyChanges() {
        for (String string : this.cache.keySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            DefaultTableModel defaultTableModel = this.cache.get(string);
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                String string2 = (String)defaultTableModel.getValueAt(i, 0);
                String string3 = (String)defaultTableModel.getValueAt(i, 1);
                if (string2 == null || string3 == null) continue;
                string2 = string2.trim();
                string3 = string3.trim();
                if (string2.length() <= 0 || string3.length() <= 0) continue;
                hashMap.put(string2, string3);
            }
            EditPathMapDialog.getRemotePathMap(string).updatePathMap(hashMap);
        }
    }

    private void initComponents() {
        this.lblHostName = new JLabel();
        this.cbHostsList = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tblPathMappings = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.txtExplanation = new JTextPane();
        this.jScrollPane3 = new JScrollPane();
        this.txtErrors = new JTextPane();
        this.lblHostName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("EPMD_Hostname").charAt(0));
        this.lblHostName.setLabelFor(this.cbHostsList);
        this.lblHostName.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.lblHostName.text"));
        this.lblHostName.setFocusable(false);
        this.cbHostsList.setModel(this.serverListModel);
        this.cbHostsList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EditPathMapDialog.this.cbHostsListItemStateChanged(itemEvent);
            }
        });
        this.tblPathMappings.setModel(this.cache.get(this.currentHkey));
        this.tblPathMappings.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblPathMappings);
        this.tblPathMappings.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AN"));
        this.tblPathMappings.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AD"));
        this.jScrollPane2.setBorder(null);
        this.txtExplanation.setBackground(new Color(240, 240, 240));
        this.txtExplanation.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.txtExplanation.setEditable(false);
        this.txtExplanation.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.txtExplanation.text"));
        this.txtExplanation.setFocusable(false);
        this.jScrollPane2.setViewportView(this.txtExplanation);
        this.jScrollPane3.setBorder(null);
        this.txtErrors.setBackground(new Color(240, 240, 240));
        this.txtErrors.setBorder(null);
        this.txtErrors.setFocusable(false);
        this.jScrollPane3.setViewportView(this.txtErrors);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane3, -1, 343, Short.MAX_VALUE).add(1, (Component)this.jScrollPane1, -1, 343, Short.MAX_VALUE).add(1, (Component)this.jScrollPane2, -1, 343, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblHostName).addPreferredGap(1).add((Component)this.cbHostsList, 0, 307, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblHostName).add((Component)this.cbHostsList, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 58, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 86, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jScrollPane3, -2, 64, -2).addContainerGap()));
        this.lblHostName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Hostname"));
        this.lblHostName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Host_AD"));
        this.cbHostsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Hostname"));
        this.cbHostsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Host_AD"));
    }

    private void cbHostsListItemStateChanged(ItemEvent itemEvent) {
        this.currentHkey = (String)this.cbHostsList.getSelectedItem();
        this.initTableModel(this.currentHkey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.validateMaps()) {
            this.presenter.setVisible(false);
        }
    }

    private boolean validateMaps() {
        boolean bl = true;
        DefaultTableModel defaultTableModel = this.cache.get(this.currentHkey);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            String string = (String)defaultTableModel.getValueAt(i, 0);
            String string2 = (String)defaultTableModel.getValueAt(i, 1);
            if (string != null && (string = string.trim()).length() > 0) {
                if (!HostInfoProvider.getDefault().fileExists("localhost", string)) {
                    bl = false;
                    stringBuilder.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_BadLocalPath", (Object)string));
                }
                if (this.pathToValidate != null && !bl2 && string2 != null && RemotePathMap.isSubPath(string, this.pathToValidate)) {
                    bl2 = true;
                }
            }
            if (string2 == null || (string2 = string2.trim()).length() <= 0 || HostInfoProvider.getDefault().fileExists(this.currentHkey, string2)) continue;
            bl = false;
            stringBuilder.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_BadRemotePath", (Object)string2));
        }
        if (this.pathToValidate != null && !bl2) {
            bl = false;
            stringBuilder.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_PathNotResolved", (Object)this.pathToValidate));
        }
        this.txtErrors.setText(stringBuilder.toString());
        return bl;
    }
}

