/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderSamba;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderUnix;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderWindows;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostMappingsAnalyzer {
    private final PlatformInfo secondPI;
    private final PlatformInfo firstPI;
    private final List<HostMappingProvider> providers;

    public HostMappingsAnalyzer(String string) {
        this(string, "localhost");
    }

    public HostMappingsAnalyzer(String string, String string2) {
        this.secondPI = PlatformInfo.getDefault((String)string);
        this.firstPI = PlatformInfo.getDefault((String)string2);
        this.providers = new ArrayList<HostMappingProvider>();
        this.providers.add(new HostMappingProviderWindows());
        this.providers.add(new HostMappingProviderSamba());
        this.providers.add(new HostMappingProviderUnix());
    }

    public Map<String, String> getMappings() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map = this.populateMappingsList(this.firstPI, this.secondPI);
        Map<String, String> map2 = this.populateMappingsList(this.secondPI, this.firstPI);
        if (map.size() > 0 && map2.size() > 0) {
            for (String string : map.keySet()) {
                for (String string2 : map2.keySet()) {
                    if (!string.equals(string2)) continue;
                    hashMap.put(map.get(string), map2.get(string2));
                }
            }
        }
        return hashMap;
    }

    private Map<String, String> populateMappingsList(PlatformInfo platformInfo, PlatformInfo platformInfo2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (HostMappingProvider hostMappingProvider : this.providers) {
            if (!hostMappingProvider.isApplicable(platformInfo, platformInfo2)) continue;
            hashMap.putAll(hostMappingProvider.findMappings(platformInfo.getHkey(), platformInfo2.getHkey()));
        }
        return hashMap;
    }
}

