/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.netbeans.modules.ruby.testrunner.ui.OutputDocument;

final class OutputView
extends PlainView {
    private final Segment SEGMENT = new Segment();
    private final OutputDocument.RootElement rootElement;
    private int selStart;
    private int selEnd;
    private static Color selectedErr;
    private static Color unselectedErr;
    private static Map hintsMap;
    private Color selectedFg;
    private Color unselectedFg;
    private static final boolean antialias;

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = antialias ? Collections.singletonMap(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON) : Collections.emptyMap();
        }
        return hintsMap;
    }

    OutputView(Element element) {
        super(element);
        this.rootElement = (OutputDocument.RootElement)element;
    }

    public void paint(Graphics graphics, Shape shape) {
        ((Graphics2D)graphics).addRenderingHints(OutputView.getHints());
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        this.selStart = jTextComponent.getSelectionStart();
        this.selEnd = jTextComponent.getSelectionEnd();
        this.unselectedFg = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        this.selectedFg = jTextComponent.getCaret().isSelectionVisible() ? jTextComponent.getSelectedTextColor() : this.unselectedFg;
        super.paint(graphics, shape);
    }

    protected void drawLine(int n, Graphics graphics, int n2, int n3) {
        OutputDocument.DocElement docElement = this.rootElement.getDocElement(n);
        try {
            this.drawLine(docElement, graphics, n2, n3);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException("cannot draw line " + n);
        }
    }

    private void drawLine(OutputDocument.DocElement docElement, Graphics graphics, int n, int n2) throws BadLocationException {
        int n3 = docElement.getStartOffset();
        int n4 = docElement.getEndOffset();
        boolean bl = docElement.isError;
        if (this.selStart == this.selEnd || this.selectedFg == this.unselectedFg) {
            n = this.drawText(graphics, n, n2, n3, n4, bl, false, docElement);
        } else if (n3 >= this.selStart && n3 <= this.selEnd && n4 >= this.selStart && n4 <= this.selEnd) {
            n = this.drawText(graphics, n, n2, n3, n4, bl, true, docElement);
        } else if (this.selStart >= n3 && this.selStart <= n4) {
            if (this.selEnd >= n3 && this.selEnd <= n4) {
                n = this.drawText(graphics, n, n2, n3, this.selStart, bl, false, docElement);
                n = this.drawText(graphics, n, n2, this.selStart, this.selEnd, bl, true, docElement);
                n = this.drawText(graphics, n, n2, this.selEnd, n4, bl, false, docElement);
            } else {
                n = this.drawText(graphics, n, n2, n3, this.selStart, bl, false, docElement);
                n = this.drawText(graphics, n, n2, this.selStart, n4, bl, true, docElement);
            }
        } else if (this.selEnd >= n3 && this.selEnd <= n4) {
            n = this.drawText(graphics, n, n2, n3, this.selEnd, bl, true, docElement);
            n = this.drawText(graphics, n, n2, this.selEnd, n4, bl, false, docElement);
        } else {
            n = this.drawText(graphics, n, n2, n3, n4, bl, false, docElement);
        }
    }

    private int drawText(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, OutputDocument.DocElement docElement) throws BadLocationException {
        Segment segment = EventQueue.isDispatchThread() ? this.SEGMENT : new Segment();
        segment.array = docElement.getChars();
        segment.offset = n3 - docElement.offset;
        segment.count = n4 - n3;
        graphics.setColor(this.getColor(bl, bl2));
        return Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3);
    }

    private Color getColor(boolean bl, boolean bl2) {
        return bl ? (bl2 ? selectedErr : unselectedErr) : (bl2 ? this.selectedFg : this.unselectedFg);
    }

    static {
        hintsMap = null;
        antialias = Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID());
        selectedErr = UIManager.getColor("nb.output.err.foreground.selected");
        if (selectedErr == null) {
            selectedErr = new Color(164, 0, 0);
        }
        if ((unselectedErr = UIManager.getColor("nb.output.err.foreground")) == null) {
            unselectedErr = selectedErr;
        }
    }
}

