/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class AppProjectGenerator {
    private AppProjectGenerator() {
    }

    static FileObject createProjectFromTemplate(FileObject fileObject, File file, String[] stringArray, String[] stringArray2) throws IOException {
        FileObject fileObject2;
        Stack<String> stack = new Stack<String>();
        while ((fileObject2 = FileUtil.toFileObject((File)file)) == null) {
            stack.push(file.getName());
            file = file.getParentFile();
        }
        while (!stack.empty()) {
            fileObject2 = fileObject2.createFolder((String)stack.pop());
        }
        AppProjectGenerator.unzip(fileObject, fileObject2, stringArray, stringArray2);
        fileObject2.refresh(false);
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(FileObject fileObject, FileObject fileObject2, String[] stringArray, String[] stringArray2) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(fileObject.getInputStream());
        ReplacingOutputStream replacingOutputStream = new ReplacingOutputStream(stringArray, stringArray2);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
                replacingOutputStream.setOutput(byteArrayOutputStream);
                replacingOutputStream.write(string.getBytes());
                replacingOutputStream.close();
                string = byteArrayOutputStream.toString("UTF-8");
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject2, (String)string);
                    continue;
                }
                FileObject fileObject3 = FileUtil.createData((FileObject)fileObject2, (String)string);
                FileLock fileLock = fileObject3.lock();
                try {
                    OutputStream outputStream = fileObject3.getOutputStream(fileLock);
                    String string2 = null;
                    boolean bl = false;
                    String string3 = fileObject3.getExt().toLowerCase();
                    if (string3.endsWith("java")) {
                        string2 = FileEncodingQuery.getDefaultEncoding().name();
                    } else if (string3.endsWith("form") || string3.endsWith("xml")) {
                        string2 = "UTF-8";
                    } else if (string3.endsWith("properties")) {
                        string2 = "ISO-8859-1";
                        bl = true;
                    } else if (string.startsWith("src/META-INF/")) {
                        string2 = FileEncodingQuery.getDefaultEncoding().name();
                    }
                    if (string2 != null || bl) {
                        replacingOutputStream.setOutput(outputStream, string2, bl);
                        outputStream = replacingOutputStream;
                    }
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    static FileObject getGeneratedFile(FileObject fileObject, String string, String[] stringArray, String[] stringArray2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        ReplacingOutputStream replacingOutputStream = new ReplacingOutputStream(stringArray, stringArray2);
        replacingOutputStream.setOutput(byteArrayOutputStream);
        try {
            replacingOutputStream.write(string.getBytes());
            replacingOutputStream.close();
            string = byteArrayOutputStream.toString("UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileObject.getFileObject(string);
    }

    private static class ReplacingOutputStream
    extends OutputStream {
        private OutputStream output;
        private String[] toReplace;
        private String[] replaceWith;
        private int[] matchCounts;
        private StringBuilder pendingChars;
        private boolean forcePathNames;
        private String encoding;
        private boolean propertiesEncoding;

        ReplacingOutputStream(String[] stringArray, String[] stringArray2) {
            this.toReplace = stringArray;
            this.replaceWith = stringArray2;
            this.pendingChars = new StringBuilder(50);
        }

        void setOutput(OutputStream outputStream) {
            this.output = outputStream;
            this.forcePathNames = true;
            this.encoding = "UTF-8";
            this.propertiesEncoding = false;
            this.matchCounts = new int[this.toReplace.length];
        }

        void setOutput(OutputStream outputStream, String string, boolean bl) {
            this.output = outputStream;
            this.forcePathNames = false;
            this.encoding = string;
            this.propertiesEncoding = bl;
            this.matchCounts = new int[this.toReplace.length];
        }

        public void write(int n) throws IOException {
            int n2;
            int n3 = -1;
            boolean bl = false;
            for (n2 = 0; n2 < this.toReplace.length; ++n2) {
                String string = this.toReplace[n2];
                int n4 = this.matchCounts[n2];
                if (string.charAt(n4) == n) {
                    if (n4 + 1 == string.length()) {
                        n3 = n2;
                        break;
                    }
                    this.matchCounts[n2] = n4 + 1;
                    bl = true;
                    continue;
                }
                this.matchCounts[n2] = 0;
            }
            if (n3 >= 0) {
                n2 = this.pendingChars.length() - this.matchCounts[n3];
                if (n2 > 0) {
                    this.output.write(this.pendingChars.substring(0, n2).getBytes());
                }
                String string = this.replaceWith[n3];
                if (this.forcePathNames) {
                    string = string.replace('.', '/');
                }
                this.output.write(this.encode(string));
                for (int i = 0; i < this.matchCounts.length; ++i) {
                    this.matchCounts[i] = 0;
                }
                this.pendingChars.delete(0, this.pendingChars.length());
            } else if (bl) {
                this.pendingChars.append((char)n);
            } else {
                this.writePendingBytes();
                this.output.write(n);
            }
        }

        private byte[] encode(String string) {
            if (this.propertiesEncoding) {
                string = UtilConvert.saveConvert((String)string);
            }
            if (this.encoding != null) {
                try {
                    return string.getBytes(this.encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Logger.getLogger(AppProjectGenerator.class.getName()).log(Level.INFO, "", unsupportedEncodingException);
                }
            }
            return string.getBytes();
        }

        private void writePendingBytes() throws IOException {
            if (this.pendingChars.length() > 0) {
                this.output.write(this.pendingChars.toString().getBytes());
                this.pendingChars.delete(0, this.pendingChars.length());
            }
        }

        public void flush() throws IOException {
            this.writePendingBytes();
            this.output.flush();
        }

        public void close() throws IOException {
            this.writePendingBytes();
            this.output.close();
        }
    }
}

