/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.navigation;

import java.util.ArrayList;
import java.util.Hashtable;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.ProjectNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.model.navigation.Link;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkableSource;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkableTarget;
import org.netbeans.modules.visualweb.gravy.model.project.Project;
import org.netbeans.modules.visualweb.gravy.navigation.NavigatorOperator;

public class LinkManager {
    private static final String bundle = "org.netbeans.modules.visualweb.gravy.model.navigation.Bundle";
    private static final String navigationBundle = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.navigation.Bundle", "NavigationBundle");
    private static final String nodeNavigation = Bundle.getStringTrimmed(navigationBundle, Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.navigation.Bundle", "PageNavigation"));
    private static final String popupOpen = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.navigation.Bundle", "OpenPopupItem");
    private Project project;
    private Hashtable links = new Hashtable();

    public LinkManager(Project project) {
        this.project = project;
    }

    public Link createLink(LinkableSource linkableSource, LinkableTarget linkableTarget, String string) {
        ProjectNavigatorOperator projectNavigatorOperator = ProjectNavigatorOperator.showProjectNavigator();
        TestUtils.wait(1000);
        try {
            ProjectNavigatorOperator.pressPopupItemOnNode(this.project.getName() + "|" + nodeNavigation, popupOpen, (Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
        }
        catch (Exception exception) {
            throw new JemmyException(popupOpen + " item in popup menu of " + nodeNavigation + " node can't be found!", (Throwable)exception);
        }
        TestUtils.wait(1000);
        NavigatorOperator navigatorOperator = new NavigatorOperator();
        TestUtils.wait(1000);
        try {
            navigatorOperator.linkUsingXmlSource(linkableSource.getLinkableSourceName(), linkableTarget.getLinkableTargetName(), string);
        }
        catch (Exception exception) {
            throw new JemmyException("Link can't be created!", (Throwable)exception);
        }
        TestUtils.wait(1000);
        Link link = new Link(linkableSource, linkableTarget, string);
        this.links.put(string, link);
        return link;
    }

    public void changeSource(Link link, LinkableSource linkableSource) {
        link.source = linkableSource;
    }

    public void changeTarget(Link link, LinkableTarget linkableTarget) {
        link.target = linkableTarget;
    }

    public void changeName(Link link, String string) {
        link.name = string;
    }

    public void deleteLink(Link link) {
        this.links.remove(link.getName());
    }

    public Link[] getLinks() {
        return this.links.values().toArray(new Link[this.links.size()]);
    }

    public Link[] getFromLinks(LinkableSource linkableSource) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Link[] linkArray = this.links.values().toArray(new Link[this.links.size()]);
        for (int i = 0; i < linkArray.length; ++i) {
            if (!linkArray[i].getSource().equals(linkableSource)) continue;
            arrayList.add(linkArray[i]);
        }
        return arrayList.toArray(new Link[arrayList.size()]);
    }

    public Link[] getToLinks(LinkableTarget linkableTarget) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Link[] linkArray = this.links.values().toArray(new Link[this.links.size()]);
        for (int i = 0; i < linkArray.length; ++i) {
            if (!linkArray[i].getTarget().equals(linkableTarget)) continue;
            arrayList.add(linkArray[i]);
        }
        return arrayList.toArray(new Link[arrayList.size()]);
    }
}

