/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JComponent;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class TopComponentOperator
extends JComponentOperator {
    public TopComponentOperator(ContainerOperator containerOperator, String string) {
        super(containerOperator, (ComponentChooser)new TopComponentChooser(string));
    }

    public TopComponentOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        super(containerOperator, componentChooser);
    }

    public TopComponentOperator(JComponent jComponent) {
        super(jComponent);
    }

    protected static JComponent findTopComponent(ContainerOperator containerOperator, String string, int n, ComponentChooser componentChooser) {
        TopComponent topComponent;
        int n2;
        Object[] objectArray = TopComponent.getRegistry().getOpened().toArray();
        Operator.StringComparator stringComparator = containerOperator == null ? Operator.getDefaultStringComparator() : containerOperator.getComparator();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            topComponent = (TopComponent)objectArray[n2];
            if (!topComponent.isShowing() || !stringComparator.equals(topComponent.getName(), string) || !TopComponentOperator.isUnder(containerOperator, (Component)topComponent) || componentChooser != null && !componentChooser.checkComponent((Component)topComponent) || --n >= 0) continue;
            return topComponent;
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            topComponent = (TopComponent)objectArray[n2];
            if (topComponent.isShowing() || !TopComponentOperator.isParentShowing((Component)topComponent) || !stringComparator.equals(topComponent.getName(), string) || !TopComponentOperator.isUnder(containerOperator, (Component)topComponent) || componentChooser != null && !componentChooser.checkComponent((Component)topComponent) || --n >= 0) continue;
            return topComponent;
        }
        return null;
    }

    private static boolean isParentShowing(Component component) {
        while (component != null) {
            if (component.isShowing()) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    private static boolean isUnder(ContainerOperator containerOperator, Component component) {
        if (containerOperator == null) {
            return true;
        }
        Component component2 = containerOperator.getSource();
        while (component2 != component && component != null) {
            component = component.getParent();
        }
        return component2 == component;
    }

    public void close() {
        new Thread(new Runnable(){

            public void run() {
                TopComponentOperator.this.runMapping(new Operator.MapVoidAction("close"){

                    public void map() {
                        ((TopComponent)TopComponentOperator.this.getSource()).close();
                    }
                });
            }
        }, "thread to close TopComponent").start();
        this.waitComponentShowing(false);
    }

    public void waitClosed() {
        this.getOutput().printLine("Wait topcomponent to be closed \n    : " + this.getSource().toString());
        this.getOutput().printGolden("Wait topcomponent to be closed");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return !component.isVisible();
            }

            public String getDescription() {
                return "Closed topcomponent";
            }
        });
    }

    public void save() {
        Node[] nodeArray = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                SaveCookie saveCookie = (SaveCookie)nodeArray[i].getCookie(SaveCookie.class);
                if (saveCookie == null) continue;
                try {
                    saveCookie.save();
                    continue;
                }
                catch (IOException iOException) {
                    throw new JemmyException("Exception while saving this TopComponent.", (Throwable)iOException);
                }
            }
        }
    }

    public void closeDiscard() {
        this.setUnmodified();
        this.close();
    }

    private void setUnmodified() {
        Node[] nodeArray = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
                dataObject.setModified(false);
            }
        }
    }

    protected static JComponent waitTopComponent(String string, int n) {
        return TopComponentOperator.waitTopComponent(null, string, n, null);
    }

    protected static JComponent waitTopComponent(final ContainerOperator containerOperator, final String string, final int n, final ComponentChooser componentChooser) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return TopComponentOperator.findTopComponent(containerOperator, string, n, componentChooser);
                }

                public String getDescription() {
                    return "Wait TopComponent with name=" + string + " index=" + String.valueOf(n) + (componentChooser == null ? "" : " subchooser=" + componentChooser.getDescription()) + " loaded";
                }
            });
            Timeouts timeouts = JemmyProperties.getCurrentTimeouts().cloneThis();
            timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("ComponentOperator.WaitComponentTimeout"));
            waiter.setTimeouts(timeouts);
            waiter.setOutput(JemmyProperties.getCurrentOutput());
            return (JComponent)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public static class TopComponentChooser
    implements ComponentChooser {
        String ID;

        public TopComponentChooser(String string) {
            this.ID = string;
        }

        public boolean checkComponent(Component component) {
            return component instanceof TopComponent && component != null && ((TopComponent)component).getName() != null && ((TopComponent)component).getName().indexOf(this.ID) != -1;
        }

        public String getDescription() {
            return "A TopComponent with \"" + this.ID + "\" ID";
        }
    }
}

