/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Component;
import java.awt.Container;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.DeploymentDialogOperator;
import org.netbeans.modules.visualweb.gravy.RaveWindowOperator;
import org.netbeans.modules.visualweb.gravy.Util;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.Toolbar;

public class MainWindowOperator
extends JFrameOperator {
    JButtonOperator deployButton;
    private static StatusTextTracer statusTextTracer = null;

    public MainWindowOperator() {
        super((JFrame)RaveWindowOperator.getDefaultRave().getSource());
        this.copyEnvironment((Operator)RaveWindowOperator.getDefaultRave());
    }

    public void saveAll() {
        new JButtonOperator((ContainerOperator)this, (ComponentChooser)new JComponentOperator.JComponentByTipFinder("Save All")).push();
    }

    public DeploymentDialogOperator deploy() {
        this.btDeploy().push();
        DeploymentDialogOperator deploymentDialogOperator = null;
        long l = Util.getMainWindow().getTimeouts().getTimeout("DialogWaiter.WaitDialogTimeout");
        try {
            Util.getMainWindow().getTimeouts().setTimeout("DialogWaiter.WaitDialogTimeout", 100000L);
            deploymentDialogOperator = new DeploymentDialogOperator();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Util.getMainWindow().getTimeouts().setTimeout("DialogWaiter.WaitDialogTimeout", l);
        }
        return deploymentDialogOperator;
    }

    public void deployProject() {
        DeploymentDialogOperator deploymentDialogOperator = this.deploy();
        deploymentDialogOperator.setAutoHide(false);
        deploymentDialogOperator.waitCompleted();
        Util.wait(1000);
        deploymentDialogOperator.close();
    }

    public JButtonOperator btDeploy() {
        if (this.deployButton == null) {
            this.deployButton = new JButtonOperator((ContainerOperator)this, (ComponentChooser)new JComponentOperator.JComponentByTipFinder(Bundle.getStringTrimmed("org.netbeans.modules.project.ui.actions.Bundle", "LBL_RunMainProjectAction_Name")));
            this.deployButton.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 60000L);
        }
        return this.deployButton;
    }

    public String getStatusText() {
        return StatusDisplayer.getDefault().getStatusText();
    }

    public void setStatusText(String string) {
        StatusDisplayer.getDefault().setStatusText(string);
    }

    public synchronized StatusTextTracer getStatusTextTracer() {
        if (statusTextTracer == null) {
            statusTextTracer = new StatusTextTracer();
        }
        return statusTextTracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitStatusText(String string) {
        this.getStatusTextTracer().start();
        try {
            if (!this.getComparator().equals(this.getStatusText(), string)) {
                this.getStatusTextTracer().waitText(string);
            }
        }
        finally {
            this.getStatusTextTracer().stop();
        }
    }

    public ContainerOperator getToolbar(int n) {
        ToolbarChooser toolbarChooser = new ToolbarChooser();
        return new ContainerOperator((Container)MainWindowOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)toolbarChooser, (int)n));
    }

    public ContainerOperator getToolbar(String string) {
        ToolbarChooser toolbarChooser = new ToolbarChooser(string, this.getComparator());
        return new ContainerOperator((Container)MainWindowOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)toolbarChooser));
    }

    public int getToolbarCount() {
        ToolbarChooser toolbarChooser = new ToolbarChooser("Non sense name - @#$%^&*", this.getComparator());
        MainWindowOperator.findComponent((Container)((Container)this.getSource()), (ComponentChooser)toolbarChooser);
        return toolbarChooser.getCount();
    }

    public String getToolbarName(int n) {
        return ((Toolbar)this.getToolbar(n).getSource()).getDisplayName();
    }

    public JButtonOperator getToolbarButton(ContainerOperator containerOperator, String string) {
        ToolbarButtonChooser toolbarButtonChooser = new ToolbarButtonChooser(string, this.getComparator());
        return new JButtonOperator(JButtonOperator.waitJButton((Container)((Container)containerOperator.getSource()), (ComponentChooser)toolbarButtonChooser));
    }

    public JButtonOperator getToolbarButton(ContainerOperator containerOperator, int n) {
        return new JButtonOperator(containerOperator, n);
    }

    public void pushToolbarPopupMenu(String string) {
        ContainerOperator containerOperator = this.getToolbar(0);
        containerOperator.clickForPopup(containerOperator.getWidth() - 1, containerOperator.getHeight() / 2);
        new JPopupMenuOperator().pushMenu(string, "|");
    }

    public void pushToolbarPopupMenuNoBlock(String string) {
        ContainerOperator containerOperator = this.getToolbar(0);
        containerOperator.clickForPopup(containerOperator.getWidth() - 1, containerOperator.getHeight() / 2);
        new JPopupMenuOperator().pushMenuNoBlock(string, "|");
    }

    public void dragNDropToolbar(ContainerOperator containerOperator, int n, int n2) {
        ComponentChooser componentChooser = new ComponentChooser(){

            public boolean checkComponent(Component component) {
                if (component instanceof JPanel) {
                    String string = component.getClass().getName();
                    return string.equals("org.openide.awt.Toolbar$ToolbarBump") || string.equals("org.openide.awt.Toolbar$ToolbarGrip");
                }
                return false;
            }

            public String getDescription() {
                return "org.openide.awt.Toolbar$ToolbarBump or org.openide.awt.Toolbar$ToolbarGrip";
            }
        };
        Component component = MainWindowOperator.findComponent((Container)((Container)containerOperator.getSource()), (ComponentChooser)componentChooser);
        new ComponentOperator(component).dragNDrop(component.getWidth() / 2, component.getHeight() / 2, n, n2);
    }

    private static class ToolbarButtonChooser
    implements ComponentChooser {
        private String buttonTooltip;
        private Operator.StringComparator comparator;

        public ToolbarButtonChooser(String string, Operator.StringComparator stringComparator) {
            this.buttonTooltip = string;
            this.comparator = stringComparator;
        }

        public boolean checkComponent(Component component) {
            return this.comparator.equals(((JComponent)component).getToolTipText(), this.buttonTooltip);
        }

        public String getDescription() {
            return "Toolbar button with tooltip \"" + this.buttonTooltip + "\".";
        }
    }

    private static class ToolbarChooser
    implements ComponentChooser {
        private String toolbarName;
        private Operator.StringComparator comparator;
        private int count = 0;

        public ToolbarChooser(String string, Operator.StringComparator stringComparator) {
            this.toolbarName = string;
            this.comparator = stringComparator;
        }

        public ToolbarChooser() {
            this.comparator = null;
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Toolbar) {
                ++this.count;
                if (this.comparator != null) {
                    return this.comparator.equals(((Toolbar)component).getDisplayName(), this.toolbarName);
                }
                return true;
            }
            return false;
        }

        public String getDescription() {
            return "org.openide.awt.Toolbar";
        }

        public int getCount() {
            return this.count;
        }
    }

    public class StatusTextTracer
    implements ChangeListener {
        private ArrayList statusTextHistory = new ArrayList();

        public void start() {
            this.stop();
            this.clear();
            StatusDisplayer.getDefault().addChangeListener((ChangeListener)this);
        }

        public void stop() {
            StatusDisplayer.getDefault().removeChangeListener((ChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            StatusTextTracer statusTextTracer = this;
            synchronized (statusTextTracer) {
                this.statusTextHistory.add(StatusDisplayer.getDefault().getStatusText());
                JemmyProperties.getCurrentOutput().printTrace("Status text changed to: \"" + StatusDisplayer.getDefault().getStatusText() + "\"");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            StatusTextTracer statusTextTracer = this;
            synchronized (statusTextTracer) {
                this.statusTextHistory.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(String string, boolean bl) {
            Operator.StringComparator stringComparator = MainWindowOperator.this.getComparator();
            StatusTextTracer statusTextTracer = this;
            synchronized (statusTextTracer) {
                if (bl) {
                    while (!this.statusTextHistory.isEmpty()) {
                        String string2 = (String)this.statusTextHistory.remove(0);
                        if (!stringComparator.equals(string2, string)) continue;
                        return true;
                    }
                } else {
                    for (int i = 0; i < this.statusTextHistory.size(); ++i) {
                        if (!stringComparator.equals((String)this.statusTextHistory.get(i), string)) continue;
                        return true;
                    }
                }
                return false;
            }
        }

        public void waitText(String string) {
            this.waitText(string, false);
        }

        public void waitText(final String string, final boolean bl) {
            try {
                new Waiter(new Waitable(){

                    public Object actionProduced(Object object) {
                        return StatusTextTracer.this.contains(string, bl) ? Boolean.TRUE : null;
                    }

                    public String getDescription() {
                        return "Wait status text equals to " + string;
                    }
                }).waitAction(null);
            }
            catch (InterruptedException interruptedException) {
                throw new JemmyException("Interrupted.", (Throwable)interruptedException);
            }
        }

        public void finalize() {
            this.stop();
        }

        public ArrayList getStatusTextHistory() {
            return this.statusTextHistory;
        }

        public void printStatusTextHistory(PrintStream printStream) {
            for (int i = 0; i < this.statusTextHistory.size(); ++i) {
                printStream.println(this.statusTextHistory.get(i).toString());
            }
        }
    }
}

