/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.SecurityUtilities;

public abstract class RhinoException
extends RuntimeException {
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;
    Object interpreterStackInfo;
    int[] interpreterLineData;

    RhinoException() {
        Interpreter.captureInterpreterStackInfo(this);
    }

    RhinoException(String string) {
        super(string);
        Interpreter.captureInterpreterStackInfo(this);
    }

    public final String getMessage() {
        String string = this.details();
        if (this.sourceName == null || this.lineNumber <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" (");
        if (this.sourceName != null) {
            stringBuffer.append(this.sourceName);
        }
        if (this.lineNumber > 0) {
            stringBuffer.append('#');
            stringBuffer.append(this.lineNumber);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String details() {
        return super.getMessage();
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final void initSourceName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceName != null) {
            throw new IllegalStateException();
        }
        this.sourceName = string;
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final void initLineNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.lineNumber > 0) {
            throw new IllegalStateException();
        }
        this.lineNumber = n;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public final void initColumnNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.columnNumber > 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = n;
    }

    public final String lineSource() {
        return this.lineSource;
    }

    public final void initLineSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.lineSource != null) {
            throw new IllegalStateException();
        }
        this.lineSource = string;
    }

    final void recordErrorOrigin(String string, int n, String string2, int n2) {
        if (n == -1) {
            n = 0;
        }
        if (string != null) {
            this.initSourceName(string);
        }
        if (n != 0) {
            this.initLineNumber(n);
        }
        if (string2 != null) {
            this.initLineSource(string2);
        }
        if (n2 != 0) {
            this.initColumnNumber(n2);
        }
    }

    private String generateStackTrace() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        super.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        return Interpreter.getPatchedStack(this, string);
    }

    public String getScriptStackTrace() {
        return this.getScriptStackTrace(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".js");
            }
        });
    }

    public String getScriptStackTrace(FilenameFilter filenameFilter) {
        List list = Interpreter.getScriptStack(this);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        String string = SecurityUtilities.getSystemProperty("line.separator");
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string2 = stackTraceElement.getFileName();
            if (stackTraceElement.getLineNumber() > -1 && string2 != null && filenameFilter.accept(null, string2)) {
                stringBuffer.append("\tat ");
                stringBuffer.append(stackTraceElement.getFileName());
                stringBuffer.append(':');
                stringBuffer.append(stackTraceElement.getLineNumber());
                stringBuffer.append(string);
                continue;
            }
            if (list == null || !"org.mozilla.javascript.Interpreter".equals(stackTraceElement.getClassName()) || !"interpretLoop".equals(stackTraceElement.getMethodName())) continue;
            stringBuffer.append(list.get(n++));
        }
        return stringBuffer.toString();
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printWriter);
        } else {
            printWriter.print(this.generateStackTrace());
        }
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printStream);
        } else {
            printStream.print(this.generateStackTrace());
        }
    }
}

