/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedController
extends OptionsPanelController {
    private String tabFolder;
    private Lookup.Result<AdvancedOption> options;
    private Map<String, OptionsPanelController> id2Controller;
    private Map<JComponent, OptionsPanelController> component2Option;
    private final LookupListener lookupListener = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            TabbedController.this.readPanels();
        }
    };
    private JTabbedPane pane;
    private Map<OptionsPanelController, AdvancedOption> controllers2Options;
    private List<OptionsPanelController> controllers;

    public TabbedController(String string) {
        this.tabFolder = string;
        this.readPanels();
        this.options.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, this.options));
    }

    @Override
    public void update() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.update();
        }
    }

    @Override
    public void applyChanges() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.applyChanges();
        }
    }

    @Override
    public void cancel() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            optionsPanelController.cancel();
        }
    }

    @Override
    public boolean isValid() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            if (optionsPanelController.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isChanged() {
        for (OptionsPanelController optionsPanelController : this.getControllers()) {
            if (!optionsPanelController.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getComponent(Lookup lookup) {
        if (this.pane == null) {
            this.pane = new JTabbedPane();
            this.component2Option = new HashMap<JComponent, OptionsPanelController>();
            for (OptionsPanelController optionsPanelController : this.getControllers()) {
                JComponent jComponent = optionsPanelController.getComponent(optionsPanelController.getLookup());
                jComponent.setBorder(new EmptyBorder(8, 8, 8, 8));
                this.pane.add(this.controllers2Options.get(optionsPanelController).getDisplayName(), jComponent);
                this.component2Option.put(jComponent, optionsPanelController);
            }
        }
        return this.pane;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return this.pane != null ? this.getHelpCtx(this.pane.getSelectedComponent()) : null;
    }

    private HelpCtx getHelpCtx(Component component) {
        OptionsPanelController optionsPanelController = this.component2Option.get(component);
        if (optionsPanelController != null) {
            return optionsPanelController.getHelpCtx();
        }
        return new HelpCtx("netbeans.optionsDialog.java");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    protected void setCurrentSubcategory(String string) {
        String string2 = string.indexOf(47) == -1 ? string : string.substring(0, string.indexOf(47));
        OptionsPanelController optionsPanelController = this.id2Controller.get(string2);
        if (optionsPanelController == null) {
            return;
        }
        JComponent jComponent = optionsPanelController.getComponent(optionsPanelController.getLookup());
        if (jComponent != this.pane.getSelectedComponent()) {
            this.pane.setSelectedComponent(jComponent);
        }
    }

    private synchronized Collection<OptionsPanelController> getControllers() {
        if (this.controllers == null) {
            this.id2Controller = new HashMap<String, OptionsPanelController>();
            this.controllers2Options = new LinkedHashMap<OptionsPanelController, AdvancedOption>();
            this.controllers = new LinkedList<OptionsPanelController>();
            for (Lookup.Item item : this.options.allItems()) {
                AdvancedOption advancedOption = (AdvancedOption)item.getInstance();
                OptionsPanelController optionsPanelController = advancedOption.create();
                String string = item.getId().substring(item.getId().lastIndexOf(47) + 1);
                this.id2Controller.put(string, optionsPanelController);
                this.controllers2Options.put(optionsPanelController, advancedOption);
                this.controllers.add(optionsPanelController);
            }
        }
        return this.controllers;
    }

    private void readPanels() {
        Lookup lookup = Lookups.forPath((String)this.tabFolder);
        this.options = lookup.lookup(new Lookup.Template(AdvancedOption.class));
    }
}

