/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Image;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.options.TabbedController;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsCategoryImpl
extends OptionsCategory {
    private String title;
    private String categoryName;
    private String iconBase;
    private ImageIcon icon;
    private OptionsPanelController controller;
    private String description;
    private String keywords;
    private String keywordsCategory;
    private String advancedOptionsFolder;

    public OptionsCategoryImpl(String string, String string2, String string3, OptionsPanelController optionsPanelController, String string4, String string5, String string6, String string7) {
        assert (optionsPanelController != null || string7 != null);
        this.title = string;
        this.categoryName = string2;
        this.iconBase = string3;
        this.controller = optionsPanelController;
        this.advancedOptionsFolder = string7;
        this.description = string4;
        this.keywords = string5;
        this.keywordsCategory = string6;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            Image image = Utilities.loadImage((String)this.iconBase);
            if (image != null) {
                return new ImageIcon(image);
            }
            image = Utilities.loadImage((String)(this.iconBase + ".png"));
            if (image != null) {
                return new ImageIcon(image);
            }
            image = Utilities.loadImage((String)(this.iconBase + ".gif"));
            if (image == null) {
                return null;
            }
            this.icon = new ImageIcon(image);
        }
        return this.icon;
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public OptionsPanelController create() {
        if (this.controller != null) {
            return this.controller;
        }
        return new TabbedController(this.advancedOptionsFolder);
    }

    final Map<String, Set<String>> getKeywordsByCategory() {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        if (this.keywordsCategory != null && this.keywords != null) {
            hashMap.put(this.keywordsCategory, new HashSet<Object>(Collections.list(new StringTokenizer(this.keywords, ","))));
        }
        return hashMap;
    }
}

