/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent;

import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.WeakListeners;

public final class CodeStylePreferences
implements PreferenceChangeListener,
Runnable {
    private static final Logger LOG = Logger.getLogger(CodeStylePreferences.class.getName());
    private static final String NODE_CODE_STYLE = "CodeStyle";
    private static final String PROP_USED_PROFILE = "usedProfile";
    private static final String DEFAULT_PROFILE = "default";
    private static final String PROJECT_PROFILE = "project";
    private final Document doc;
    private final Preferences globalPrefs;
    private Preferences projectRoot;
    private Preferences projectPrefs;
    private boolean useProject;
    private final String mimeType;

    public static synchronized CodeStylePreferences get(Document document) {
        CodeStylePreferences codeStylePreferences = (CodeStylePreferences)document.getProperty(CodeStylePreferences.class);
        if (codeStylePreferences == null) {
            codeStylePreferences = new CodeStylePreferences(document);
            document.putProperty(CodeStylePreferences.class, codeStylePreferences);
        }
        return codeStylePreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences getPreferences() {
        CodeStylePreferences codeStylePreferences = this;
        synchronized (codeStylePreferences) {
            Preferences preferences = this.useProject ? this.projectPrefs : this.globalPrefs;
            return preferences == null ? AbstractPreferences.systemRoot() : preferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey() == null || PROP_USED_PROFILE.equals(preferenceChangeEvent.getKey())) {
            CodeStylePreferences codeStylePreferences = this;
            synchronized (codeStylePreferences) {
                this.useProject = PROJECT_PROFILE.equals(preferenceChangeEvent.getNewValue());
                this.logInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CodeStylePreferences codeStylePreferences = this;
        synchronized (codeStylePreferences) {
            this.projectRoot = CodeStylePreferences.findProjectPreferences(this.doc);
            if (this.projectRoot != null) {
                String string = this.projectRoot.get(PROP_USED_PROFILE, DEFAULT_PROFILE);
                this.useProject = PROJECT_PROFILE.equals(string);
                this.projectPrefs = this.mimeType == null ? this.projectRoot.node(PROJECT_PROFILE) : this.projectRoot.node(PROJECT_PROFILE).node(this.mimeType);
                this.projectRoot.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.projectRoot));
            } else {
                this.useProject = false;
                this.projectPrefs = null;
            }
            this.logInfo();
        }
    }

    private CodeStylePreferences(Document document) {
        this.doc = document;
        this.mimeType = (String)document.getProperty("mimeType");
        this.globalPrefs = (Preferences)MimeLookup.getLookup((MimePath)(this.mimeType == null ? MimePath.EMPTY : MimePath.parse((String)this.mimeType))).lookup(Preferences.class);
        this.useProject = false;
        this.projectPrefs = null;
        ProjectManager.mutex().postWriteRequest((Runnable)this);
        this.logInfo();
    }

    private static final Preferences findProjectPreferences(Document document) {
        Project project;
        FileObject fileObject = CodeStylePreferences.findFileObject(document);
        if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
            return ProjectUtils.getPreferences((Project)project, IndentUtils.class, (boolean)true).node(NODE_CODE_STYLE);
        }
        return null;
    }

    private static final FileObject findFileObject(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof DataObject) {
            return ((DataObject)object).getPrimaryFile();
        }
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        return null;
    }

    private void logInfo() {
        if (LOG.isLoggable(Level.FINE)) {
            FileObject fileObject = CodeStylePreferences.findFileObject(this.doc);
            String string = fileObject == null ? "no file" : fileObject.getPath();
            LOG.fine("file '" + string + "' (" + this.mimeType + ") is using " + (this.useProject ? PROJECT_PROFILE : "global") + " Preferences");
        }
    }
}

