/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.TextAction;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsSearchProvider
implements SearchProvider {
    public void evaluate(SearchRequest searchRequest, SearchResponse searchResponse) {
        Object object;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(7);
        for (KeymapManager keymapManager : Lookup.getDefault().lookupAll(KeymapManager.class)) {
            Map<ShortcutAction, Set<String>> map = keymapManager.getKeymap(keymapManager.getCurrentProfile());
            for (Map.Entry entry : keymapManager.getActions().entrySet()) {
                for (Object[] objectArray2 : (Set)entry.getValue()) {
                    object = this.getActionInfo((ShortcutAction)objectArray2, map.get(objectArray2));
                    if (object == null || this.doEvaluation(objectArray2.getDisplayName(), searchRequest, (Object[])object, searchResponse, (List<Object[]>)arrayList)) continue;
                    return;
                }
            }
        }
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            Object[] objectArray = nodeArray[i].getActions(false);
            for (int j = 0; j < objectArray.length; ++j) {
                Object[] objectArray2;
                Action action = this.checkNodeAction((Action)objectArray[j]);
                if (action == null) continue;
                objectArray2 = new Object[]{action, this.createActionEvent(action), null, null};
                object = action.getValue("Name");
                if (!(object instanceof String) || this.doEvaluation((String)object, searchRequest, objectArray2, searchResponse, arrayList)) continue;
                return;
            }
        }
        for (Object[] objectArray : arrayList) {
            if (this.addAction(objectArray, searchResponse)) continue;
            return;
        }
    }

    private boolean addAction(Object[] objectArray, SearchResponse searchResponse) {
        Object object;
        Object object2;
        KeyStroke keyStroke = null;
        Set set = (Set)objectArray[3];
        if (set != null && set.size() > 0) {
            object2 = (String)set.iterator().next();
            keyStroke = Utilities.stringToKey((String)object2);
        }
        object2 = (Action)objectArray[0];
        if (keyStroke == null && (object = object2.getValue("AcceleratorKey")) instanceof KeyStroke) {
            keyStroke = (KeyStroke)object;
        }
        object = null;
        ShortcutAction shortcutAction = (ShortcutAction)objectArray[2];
        if (shortcutAction != null) {
            object = shortcutAction.getDisplayName();
        } else {
            Object object3 = object2.getValue("Name");
            if (object3 instanceof String) {
                object = (String)object3;
            }
        }
        return searchResponse.addResult((Runnable)new ActionResult((Action)object2, (ActionEvent)objectArray[1]), (String)object, null, Collections.singletonList(keyStroke));
    }

    private boolean doEvaluation(String string, SearchRequest searchRequest, Object[] objectArray, SearchResponse searchResponse, List<Object[]> list) {
        int n = string.toLowerCase().indexOf(searchRequest.getText().toLowerCase());
        if (n == 0) {
            return this.addAction(objectArray, searchResponse);
        }
        if (n != -1) {
            list.add(objectArray);
        }
        return true;
    }

    private Object[] getActionInfo(ShortcutAction shortcutAction, Set<String> set) {
        Class<?> clazz = shortcutAction.getClass();
        Field field = null;
        try {
            field = clazz.getDeclaredField("action");
            field.setAccessible(true);
            Action action = (Action)field.get(shortcutAction);
            if (!action.isEnabled()) {
                return null;
            }
            return new Object[]{action, this.createActionEvent(action), shortcutAction, set};
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Some problem getting action " + shortcutAction.getDisplayName(), throwable);
            return null;
        }
    }

    private ActionEvent createActionEvent(Action action) {
        Object object = null;
        int n = 1001;
        if (action instanceof TextAction) {
            EditorCookie editorCookie = (EditorCookie)Utilities.actionsGlobalContext().lookup(EditorCookie.class);
            if (editorCookie == null) {
                return null;
            }
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null || jEditorPaneArray.length <= 0) {
                return null;
            }
            object = jEditorPaneArray[0];
        }
        if (object == null) {
            object = TopComponent.getRegistry().getActivated();
        }
        if (object == null) {
            object = WindowManager.getDefault().getMainWindow();
        }
        return new ActionEvent(object, n, null);
    }

    private Action checkNodeAction(Action action) {
        if (action == null) {
            return null;
        }
        try {
            if (action.isEnabled()) {
                return action;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Problem asking isEnabled on action " + action, throwable);
        }
        return null;
    }

    private static class ActionResult
    implements Runnable {
        private Action command;
        private ActionEvent event;

        public ActionResult(Action action, ActionEvent actionEvent) {
            this.command = action;
            this.event = actionEvent;
        }

        public void run() {
            try {
                this.command.actionPerformed(this.event);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                Object object = this.command.getValue("Name");
                String string = "";
                if (object instanceof String) {
                    string = (String)object;
                }
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, string + " action can not be invoked.", throwable);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"MSG_ActionFailure", (Object)string));
            }
        }
    }
}

