/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.bridge.ProjectBridge;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryUtils {
    private DiscoveryUtils() {
    }

    public static final List<String> getSystemIncludePaths(ProjectProxy projectProxy, boolean bl) {
        Project project = projectProxy.getProject();
        if (project != null) {
            return new ProjectBridge(project).getSystemIncludePaths(bl);
        }
        return null;
    }

    public static final String getCompilerFlavor(ProjectProxy projectProxy) {
        Project project = projectProxy.getProject();
        if (project != null) {
            return new ProjectBridge(project).getCompilerFlavor();
        }
        return null;
    }

    public static final String getCompilerDirectory(ProjectProxy projectProxy) {
        Project project = projectProxy.getProject();
        if (project != null) {
            return new ProjectBridge(project).getCompilerDirectory();
        }
        return null;
    }

    public static final Map<String, String> getSystemMacroDefinitions(ProjectProxy projectProxy, boolean bl) {
        Project project = projectProxy.getProject();
        if (project != null) {
            return new ProjectBridge(project).getSystemMacroDefinitions(bl);
        }
        return null;
    }

    public static final boolean ignoreFolder(File file) {
        if (file.isDirectory()) {
            String string = file.getName();
            return string.equals("SCCS") || string.equals("CVS") || string.equals(".hg") || string.equals("SunWS_cache");
        }
        return false;
    }

    public static final List<String> scanCommandLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        block5: while (n < string.length()) {
            char c = string.charAt(n);
            ++n;
            switch (c) {
                case '\'': {
                    if (bl) {
                        bl = false;
                    } else if (!bl2) {
                        bl = true;
                    }
                    stringBuilder.append(c);
                    continue block5;
                }
                case '\"': {
                    if (bl2) {
                        bl2 = false;
                    } else if (!bl) {
                        bl2 = true;
                    }
                    stringBuilder.append(c);
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl || bl2) {
                        stringBuilder.append(c);
                        continue block5;
                    }
                    if (stringBuilder.length() <= 0) continue block5;
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue block5;
                }
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static final String getRelativePath(String string, String string2) {
        CharSequence charSequence;
        if (string2.equals(string)) {
            return string2;
        }
        if (string2.startsWith(string + '/')) {
            return string2.substring(string.length() + 1);
        }
        if (string2.startsWith(string + '\\')) {
            return string2.substring(string.length() + 1);
        }
        if (!(string2.startsWith("/") || string2.startsWith("\\") || string2.length() > 2 && string2.charAt(2) == ':')) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\\/");
        int n = 0;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && ((String)(charSequence = stringTokenizer.nextToken())).equals(string3 = stringTokenizer2.nextToken())) {
            ++n;
        }
        if (n <= 1) {
            return string2;
        }
        charSequence = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            ((StringBuilder)charSequence).append(".." + File.separator);
        }
        ((StringBuilder)charSequence).append(".." + File.separator + string3);
        while (stringTokenizer2.hasMoreTokens()) {
            ((StringBuilder)charSequence).append(File.separator + stringTokenizer2.nextToken());
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String convertRelativePathToAbsolute(SourceFileProperties sourceFileProperties, String string) {
        if (!(string.startsWith("/") || string.length() > 1 && string.charAt(1) == ':')) {
            string = string.equals(".") ? sourceFileProperties.getCompilePath() : sourceFileProperties.getCompilePath() + File.separator + string;
            File file = new File(string);
            string = FileUtil.normalizeFile((File)file).getAbsolutePath();
        }
        if (Utilities.isWindows()) {
            string = string.replace('\\', '/');
        }
        return string;
    }

    public static String gatherComlilerLine(String string, boolean bl, List<String> list, Map<String, String> map, Set<String> set) {
        String string2;
        Object object;
        boolean bl2 = false;
        Object object2 = DiscoveryUtils.scanCommandLine(string);
        boolean bl3 = false;
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            object = object3.next();
            if (!((String)object).startsWith("\"")) continue;
            bl3 = true;
            break;
        }
        if (bl3) {
            object3 = new ArrayList();
            for (int i = 0; i < object2.size(); ++i) {
                string2 = object2.get(i);
                if (string2.startsWith("-D") && i + 1 < object2.size() && ((String)object2.get(i + 1)).startsWith("\"")) {
                    String string3 = null;
                    int n = i + 1;
                    while (n < object2.size() && ((String)object2.get(n)).startsWith("\"")) {
                        string3 = string3 != null ? string3 + " " + (String)object2.get(n) : (String)object2.get(n);
                        i = n++;
                    }
                    object3.add(string2 + "`" + string3 + "`");
                    continue;
                }
                object3.add(string2);
            }
            object2 = object3;
        }
        object3 = null;
        object = object2.iterator();
        string2 = null;
        if (object.hasNext() && (string2 = (String)object.next()).equals("+") && object.hasNext()) {
            string2 = (String)object.next();
        }
        while (object.hasNext()) {
            String string4;
            string2 = (String)object.next();
            boolean bl4 = false;
            if (bl && (string2.startsWith("'") && string2.endsWith("'") || string2.startsWith("\"") && string2.endsWith("\""))) {
                string2 = string2.substring(1, string2.length() - 1);
                bl4 = true;
            }
            if (string2.startsWith("-D")) {
                int n;
                if (string2.equals("-D") && object.hasNext()) {
                    string2 = (String)object.next();
                }
                if ((n = (string4 = string2.substring(2)).indexOf(61)) > 0) {
                    String string5 = string4.substring(n + 1).trim();
                    if (string5.length() >= 2 && string5.charAt(0) == '`' && string5.charAt(string5.length() - 1) == '`') {
                        string5 = string5.substring(1, string5.length() - 1);
                    } else if (!bl || bl4 || string5.length() < 2 || string5.charAt(0) == '\'' && string5.charAt(string5.length() - 1) == '\'' || string5.charAt(0) != '\"' || string5.charAt(string5.length() - 1) == '\"') {
                        // empty if block
                    }
                    map.put(string4.substring(0, n), string5);
                    continue;
                }
                map.put(string4, null);
                continue;
            }
            if (string2.startsWith("-I")) {
                string4 = string2.substring(2);
                if (string4.length() == 0 && object.hasNext()) {
                    string4 = (String)object.next();
                }
                list.add(string4);
                continue;
            }
            if (string2.startsWith("-isystem")) {
                string4 = string2.substring(8);
                if (string4.length() == 0 && object.hasNext()) {
                    string4 = (String)object.next();
                }
                list.add(string4);
                continue;
            }
            if (string2.startsWith("-include")) {
                string4 = string2.substring(8);
                if (string4.length() == 0 && object.hasNext()) {
                    string4 = (String)object.next();
                }
                list.add(string4);
                continue;
            }
            if (string2.startsWith("-imacros")) {
                string4 = string2.substring(8);
                if (string4.length() == 0 && object.hasNext()) {
                    string4 = (String)object.next();
                }
                list.add(string4);
                continue;
            }
            if (string2.startsWith("-Y")) {
                string4 = string2.substring(2);
                if (string4.length() == 0 && object.hasNext()) {
                    string4 = (String)object.next();
                }
                if (!string4.startsWith("I,")) continue;
                string4 = string4.substring(2);
                list.add(string4);
                continue;
            }
            if (string2.equals("-K")) {
                if (!object.hasNext()) continue;
                object.next();
                continue;
            }
            if (string2.equals("-R")) {
                if (!object.hasNext()) continue;
                object.next();
                continue;
            }
            if (string2.startsWith("-l")) {
                string4 = string2.substring(2);
                if (string4.length() == 0 && object.hasNext()) {
                    string4 = (String)object.next();
                }
                if (string4.length() <= 0 || set == null) continue;
                set.add(string4);
                continue;
            }
            if (string2.equals("-L")) {
                if (!object.hasNext()) continue;
                object.next();
                continue;
            }
            if (string2.equals("-M")) {
                if (!object.hasNext()) continue;
                object.next();
                continue;
            }
            if (string2.equals("-h")) {
                if (!object.hasNext()) continue;
                object.next();
                continue;
            }
            if (string2.equals("-o")) {
                if (!object.hasNext()) continue;
                object.next();
                continue;
            }
            if (string2.equals("-z")) {
                if (!object.hasNext()) continue;
                object.next();
                continue;
            }
            if (string2.equals("-MF")) {
                if (!object.hasNext()) continue;
                object.next();
                continue;
            }
            if (string2.equals("-MT")) {
                if (!object.hasNext()) continue;
                object.next();
                continue;
            }
            if (string2.equals("-fopenmp")) {
                map.put("_OPENMP", null);
                continue;
            }
            if (string2.startsWith("-") || string2.startsWith("ccfe")) continue;
            if (string2.startsWith(">")) break;
            if (string2.endsWith(".il") || string2.endsWith(".o") || string2.endsWith(".a") || string2.endsWith(".so") || string2.endsWith(".so.1")) continue;
            if (object3 == null) {
                object3 = string2;
                continue;
            }
            if (bl2) {
                System.out.println("**** What is this [" + string2 + "] if previous was [" + (String)object3 + "]?");
                System.out.println("*> " + string);
            }
            if (!string2.endsWith(".c") && !string2.endsWith(".cc") && !string2.endsWith(".cpp") && !string2.endsWith(".c++") && !string2.endsWith(".C") || ((String)object3).endsWith(".c") || ((String)object3).endsWith(".cc") || ((String)object3).endsWith(".cpp") || ((String)object3).endsWith(".c++") || ((String)object3).endsWith(".C")) continue;
            object3 = string2;
        }
        return object3;
    }
}

