/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.web.AuthConstraint;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.UserDataConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRolesEditorPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.WebResourceCollectionTableModel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.WebResourceCollectionTablePanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class SecurityConstraintPanel
extends SectionInnerPanel {
    private SectionView view;
    private DDDataObject dObj;
    private WebApp webApp;
    private SecurityConstraint constraint;
    private JCheckBox authConstraintCB;
    private JLabel authConstraintDescLabel;
    private JTextField authConstraintDescTF;
    private JLabel displayNameLabel;
    private JTextField displayNameTF;
    private JButton editButton;
    private JPanel jPanel1;
    private JLabel roleNamesLabel;
    private JTextField roleNamesTF;
    private JComboBox transportGuaranteeCB;
    private JLabel transportGuaranteeLabel;
    private JCheckBox userDataConstraintCB;
    private JLabel userDataConstraintDescLabel;
    private JTextField userDataConstraintDescTF;
    private JLabel webResourceCollectionLabel;
    private JPanel webResourceCollectionPanel;
    private JPanel webResourceCollectionPanel2;

    public SecurityConstraintPanel(SectionView sectionView, DDDataObject dDDataObject, SecurityConstraint securityConstraint) {
        super(sectionView);
        this.initComponents();
        this.view = sectionView;
        this.dObj = dDDataObject;
        this.webApp = dDDataObject.getWebApp();
        this.constraint = securityConstraint;
        this.initPanel();
    }

    private void initPanel() {
        String string;
        this.displayNameTF.setText(this.constraint.getDefaultDisplayName());
        this.addValidatee(this.displayNameTF);
        AuthConstraint authConstraint = this.constraint.getAuthConstraint();
        if (authConstraint != null) {
            this.authConstraintCB.setSelected(true);
            this.updateVisualState();
            string = this.getRoleNamesString(authConstraint);
            this.roleNamesTF.setText(string);
            this.authConstraintDescTF.setText(authConstraint.getDefaultDescription());
        }
        this.addModifier(this.authConstraintCB);
        this.addModifier(this.authConstraintDescTF);
        string = this.constraint.getUserDataConstraint();
        if (string != null) {
            this.userDataConstraintCB.setSelected(true);
            this.updateVisualState();
            this.transportGuaranteeCB.setSelectedItem(string.getTransportGuarantee());
            this.userDataConstraintDescTF.setText(string.getDefaultDescription());
        }
        this.addModifier(this.userDataConstraintCB);
        this.addModifier(this.userDataConstraintDescTF);
        this.addModifier(this.transportGuaranteeCB);
        WebResourceCollectionTableModel webResourceCollectionTableModel = new WebResourceCollectionTableModel();
        WebResourceCollectionTablePanel webResourceCollectionTablePanel = new WebResourceCollectionTablePanel(this.dObj, webResourceCollectionTableModel);
        webResourceCollectionTablePanel.setModel(this.dObj.getWebApp(), this.constraint, this.constraint.getWebResourceCollection());
        this.webResourceCollectionPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.webResourceCollectionPanel2.add((Component)((Object)webResourceCollectionTablePanel), gridBagConstraints);
    }

    private void updateVisualState() {
        if (this.authConstraintCB.isSelected()) {
            this.authConstraintDescLabel.setEnabled(true);
            this.authConstraintDescTF.setEnabled(true);
            this.roleNamesLabel.setEnabled(true);
            this.roleNamesTF.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.authConstraintDescLabel.setEnabled(false);
            this.authConstraintDescTF.setEnabled(false);
            this.roleNamesLabel.setEnabled(false);
            this.roleNamesTF.setEnabled(false);
            this.editButton.setEnabled(false);
        }
        if (this.userDataConstraintCB.isSelected()) {
            this.userDataConstraintDescLabel.setEnabled(true);
            this.userDataConstraintDescTF.setEnabled(true);
            this.transportGuaranteeLabel.setEnabled(true);
            this.transportGuaranteeCB.setEnabled(true);
        } else {
            this.userDataConstraintDescLabel.setEnabled(false);
            this.userDataConstraintDescTF.setEnabled(false);
            this.transportGuaranteeLabel.setEnabled(false);
            this.transportGuaranteeCB.setEnabled(false);
        }
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        if (jTextComponent == this.displayNameTF) {
            String string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Display Name", (JComponent)this.displayNameTF));
                return;
            }
            SecurityConstraint[] securityConstraintArray = this.webApp.getSecurityConstraint();
            for (int i = 0; i < securityConstraintArray.length; ++i) {
                if (securityConstraintArray[i] == this.constraint || !string2.equals(securityConstraintArray[i].getDefaultDisplayName())) continue;
                this.getSectionView().getErrorPanel().setError(new Error(0, 3, string2, (JComponent)this.displayNameTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    public void setValue(JComponent jComponent, Object object) {
        if (jComponent == this.displayNameTF) {
            String string = (String)object;
            this.constraint.setDisplayName(string);
            SectionPanel sectionPanel = this.getSectionView().findSectionPanel((Object)this.constraint);
            sectionPanel.setTitle(string);
            sectionPanel.getNode().setDisplayName(string);
        } else if (jComponent == this.authConstraintCB) {
            if (this.authConstraintCB.isSelected()) {
                this.refillAuthConstraint();
            } else {
                this.setAuthConstraint(null);
            }
        } else if (jComponent == this.roleNamesTF) {
            this.refillAuthConstraint();
        } else if (jComponent == this.authConstraintDescTF) {
            this.refillAuthConstraint();
        } else if (jComponent == this.userDataConstraintCB) {
            if (this.userDataConstraintCB.isSelected()) {
                this.refillUserDataConstraint();
            } else {
                this.setUserDataConstraint(null);
            }
        } else if (jComponent == this.transportGuaranteeCB) {
            this.refillUserDataConstraint();
        } else if (jComponent == this.userDataConstraintDescTF) {
            this.refillUserDataConstraint();
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (jTextComponent == this.displayNameTF) {
            this.displayNameTF.setText(this.constraint.getDefaultDisplayName());
        }
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    private void setUserDataConstraint(UserDataConstraint userDataConstraint) {
        this.constraint.setUserDataConstraint(userDataConstraint);
    }

    private UserDataConstraint getUserDataConstraint() {
        UserDataConstraint userDataConstraint = this.constraint.getUserDataConstraint();
        if (userDataConstraint == null) {
            try {
                userDataConstraint = (UserDataConstraint)this.webApp.createBean("UserDataConstraint");
                this.constraint.setUserDataConstraint(userDataConstraint);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return userDataConstraint;
    }

    private void refillUserDataConstraint() {
        this.setUserDataConstraint(null);
        UserDataConstraint userDataConstraint = this.getUserDataConstraint();
        userDataConstraint.setDescription(this.userDataConstraintDescTF.getText());
        userDataConstraint.setTransportGuarantee((String)this.transportGuaranteeCB.getSelectedItem());
    }

    private void setAuthConstraint(AuthConstraint authConstraint) {
        this.constraint.setAuthConstraint(authConstraint);
    }

    private AuthConstraint getAuthConstraint() {
        AuthConstraint authConstraint = this.constraint.getAuthConstraint();
        if (authConstraint == null) {
            try {
                authConstraint = (AuthConstraint)this.webApp.createBean("AuthConstraint");
                this.constraint.setAuthConstraint(authConstraint);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return authConstraint;
    }

    private void refillAuthConstraint() {
        this.setAuthConstraint(null);
        AuthConstraint authConstraint = this.getAuthConstraint();
        authConstraint.setDescription(this.authConstraintDescTF.getText());
        String string = this.roleNamesTF.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            authConstraint.addRoleName(string2);
        }
    }

    private String getRoleNamesString(AuthConstraint authConstraint) {
        String[] stringArray = authConstraint.getRoleName();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + stringArray[i];
        }
        return string;
    }

    private String[] getSelectedRoleNames() {
        return this.constraint.getAuthConstraint().getRoleName();
    }

    private String[] getAllRoleNames() {
        SecurityRole[] securityRoleArray = this.webApp.getSecurityRole();
        String[] stringArray = new String[securityRoleArray.length];
        for (int i = 0; i < securityRoleArray.length; ++i) {
            stringArray[i] = securityRoleArray[i].getRoleName();
        }
        return stringArray;
    }

    private void setSelectedRoleNames(String[] stringArray) {
        AuthConstraint authConstraint = this.constraint.getAuthConstraint();
        authConstraint.setRoleName(stringArray);
        this.roleNamesTF.setText(this.getRoleNamesString(authConstraint));
    }

    private void initComponents() {
        this.displayNameLabel = new JLabel();
        this.displayNameTF = new JTextField();
        this.roleNamesLabel = new JLabel();
        this.roleNamesTF = new JTextField();
        this.authConstraintDescLabel = new JLabel();
        this.authConstraintDescTF = new JTextField();
        this.transportGuaranteeLabel = new JLabel();
        this.transportGuaranteeCB = new JComboBox();
        this.webResourceCollectionLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.webResourceCollectionPanel = new JPanel();
        this.authConstraintCB = new JCheckBox();
        this.userDataConstraintCB = new JCheckBox();
        this.webResourceCollectionPanel2 = new JPanel();
        this.userDataConstraintDescLabel = new JLabel();
        this.userDataConstraintDescTF = new JTextField();
        this.editButton = new JButton();
        this.displayNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_displayName_mnem").charAt(0));
        this.displayNameLabel.setLabelFor(this.displayNameTF);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle");
        this.displayNameLabel.setText(resourceBundle.getString("LBL_displayName"));
        this.roleNamesLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_roleNames_mnem").charAt(0));
        this.roleNamesLabel.setLabelFor(this.roleNamesTF);
        this.roleNamesLabel.setText(resourceBundle.getString("LBL_SecurityRoleNames"));
        this.roleNamesLabel.setEnabled(false);
        this.roleNamesTF.setEditable(false);
        this.roleNamesTF.setEnabled(false);
        this.authConstraintDescLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_description_mnem1").charAt(0));
        this.authConstraintDescLabel.setLabelFor(this.authConstraintDescTF);
        this.authConstraintDescLabel.setText(resourceBundle.getString("LBL_SecurityRoleDescription"));
        this.authConstraintDescLabel.setEnabled(false);
        this.authConstraintDescTF.setEnabled(false);
        this.transportGuaranteeLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_transportGuarantee_mnem").charAt(0));
        this.transportGuaranteeLabel.setLabelFor(this.transportGuaranteeCB);
        this.transportGuaranteeLabel.setText(resourceBundle.getString("LBL_TransportGuarantee"));
        this.transportGuaranteeLabel.setEnabled(false);
        this.transportGuaranteeCB.setModel(new DefaultComboBoxModel<String>(new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"}));
        this.transportGuaranteeCB.setEnabled(false);
        this.webResourceCollectionLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_webResourceCollection_mnem").charAt(0));
        this.webResourceCollectionLabel.setLabelFor(this.webResourceCollectionPanel);
        this.webResourceCollectionLabel.setText(resourceBundle.getString("LBL_WebResourceCollection"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.webResourceCollectionPanel.setLayout(new GridBagLayout());
        this.authConstraintCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_authConstraint_mnem").charAt(0));
        this.authConstraintCB.setText(resourceBundle.getString("LBL_AuthConstraint"));
        this.authConstraintCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.authConstraintCB.setMargin(new Insets(0, 0, 0, 0));
        this.authConstraintCB.setOpaque(false);
        this.authConstraintCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityConstraintPanel.this.authConstraintCBActionPerformed(actionEvent);
            }
        });
        this.userDataConstraintCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_userDataConstraint_mnem").charAt(0));
        this.userDataConstraintCB.setText(resourceBundle.getString("LBL_UserDataConstraint"));
        this.userDataConstraintCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.userDataConstraintCB.setMargin(new Insets(0, 0, 0, 0));
        this.userDataConstraintCB.setOpaque(false);
        this.userDataConstraintCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityConstraintPanel.this.userDataConstraintCBActionPerformed(actionEvent);
            }
        });
        this.webResourceCollectionPanel2.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.webResourceCollectionPanel2);
        this.webResourceCollectionPanel2.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 537, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 38, Short.MAX_VALUE));
        this.userDataConstraintDescLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_description_mnem2").charAt(0));
        this.userDataConstraintDescLabel.setLabelFor(this.userDataConstraintDescTF);
        this.userDataConstraintDescLabel.setText(resourceBundle.getString("LBL_UserDataConstraintDescription"));
        this.userDataConstraintDescLabel.setEnabled(false);
        this.userDataConstraintDescTF.setEnabled(false);
        this.editButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_editRoleNames_mnem").charAt(0));
        this.editButton.setText(resourceBundle.getString("LBL_EditRoleNames"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityConstraintPanel.this.editButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.transportGuaranteeLabel).addPreferredGap(0).add((Component)this.transportGuaranteeCB, -2, -1, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.userDataConstraintDescLabel).addPreferredGap(0).add((Component)this.userDataConstraintDescTF, -1, 433, Short.MAX_VALUE))).addPreferredGap(0)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.displayNameLabel).addPreferredGap(0).add((Component)this.displayNameTF, -1, 436, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.userDataConstraintCB).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.webResourceCollectionPanel, -2, -1, -2).add((Component)this.jPanel1, -2, -1, -2))).add((Component)this.webResourceCollectionLabel).add(2, (Component)this.webResourceCollectionPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.roleNamesLabel).add((Component)this.authConstraintDescLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.roleNamesTF, -1, 296, Short.MAX_VALUE).add((Component)this.authConstraintDescTF, -1, 296, Short.MAX_VALUE))).add((Component)this.authConstraintCB)).add(6, 6, 6).add((Component)this.editButton).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.displayNameTF, -2, -1, -2).add((Component)this.displayNameLabel)).addPreferredGap(0).add((Component)this.webResourceCollectionLabel).addPreferredGap(0).add((Component)this.webResourceCollectionPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.authConstraintCB).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.authConstraintDescLabel).add((Component)this.authConstraintDescTF, -2, -1, -2)).add(5, 5, 5).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(39, 39, 39).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.webResourceCollectionPanel, -2, -1, -2))).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.roleNamesLabel).add((Component)this.roleNamesTF, -2, -1, -2).add((Component)this.editButton)).addPreferredGap(0).add((Component)this.userDataConstraintCB))).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.userDataConstraintDescTF, -2, -1, -2).add((Component)this.userDataConstraintDescLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.transportGuaranteeCB, -2, -1, -2).add((Component)this.transportGuaranteeLabel)).addContainerGap(36, Short.MAX_VALUE)));
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        SecurityRolesEditorPanel securityRolesEditorPanel = new SecurityRolesEditorPanel(this.getAllRoleNames(), this.getSelectedRoleNames());
        EditDialog editDialog = new EditDialog(securityRolesEditorPanel, NbBundle.getMessage(SecurityConstraintPanel.class, (String)"TTL_RoleNames"), false){

            protected String validate() {
                return null;
            }
        };
        EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
        dialog.setVisible(true);
        if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
            this.dObj.modelUpdatedFromUI();
            this.dObj.setChangedFromUI(true);
            String[] stringArray = securityRolesEditorPanel.getSelectedRoles();
            this.setSelectedRoleNames(stringArray);
            this.dObj.setChangedFromUI(false);
        }
    }

    private void userDataConstraintCBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState();
    }

    private void authConstraintCBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState();
    }
}

