/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.features.HighlighterSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class TokensBrowserTopComponent
extends TopComponent {
    private static final String PREFERRED_ID = "TokensBrowserTopComponent";
    private static final long serialVersionUID = 1L;
    private static TokensBrowserTopComponent instance;
    private JTree tree;
    private Listener listener;
    private HighlighterSupport highlighting = new HighlighterSupport(Color.yellow);
    private boolean listen = true;
    private CaretListener caretListener;
    private JEditorPane lastPane;
    private DocumentListener documentListener;
    private AbstractDocument lastDocument;
    private RequestProcessor.Task task;

    private TokensBrowserTopComponent() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.tree = new JTree();
        this.tree.setCellRenderer(new Renderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!TokensBrowserTopComponent.this.listen) {
                    return;
                }
                TokensBrowserTopComponent.this.mark();
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                TokensBrowserTopComponent.this.mark();
            }

            public void focusLost(FocusEvent focusEvent) {
                TokensBrowserTopComponent.this.mark();
            }
        });
        this.tree.setRootVisible(false);
        this.add(new JScrollPane(this.tree), "Center");
        this.setName(NbBundle.getMessage(TokensBrowserTopComponent.class, (String)"CTL_TokensBrowserTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TokensBrowserTopComponent.class, (String)"HINT_TokensBrowserTopComponent"));
    }

    private void initComponents() {
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    public static synchronized TokensBrowserTopComponent getDefault() {
        if (instance == null) {
            instance = new TokensBrowserTopComponent();
        }
        return instance;
    }

    public static synchronized TokensBrowserTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            ErrorManager.getDefault().log(16, "Cannot find TokensBrowser component. It will not be located properly in the window system.");
            return TokensBrowserTopComponent.getDefault();
        }
        if (topComponent instanceof TokensBrowserTopComponent) {
            return (TokensBrowserTopComponent)topComponent;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'TokensBrowserTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return TokensBrowserTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected void componentShowing() {
        this.refresh();
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
    }

    protected void componentHidden() {
        if (this.listener != null) {
            this.listener.remove();
            this.listener = null;
        }
        if (this.lastPane != null) {
            this.lastPane.removeCaretListener(this.caretListener);
        }
        this.lastPane = null;
        if (this.lastDocument != null) {
            this.lastDocument.removeDocumentListener(this.documentListener);
        }
        this.lastDocument = null;
        this.highlighting.removeHighlight();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void mark() {
        EditorCookie editorCookie;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length == 1 && this.tree.isFocusOwner() && (editorCookie = (EditorCookie)nodeArray[0].getLookup().lookup(EditorCookie.class)) != null) {
            THNode tHNode = (THNode)this.tree.getLastSelectedPathComponent();
            if (tHNode == null) {
                return;
            }
            Token token = tHNode.getToken();
            if (token == null) {
                return;
            }
            if (tHNode != null) {
                this.highlighting.highlight(editorCookie.getDocument(), tHNode.getOffset(), tHNode.getOffset() + token.length());
                return;
            }
        }
        this.highlighting.removeHighlight();
    }

    private JEditorPane getCurrentEditor() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length != 1) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)nodeArray[0].getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes() == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes().length < 1) {
            return null;
        }
        return editorCookie.getOpenedPanes()[0];
    }

    private AbstractDocument getCurrentDocument() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length != 1) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)nodeArray[0].getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes() == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes().length < 1) {
            return null;
        }
        JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
        if (this.caretListener == null) {
            this.caretListener = new CListener();
        }
        if (this.lastPane != null && this.lastPane != jEditorPane) {
            this.lastPane.removeCaretListener(this.caretListener);
            this.lastPane = null;
        }
        if (this.lastPane == null) {
            jEditorPane.addCaretListener(this.caretListener);
            this.lastPane = jEditorPane;
        }
        AbstractDocument abstractDocument = (AbstractDocument)((Object)editorCookie.getDocument());
        if (this.documentListener == null) {
            this.documentListener = new CDocumentListener();
        }
        if (this.lastDocument != null && this.lastDocument != abstractDocument) {
            this.lastDocument.removeDocumentListener(this.documentListener);
            this.lastDocument = null;
        }
        if (this.lastDocument == null) {
            abstractDocument.addDocumentListener(this.documentListener);
            this.lastDocument = abstractDocument;
        }
        return abstractDocument;
    }

    private void refreshLater() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TokensBrowserTopComponent.this.refresh();
                TokensBrowserTopComponent.this.task = null;
            }
        }, 1000);
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                AbstractDocument abstractDocument = TokensBrowserTopComponent.this.getCurrentDocument();
                TokenSequence tokenSequence = null;
                if (abstractDocument != null) {
                    try {
                        abstractDocument.readLock();
                        object = TokenHierarchy.get((Document)abstractDocument);
                        if (object == null) {
                            return;
                        }
                        tokenSequence = object.tokenSequence();
                    }
                    finally {
                        abstractDocument.readUnlock();
                    }
                }
                if (tokenSequence == null) {
                    TokensBrowserTopComponent.this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
                } else {
                    TokensBrowserTopComponent.this.tree.setModel(new DefaultTreeModel(new TSNode(null, tokenSequence, null, 0, 0)));
                }
                object = TokensBrowserTopComponent.this.getCurrentEditor();
                if (object != null) {
                    int n = TokensBrowserTopComponent.this.getCurrentEditor().getCaret().getDot();
                    TokensBrowserTopComponent.this.selectPath(n);
                }
            }
        });
    }

    private void selectPath(int n) {
        Object object = this.tree.getModel().getRoot();
        if (!(object instanceof TSNode)) {
            return;
        }
        this.listen = false;
        TSNode tSNode = (TSNode)object;
        TreePath treePath = new TreePath(tSNode);
        treePath = this.findPath(treePath, n);
        this.tree.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
        this.listen = true;
    }

    private TreePath findPath(TreePath treePath, int n) {
        THNode tHNode = (THNode)treePath.getLastPathComponent();
        Enumeration<? extends TreeNode> enumeration = tHNode.children();
        while (enumeration.hasMoreElements()) {
            THNode tHNode2 = (THNode)enumeration.nextElement();
            if (tHNode2.getOffset() + tHNode2.getToken().length() <= n) continue;
            if (n < tHNode2.getOffset()) {
                return treePath;
            }
            if (tHNode2.isLeaf()) {
                return new MPath(treePath, tHNode2);
            }
            return this.findPath(new MPath(treePath, tHNode2), n);
        }
        return treePath;
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference component;

        Listener(TokensBrowserTopComponent tokensBrowserTopComponent) {
            this.component = new WeakReference<TokensBrowserTopComponent>(tokensBrowserTopComponent);
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        }

        TokensBrowserTopComponent getComponent() {
            TokensBrowserTopComponent tokensBrowserTopComponent = (TokensBrowserTopComponent)((Object)this.component.get());
            if (tokensBrowserTopComponent != null) {
                return tokensBrowserTopComponent;
            }
            this.remove();
            return null;
        }

        void remove() {
            TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TokensBrowserTopComponent tokensBrowserTopComponent = this.getComponent();
            if (tokensBrowserTopComponent == null) {
                return;
            }
            tokensBrowserTopComponent.refresh();
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return TokensBrowserTopComponent.getDefault();
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        private Renderer() {
        }

        private String e(CharSequence charSequence) {
            if (charSequence == null) {
                return "null";
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = charSequence.length();
            for (int i = 0; i < n; ++i) {
                if (charSequence.charAt(i) == '\t') {
                    stringBuilder.append("\\t");
                    continue;
                }
                if (charSequence.charAt(i) == '\r') {
                    stringBuilder.append("\\r");
                    continue;
                }
                if (charSequence.charAt(i) == '\n') {
                    stringBuilder.append("\\n");
                    continue;
                }
                stringBuilder.append(charSequence.charAt(i));
            }
            return stringBuilder.toString();
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (!(object instanceof THNode)) {
                return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            THNode tHNode = (THNode)object;
            Token token = tHNode.getToken();
            if (token == null) {
                return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            StringBuilder stringBuilder = new StringBuilder().append('<').append(tHNode.getOffset()).append(",\"").append(token.id().name()).append(",\"").append(this.e(token.text())).append("\">");
            return super.getTreeCellRendererComponent(jTree, stringBuilder.toString(), bl, bl2, bl3, n, bl4);
        }
    }

    class CListener
    implements CaretListener {
        CListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n = caretEvent.getDot();
            try {
                TokensBrowserTopComponent.this.selectPath(n);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    class CDocumentListener
    implements DocumentListener {
        CDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            TokensBrowserTopComponent.this.refreshLater();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            TokensBrowserTopComponent.this.refreshLater();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            TokensBrowserTopComponent.this.refreshLater();
        }
    }

    static class TNode
    implements THNode {
        private TSNode parent;
        private Token token;
        private String mimeType;
        private int index;
        private int offset;

        TNode(TSNode tSNode, Token token, String string, int n, int n2) {
            this.parent = tSNode;
            this.token = token;
            this.mimeType = string;
            this.index = n;
            this.offset = n2;
        }

        public TreeNode getChildAt(int n) {
            throw new UnsupportedOperationException();
        }

        public int getChildCount() {
            throw new UnsupportedOperationException();
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode treeNode) {
            throw new UnsupportedOperationException();
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            throw new UnsupportedOperationException();
        }

        public Token getToken() {
            return this.token;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getIndex() {
            return this.index;
        }
    }

    static class TSNode
    implements THNode {
        private TSNode parent;
        private TokenSequence ts;
        private Token token;
        private int offset;
        private int index;

        TSNode(TSNode tSNode, TokenSequence tokenSequence, Token token, int n, int n2) {
            this.parent = tSNode;
            this.ts = tokenSequence;
            this.token = token;
            this.offset = n;
            this.index = n2;
        }

        public TreeNode getChildAt(int n) {
            this.ts.moveIndex(n);
            this.ts.moveNext();
            TokenSequence tokenSequence = this.ts.embedded();
            if (tokenSequence != null) {
                return new TSNode(this, tokenSequence, this.ts.token(), this.ts.offset(), this.ts.index());
            }
            return new TNode(this, this.ts.token(), this.getMimeType(), n, this.ts.offset());
        }

        public int getChildCount() {
            return this.ts.tokenCount();
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public String getMimeType() {
            return this.ts.language().mimeType();
        }

        public int getIndex(TreeNode treeNode) {
            return ((THNode)treeNode).getIndex();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return false;
        }

        public Enumeration children() {
            return new Enumeration(){
                private int i = 0;

                public boolean hasMoreElements() {
                    return this.i < TSNode.this.getChildCount();
                }

                public Object nextElement() {
                    return TSNode.this.getChildAt(this.i++);
                }
            };
        }

        public Token getToken() {
            return this.token;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getIndex() {
            return this.index;
        }
    }

    static class MPath
    extends TreePath {
        MPath(TreePath treePath, Object object) {
            super(treePath, object);
        }
    }

    static interface THNode
    extends TreeNode {
        public Token getToken();

        public String getMimeType();

        public int getOffset();

        public int getIndex();
    }
}

