/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.CopyTransformer;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CopyClassRefactoringPlugin
extends JavaRefactoringPlugin {
    private final SingleCopyRefactoring refactoring;

    CopyClassRefactoringPlugin(SingleCopyRefactoring singleCopyRefactoring) {
        this.refactoring = singleCopyRefactoring;
    }

    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        return JavaSource.forFileObject((FileObject)((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)));
    }

    public Problem fastCheckParameters() {
        FileObject fileObject;
        if (!Utilities.isJavaIdentifier((String)this.refactoring.getNewName())) {
            String string = new MessageFormat(NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_InvalidIdentifier")).format(new Object[]{this.refactoring.getNewName()});
            return CopyClassRefactoringPlugin.createProblem(null, true, string);
        }
        URL uRL = (URL)this.refactoring.getTarget().lookup(URL.class);
        FileObject fileObject2 = fileObject = uRL != null ? URLMapper.findFileObject((URL)uRL) : null;
        if (fileObject == null) {
            return CopyClassRefactoringPlugin.createProblem(null, true, NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_TargetFolderNotSet"));
        }
        if (!RetoucheUtils.isOnSourceClasspath(fileObject)) {
            return CopyClassRefactoringPlugin.createProblem(null, true, NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_TargetFolderNotJavaPackage"));
        }
        String string = RetoucheUtils.getPackageName(uRL);
        if (!RetoucheUtils.isValidPackageName(string)) {
            String string2 = new MessageFormat(NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{string});
            return CopyClassRefactoringPlugin.createProblem(null, true, string2);
        }
        if (fileObject.getFileObject(this.refactoring.getNewName(), ((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)).getExt()) != null) {
            return CopyClassRefactoringPlugin.createProblem(null, true, new MessageFormat(NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_ClassToMoveClashes")).format(new Object[]{this.refactoring.getNewName()}));
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new CopyClass());
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateReferences
    implements CancellableTask<WorkingCopy> {
        private boolean insertImport;
        private String oldPackage;
        private String oldName;

        public UpdateReferences(boolean bl, String string, String string2) {
            this.insertImport = bl;
            this.oldPackage = string;
            this.oldName = string2;
        }

        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            if (compilationUnitTree == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + workingCopy);
                return;
            }
            CopyTransformer copyTransformer = new CopyTransformer(workingCopy, this.oldName, CopyClassRefactoringPlugin.this.refactoring.getNewName(), this.insertImport, this.oldPackage);
            copyTransformer.scan(workingCopy.getCompilationUnit(), null);
        }
    }

    private class CopyClass
    extends SimpleRefactoringElementImplementation
    implements RefactoringElementImplementation {
        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return new MessageFormat(NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"TXT_CopyClassToPackage")).format(new Object[]{CopyClassRefactoringPlugin.this.refactoring.getNewName(), this.getTargetPackageName(), this.getParentFile().getName()});
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public PositionBounds getPosition() {
            return null;
        }

        public String getTargetPackageName() {
            return RetoucheUtils.getPackageName((URL)CopyClassRefactoringPlugin.this.refactoring.getTarget().lookup(URL.class));
        }

        public void performChange() {
            try {
                FileObject fileObject = RetoucheUtils.getOrCreateFolder((URL)CopyClassRefactoringPlugin.this.refactoring.getTarget().lookup(URL.class));
                FileObject fileObject2 = (FileObject)CopyClassRefactoringPlugin.this.refactoring.getRefactoringSource().lookup(FileObject.class);
                String string = RetoucheUtils.getPackageName(fileObject2.getParent());
                FileObject fileObject3 = (FileObject)CopyClassRefactoringPlugin.this.refactoring.getContext().lookup(FileObject.class);
                if (fileObject3 == null) {
                    return;
                }
                Collection collection = CopyClassRefactoringPlugin.this.processFiles(Collections.singleton(fileObject3), (CancellableTask<WorkingCopy>)new UpdateReferences(!fileObject.equals(fileObject2.getParent()) && FileOwnerQuery.getOwner((FileObject)fileObject).equals(FileOwnerQuery.getOwner((FileObject)fileObject2)), string, fileObject2.getName()));
                for (ModificationResult modificationResult : collection) {
                    modificationResult.commit();
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }

        public FileObject getParentFile() {
            return (FileObject)CopyClassRefactoringPlugin.this.refactoring.getRefactoringSource().lookup(FileObject.class);
        }
    }
}

