/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.callhierarchy.Call;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyTopComponent;
import org.netbeans.modules.refactoring.java.plugins.FindUsagesVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

final class CallHierarchyTasks {
    private static final RequestProcessor RP = new RequestProcessor("Call Hierarchy Processor", 1);
    private static final Object LOCK = new Object();
    private static CallersTask CURR_TASK;

    CallHierarchyTasks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = LOCK;
        synchronized (object) {
            if (CURR_TASK != null) {
                CURR_TASK.cancel();
            }
        }
    }

    public static void findCallers(Call call, boolean bl, boolean bl2, Runnable runnable) {
        RP.post((Runnable)new CallersTask(call, runnable, bl, bl2));
    }

    public static void findCallees(Call call, Runnable runnable) {
        RP.post((Runnable)new CalleesTask(call, runnable));
    }

    public static Call resolveRoot(TreePathHandle treePathHandle, boolean bl) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
        return CallHierarchyTasks.resolveRoot(javaSource, new RootResolver(treePathHandle, bl));
    }

    public static Call resolveRoot(Lookup lookup, boolean bl) {
        JavaSource javaSource = null;
        RootResolver rootResolver = null;
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (editorCookie != null) {
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            StyledDocument styledDocument = editorCookie.getDocument();
            javaSource = JavaSource.forDocument((Document)styledDocument);
            rootResolver = new RootResolver(jEditorPaneArray[0].getCaretPosition(), bl);
        }
        return CallHierarchyTasks.resolveRoot(javaSource, rootResolver);
    }

    private static Call resolveRoot(JavaSource javaSource, RootResolver rootResolver) {
        Call call = null;
        if (javaSource != null && rootResolver != null) {
            try {
                javaSource.runWhenScanFinished((Task)rootResolver, true);
                call = rootResolver.getRoot();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return call;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InitializerElement
    implements Element {
        private static final Set<Modifier> STATICM = EnumSet.of(Modifier.STATIC);
        private final boolean isStatic;
        private final Element enclosing;

        public InitializerElement(Element element, boolean bl) {
            this.isStatic = bl;
            this.enclosing = element;
        }

        @Override
        public TypeMirror asType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ElementKind getKind() {
            return this.isStatic ? ElementKind.STATIC_INIT : ElementKind.INSTANCE_INIT;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.isStatic ? STATICM : Collections.emptySet();
        }

        @Override
        public Name getSimpleName() {
            return null;
        }

        @Override
        public Element getEnclosingElement() {
            return this.enclosing;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return Collections.emptyList();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OccurrencesDesc
    implements Comparable<OccurrencesDesc> {
        final List<TreePath> occurrences = new ArrayList<TreePath>();
        final Element elm;
        final TreePath selection;
        final int order;

        public OccurrencesDesc(TreePath treePath, Element element, int n) {
            this.order = n;
            this.elm = element;
            this.selection = treePath;
        }

        @Override
        public int compareTo(OccurrencesDesc occurrencesDesc) {
            return this.order - occurrencesDesc.order;
        }

        public static List<OccurrencesDesc> extract(Map<Element, OccurrencesDesc> map) {
            List<OccurrencesDesc> list;
            int n = map.size();
            if (n > 0) {
                list = new ArrayList<OccurrencesDesc>(n);
                list.addAll(map.values());
                Collections.sort(list);
            } else {
                list = Collections.emptyList();
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CalleeScanner
    extends TreePathScanner<Void, Void> {
        private final CompilationInfo javac;
        private Map<Element, OccurrencesDesc> refs = new HashMap<Element, OccurrencesDesc>();
        private int elmCounter = 0;

        public CalleeScanner(CompilationInfo compilationInfo) {
            this.javac = compilationInfo;
        }

        public List<OccurrencesDesc> getOccurrences() {
            return OccurrencesDesc.extract(this.refs);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void void_) {
            this.resolvePath(this.getCurrentPath());
            return (Void)super.visitMethodInvocation(methodInvocationTree, void_);
        }

        @Override
        public Void visitNewClass(NewClassTree newClassTree, Void void_) {
            this.resolvePath(this.getCurrentPath());
            return (Void)super.visitNewClass(newClassTree, void_);
        }

        private void resolvePath(TreePath treePath) {
            Element element = this.javac.getTrees().getElement(treePath);
            if (!(element == null || this.javac.getElementUtilities().isSynthetic(element) || element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR)) {
                this.addRef(element, treePath);
            }
        }

        private void addRef(Element element, TreePath treePath) {
            OccurrencesDesc occurrencesDesc = this.refs.get(element);
            if (occurrencesDesc == null) {
                occurrencesDesc = new OccurrencesDesc(treePath, element, this.elmCounter++);
                this.refs.put(element, occurrencesDesc);
            }
            occurrencesDesc.occurrences.add(treePath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CalleesTask
    implements Runnable,
    Task<CompilationController> {
        private final Call elmDesc;
        private final Runnable resultHandler;

        public CalleesTask(Call call, Runnable runnable) {
            this.elmDesc = call;
            this.resultHandler = runnable;
        }

        @Override
        public void run() {
            try {
                JavaSource javaSource = JavaSource.forFileObject((FileObject)this.elmDesc.getSourceToQuery().getFileObject());
                if (javaSource != null) {
                    javaSource.runWhenScanFinished((Task)this, true);
                }
                this.resultHandler.run();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            TreePath treePath = this.elmDesc.getSourceToQuery().resolve((CompilationInfo)compilationController);
            if (treePath == null) {
                return;
            }
            Element element = compilationController.getTrees().getElement(treePath);
            treePath = compilationController.getTrees().getPath(element);
            if (treePath == null) {
                return;
            }
            CalleeScanner calleeScanner = new CalleeScanner((CompilationInfo)compilationController);
            calleeScanner.scan(treePath, null);
            ArrayList<Call> arrayList = new ArrayList<Call>();
            for (OccurrencesDesc occurrencesDesc : calleeScanner.getOccurrences()) {
                arrayList.add(Call.createUsage((CompilationInfo)compilationController, occurrencesDesc.selection, occurrencesDesc.elm, this.elmDesc, occurrencesDesc.occurrences));
            }
            this.elmDesc.setReferences(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CallersTask
    implements Runnable,
    CancellableTask<WorkingCopy> {
        private final Call elmDesc;
        private final Runnable resultHandler;
        private AtomicBoolean isCanceled = new AtomicBoolean(false);
        private final List<Call> result = new ArrayList<Call>();
        private final boolean includeTest;
        private final boolean searchAll;

        public CallersTask(Call call, Runnable runnable, boolean bl, boolean bl2) {
            this.elmDesc = call;
            this.resultHandler = runnable;
            this.includeTest = bl;
            this.searchAll = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            try {
                this.notifyRunning(true);
                object = this.elmDesc.getSourceToQuery();
                ClasspathInfo classpathInfo = this.searchAll ? RetoucheUtils.getClasspathInfoFor(true, object.getFileObject()) : RetoucheUtils.getClasspathInfoFor(false, this.elmDesc.selection.getFileObject());
                Set<FileObject> set = null;
                if (!this.isCanceled()) {
                    set = JavaWhereUsedQueryPlugin.getRelevantFiles(object, classpathInfo, false, false, false, true);
                }
                try {
                    if (!this.isCanceled()) {
                        this.processFiles(set, (Task<WorkingCopy>)this, null);
                    }
                    this.elmDesc.setReferences(this.result);
                    this.elmDesc.setCanceled(this.isCanceled());
                    this.resultHandler.run();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
            finally {
                object = LOCK;
                synchronized (object) {
                    CURR_TASK = null;
                }
                this.notifyRunning(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyRunning(final boolean bl) {
            Object object = LOCK;
            synchronized (object) {
                CURR_TASK = bl ? this : null;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        CallHierarchyTopComponent.findInstance().setRunningState(bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }

        public void cancel() {
            this.isCanceled.set(true);
            RetoucheUtils.cancel = true;
        }

        private boolean isCanceled() {
            if (Thread.interrupted()) {
                this.isCanceled.set(true);
            }
            return this.isCanceled.get();
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            Object object;
            if (workingCopy.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                return;
            }
            Element element = this.elmDesc.getSourceToQuery().resolveElement((CompilationInfo)workingCopy);
            if (element == null) {
                return;
            }
            FindUsagesVisitor findUsagesVisitor = new FindUsagesVisitor(workingCopy, false);
            findUsagesVisitor.scan(workingCopy.getCompilationUnit(), element);
            Collection<TreePath> collection = findUsagesVisitor.getUsages();
            HashMap<Element, OccurrencesDesc> hashMap = new HashMap<Element, OccurrencesDesc>();
            int n = 0;
            for (TreePath object2 : collection) {
                Object object3;
                TreePath treePath = CallersTask.resolveDeclarationContext(object2);
                if (treePath == null) continue;
                object = null;
                if (treePath.getLeaf().getKind() != Tree.Kind.BLOCK) {
                    object = workingCopy.getTrees().getElement(treePath);
                } else {
                    object3 = workingCopy.getTrees().getElement(treePath.getParentPath());
                    BlockTree blockTree = (BlockTree)treePath.getLeaf();
                    object = new InitializerElement((Element)object3, blockTree.isStatic());
                }
                if (object == null) continue;
                object3 = (OccurrencesDesc)hashMap.get(object);
                if (object3 == null) {
                    object3 = new OccurrencesDesc(treePath, (Element)object, n++);
                    hashMap.put((Element)object, (OccurrencesDesc)object3);
                }
                ((OccurrencesDesc)object3).occurrences.add(object2);
            }
            ArrayList arrayList = new ArrayList(hashMap.size());
            for (OccurrencesDesc occurrencesDesc : OccurrencesDesc.extract(hashMap)) {
                object = Call.createUsage((CompilationInfo)workingCopy, occurrencesDesc.selection, occurrencesDesc.elm, this.elmDesc, occurrencesDesc.occurrences);
                arrayList.add(object);
            }
            this.result.addAll(arrayList);
        }

        private static TreePath resolveDeclarationContext(TreePath treePath) {
            block5: for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
                switch (treePath2.getLeaf().getKind()) {
                    case BLOCK: {
                        if (treePath2.getParentPath().getLeaf().getKind() != Tree.Kind.CLASS) continue block5;
                        return treePath2;
                    }
                    case METHOD: {
                        return treePath2;
                    }
                    case VARIABLE: {
                        if (treePath2.getParentPath().getLeaf().getKind() != Tree.Kind.CLASS) continue block5;
                        return treePath2;
                    }
                }
            }
            return null;
        }

        private Iterable<? extends List<FileObject>> groupByRoot(Iterable<? extends FileObject> iterable) {
            HashMap<FileObject, LinkedList<FileObject>> hashMap = new HashMap<FileObject, LinkedList<FileObject>>();
            for (FileObject fileObject : iterable) {
                FileObject fileObject2;
                if (this.isCanceled()) {
                    return Collections.emptyList();
                }
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                if (classPath == null || (fileObject2 = classPath.findOwnerRoot(fileObject)) == null || !this.includeTest && UnitTestForSourceQuery.findSources((FileObject)fileObject2).length > 0) continue;
                LinkedList<FileObject> linkedList = (LinkedList<FileObject>)hashMap.get(fileObject2);
                if (linkedList == null) {
                    linkedList = new LinkedList<FileObject>();
                    hashMap.put(fileObject2, linkedList);
                }
                linkedList.add(fileObject);
            }
            return hashMap.values();
        }

        protected final void processFiles(Set<FileObject> set, Task<WorkingCopy> task, ClasspathInfo classpathInfo) throws IOException {
            Iterable<? extends List<FileObject>> iterable = this.groupByRoot(set);
            for (List<FileObject> list : iterable) {
                if (this.isCanceled()) {
                    return;
                }
                JavaSource javaSource = JavaSource.create((ClasspathInfo)(classpathInfo == null ? ClasspathInfo.create((FileObject)list.get(0)) : classpathInfo), list);
                javaSource.runModificationTask(task);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RootResolver
    implements Task<CompilationController> {
        private int offset = -1;
        private TreePathHandle tHandle;
        private final boolean isCallerGraph;
        private Call root;

        public RootResolver(TreePathHandle treePathHandle, boolean bl) {
            this.tHandle = treePathHandle;
            this.isCallerGraph = bl;
        }

        public RootResolver(int n, boolean bl) {
            this.offset = n;
            this.isCallerGraph = bl;
        }

        public void run(CompilationController compilationController) throws Exception {
            TreePath treePath = null;
            Element element = null;
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            for (treePath = this.tHandle == null ? compilationController.getTreeUtilities().pathFor(this.offset) : this.tHandle.resolve((CompilationInfo)compilationController); treePath != null; treePath = treePath.getParentPath()) {
                Tree.Kind kind = treePath.getLeaf().getKind();
                if (kind != Tree.Kind.METHOD && kind != Tree.Kind.METHOD_INVOCATION && kind != Tree.Kind.MEMBER_SELECT) continue;
                element = compilationController.getTrees().getElement(treePath);
                if (element != null && (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR)) break;
                element = null;
            }
            if (element != null) {
                this.root = Call.createRoot((CompilationInfo)compilationController, treePath, element, this.isCallerGraph);
            }
        }

        public Call getRoot() {
            return this.root;
        }
    }
}

