/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.CLIOptions;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXParseException;

public final class TopLogging {
    private static boolean disabledConsole;
    private static final PrintStream OLD_ERR;
    private static final PrintStream DEBUG;
    private static final Pattern unwantedMessages;
    private static String previousUser;
    private static Handler streamHandler;
    private static Handler defaultHandler;

    public TopLogging() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        for (Map.Entry<Object, Object> handlerArray2 : System.getProperties().entrySet()) {
            String i = (String)handlerArray2.getKey();
            if ("sun.os.patch.level".equals(i)) continue;
            String string = (String)handlerArray2.getValue();
            if (!i.endsWith(".level")) continue;
            printStream.print(i);
            printStream.print('=');
            printStream.println(string);
        }
        printStream.close();
        try {
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Logger logger = Logger.getLogger("");
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            logger.removeHandler(handlerArray[i]);
        }
        logger.addHandler(TopLogging.defaultHandler());
        if (!disabledConsole) {
            logger.addHandler(TopLogging.streamHandler());
        }
        logger.addHandler(new LookupDel());
    }

    public static void initializeQuietly() {
        TopLogging.initialize(false);
    }

    static final void initialize() {
        TopLogging.initialize(true);
    }

    private static void initialize(boolean bl) {
        block10: {
            if (previousUser == null || previousUser.equals(System.getProperty("netbeans.user"))) {
                streamHandler = null;
                defaultHandler = null;
            }
            if (System.getProperty("java.util.logging.config.file") != null) {
                return;
            }
            String string = System.getProperty("java.util.logging.config.class");
            String string2 = TopLogging.class.getName();
            if (string != null && !string.equals(string2)) {
                return;
            }
            new TopLogging();
            System.setProperty("java.util.logging.config.class", string2);
            if (bl) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                TopLogging.printSystemInfo(printStream);
                printStream.close();
                try {
                    Logger logger = Logger.getLogger(TopLogging.class.getName());
                    logger.log(Level.INFO, byteArrayOutputStream.toString("utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError();
                }
            }
        }
        if (!(System.err instanceof LgStream)) {
            System.setErr(new LgStream(Logger.getLogger("stderr")));
            if (DEBUG != null) {
                DEBUG.println("initializing stderr");
            }
        }
        if (!(System.out instanceof LgStream)) {
            System.setOut(new LgStream(Logger.getLogger("stderr")));
            if (DEBUG != null) {
                DEBUG.println("initializing stdout");
            }
        }
    }

    private static void printSystemInfo(PrintStream printStream) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        Date date = new Date();
        printStream.println("-------------------------------------------------------------------------------");
        printStream.println(">Log Session: " + dateFormat.format(date));
        printStream.println(">System Info: ");
        String string = System.getProperty("netbeans.buildnumber");
        String string2 = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)string);
        printStream.println("  Product Version         = " + string2);
        printStream.println("  Operating System        = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        printStream.println("  Java; VM; Vendor        = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown"));
        printStream.println("  Runtime                 = " + System.getProperty("java.runtime.name", "unknown") + " " + System.getProperty("java.runtime.version", ""));
        printStream.println("  Java Home               = " + System.getProperty("java.home", "unknown"));
        printStream.print("  System Locale; Encoding = " + Locale.getDefault());
        String string3 = NbBundle.getBranding();
        if (string3 != null) {
            printStream.print(" (" + string3 + ")");
        }
        printStream.println("; " + System.getProperty("file.encoding", "unknown"));
        printStream.println("  Home Directory          = " + System.getProperty("user.home", "unknown"));
        printStream.println("  Current Directory       = " + System.getProperty("user.dir", "unknown"));
        printStream.print("  User Directory          = ");
        printStream.println(CLIOptions.getUserDir());
        printStream.print("  Installation            = ");
        String string4 = System.getProperty("netbeans.dirs");
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                printStream.print(FileUtil.normalizeFile((File)new File(stringTokenizer.nextToken())));
                printStream.print("\n                            ");
            }
        }
        printStream.println(CLIOptions.getHomeDir());
        printStream.println("  Boot & Ext. Classpath   = " + TopLogging.createBootClassPath());
        printStream.println("  Application Classpath   = " + System.getProperty("java.class.path", "unknown"));
        printStream.println("  Startup Classpath       = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
        printStream.println("-------------------------------------------------------------------------------");
    }

    private static String createBootClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        StringBuffer stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
        TopLogging.findBootJars(System.getProperty("java.ext.dirs"), stringBuffer);
        TopLogging.findBootJars(System.getProperty("java.endorsed.dirs"), stringBuffer);
        return stringBuffer.toString();
    }

    private static void findBootJars(String string, StringBuffer stringBuffer) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = fileArray[i].getName().toLowerCase(Locale.US);
                    if (!string2.endsWith(".zip") && !string2.endsWith(".jar")) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(fileArray[i].getPath());
                }
            }
        }
    }

    static Handler createStreamHandler(PrintStream printStream) {
        StreamHandler streamHandler = new StreamHandler(printStream, NbFormatter.FORMATTER);
        return streamHandler;
    }

    private static synchronized Handler streamHandler() {
        if (streamHandler == null) {
            StreamHandler streamHandler = new StreamHandler(OLD_ERR, NbFormatter.FORMATTER);
            streamHandler.setLevel(Level.ALL);
            TopLogging.streamHandler = new NonClose(streamHandler, 500);
        }
        return streamHandler;
    }

    private static synchronized Handler defaultHandler() {
        if (defaultHandler != null) {
            return defaultHandler;
        }
        String string = System.getProperty("netbeans.user");
        if (string != null && !"memory".equals(string) && !CLIOptions.noLogging) {
            try {
                File file = new File(new File(new File(string), "var"), "log");
                file.mkdirs();
                File file2 = new File(file, "messages.log");
                File file3 = new File(file, "messages.log.1");
                File file4 = new File(file, "messages.log.2");
                if (file4.exists()) {
                    file4.delete();
                }
                if (file3.exists()) {
                    file3.renameTo(file4);
                }
                if (file2.exists()) {
                    file2.renameTo(file3);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2, false);
                StreamHandler streamHandler = new StreamHandler(fileOutputStream, NbFormatter.FORMATTER);
                streamHandler.setLevel(Level.ALL);
                streamHandler.setFormatter(NbFormatter.FORMATTER);
                defaultHandler = new NonClose(streamHandler, 5000);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (defaultHandler == null) {
            defaultHandler = TopLogging.streamHandler();
            disabledConsole = true;
        }
        return defaultHandler;
    }

    static void flush(boolean bl) {
        Handler handler;
        System.err.flush();
        Handler handler2 = streamHandler;
        if (handler2 != null) {
            handler2.flush();
        }
        if ((handler = defaultHandler) != null) {
            handler.flush();
        }
        if (bl) {
            streamHandler = null;
            defaultHandler = null;
        }
    }

    static void close() {
        Handler handler;
        Handler handler2 = streamHandler;
        if (handler2 instanceof NonClose) {
            handler = (NonClose)handler2;
            ((NonClose)handler).doClose();
        }
        if ((handler = defaultHandler) != null) {
            NonClose nonClose = (NonClose)handler;
            nonClose.doClose();
        }
    }

    static void exit(int n) {
        TopLogging.flush(false);
        TopSecurityManager.exit((int)n);
    }

    public static void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new Throwable().getStackTrace();
        int n = -1;
        for (int i = 1; i <= Math.min(stackTraceElementArray.length, stackTraceElementArray2.length); ++i) {
            if (stackTraceElementArray[stackTraceElementArray.length - i].equals(stackTraceElementArray2[stackTraceElementArray2.length - i])) continue;
            n = stackTraceElementArray.length - i;
            break;
        }
        TopLogging.doPrintStackTrace(printWriter, throwable, null, n);
    }

    private static void doPrintStackTrace(PrintWriter printWriter, Throwable throwable, Throwable throwable2, int n) {
        int n2;
        Object object;
        Throwable throwable3;
        block10: {
            try {
                if (throwable.getClass().getMethod("printStackTrace", PrintWriter.class).getDeclaringClass() != Throwable.class) {
                    throwable.printStackTrace(printWriter);
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)noSuchMethodException);
            }
        }
        if ((throwable3 = throwable.getCause()) != null) {
            TopLogging.doPrintStackTrace(printWriter, throwable3, throwable, -1);
            printWriter.print("Caused: ");
        }
        String string = throwable.toString();
        if (throwable3 != null && string.endsWith((String)(object = ": " + throwable3))) {
            string = string.substring(0, string.length() - ((String)object).length());
        }
        printWriter.println(string);
        object = throwable.getStackTrace();
        if (throwable2 != null) {
            int n3;
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            for (n2 = ((StackTraceElement[])object).length; n2 > 0 && (n3 = n2 + stackTraceElementArray.length - ((Object)object).length) > 0 && stackTraceElementArray[n3 - 1].equals(object[n2 - 1]); --n2) {
            }
        }
        for (int i = 0; i < n2; ++i) {
            if (i == n) {
                printWriter.print("[catch] at ");
            } else {
                printWriter.print("\tat ");
            }
            printWriter.println(object[i]);
        }
    }

    static {
        Serializable serializable;
        disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
        OLD_ERR = System.err;
        System.setProperty("sun.awt.exception.handler", "org.netbeans.core.startup.TopLogging$AWTHandler");
        PrintStream printStream = null;
        String string = System.getProperty("TopLogging.unwantedMessages");
        if (string != null || Boolean.getBoolean("TopLogging.DEBUG")) {
            try {
                serializable = new File(System.getProperty("java.io.tmpdir"), "TopLogging.log");
                System.err.println("Logging sent to: " + serializable);
                printStream = new PrintStream(new FileOutputStream((File)serializable), true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        DEBUG = printStream;
        serializable = null;
        if (string != null) {
            try {
                serializable = Pattern.compile(string);
                DEBUG.println("On the lookout for log messages matching: " + string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                patternSyntaxException.printStackTrace();
            }
        }
        unwantedMessages = serializable;
    }

    public static final class AWTHandler {
        public static void handle(Throwable throwable) {
            if (throwable.getClass().getName().endsWith(".ExitSecurityException")) {
                return;
            }
            Logger logger = Logger.getLogger("global");
            logger.log(Level.SEVERE, null, throwable);
        }
    }

    private static final class LookupDel
    extends Handler
    implements LookupListener {
        private Lookup.Result<Handler> handlers = Lookup.getDefault().lookupResult(Handler.class);
        private Collection<? extends Handler> instances = this.handlers.allInstances();

        public LookupDel() {
            this.handlers.addLookupListener((LookupListener)this);
        }

        public void publish(LogRecord logRecord) {
            for (Handler handler : this.instances) {
                handler.publish(logRecord);
            }
        }

        public void flush() {
            for (Handler handler : this.instances) {
                handler.flush();
            }
        }

        public void close() throws SecurityException {
            for (Handler handler : this.instances) {
                handler.close();
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.instances = this.handlers.allInstances();
        }
    }

    private static final class LgStream
    extends PrintStream
    implements Runnable {
        private Logger log;
        private StringBuffer sb = new StringBuffer();
        private static RequestProcessor RP = new RequestProcessor("StdErr Flush");
        private RequestProcessor.Task flush = RP.create((Runnable)this, true);

        public LgStream(Logger logger) {
            super(new ByteArrayOutputStream());
            this.log = logger;
        }

        public void write(byte[] byArray, int n, int n2) {
            if (RP.isRequestProcessorThread()) {
                return;
            }
            String string = new String(byArray, n, n2);
            if (unwantedMessages != null && unwantedMessages.matcher(string).find()) {
                new Exception().printStackTrace(DEBUG);
            }
            this.sb.append(string);
            this.checkFlush();
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(int n) {
            if (RP.isRequestProcessorThread()) {
                return;
            }
            this.sb.append((char)n);
            this.checkFlush();
        }

        public void flush() {
            try {
                this.flush.waitFinished(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            super.flush();
        }

        private void checkFlush() {
            try {
                this.flush.schedule(100);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                String string;
                StringBuffer stringBuffer = this.sb;
                synchronized (stringBuffer) {
                    int n = this.sb.indexOf("\n");
                    if (n < 0) {
                        break;
                    }
                    if (n == 0) {
                        this.sb.delete(0, 1);
                        string = "\n";
                    } else {
                        string = this.sb.substring(0, n + 1);
                        this.sb.delete(0, n + 1);
                    }
                }
                this.log.log(Level.INFO, string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NbFormatter
    extends Formatter {
        private static String lineSeparator = System.getProperty("line.separator");
        static Formatter FORMATTER = new NbFormatter();

        private NbFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuilder stringBuilder = new StringBuilder();
            this.print(stringBuilder, logRecord, new HashSet<Throwable>());
            String string = stringBuilder.toString();
            if (DEBUG != null) {
                DEBUG.print("received: " + string);
            }
            if (unwantedMessages != null && unwantedMessages.matcher(string).find()) {
                new Exception().printStackTrace(DEBUG);
            }
            return string;
        }

        private void print(StringBuilder stringBuilder, LogRecord logRecord, Set<Throwable> set) {
            String string = this.formatMessage(logRecord);
            if (string != null && string.indexOf(10) != -1 && logRecord.getThrown() == null) {
                stringBuilder.append(string);
                return;
            }
            if ("stderr".equals(logRecord.getLoggerName()) && logRecord.getLevel() == Level.INFO) {
                stringBuilder.append(string);
                return;
            }
            stringBuilder.append(logRecord.getLevel().getLocalizedName());
            NbFormatter.addLoggerName(stringBuilder, logRecord);
            if (string != null) {
                stringBuilder.append(": ");
                stringBuilder.append(string);
            }
            stringBuilder.append(lineSeparator);
            if (logRecord.getThrown() != null && logRecord.getLevel().intValue() != 1973) {
                LogRecord[] logRecordArray;
                try {
                    logRecordArray = new StringWriter();
                    LogRecord[] logRecordArray2 = new PrintWriter((Writer)logRecordArray);
                    TopLogging.printStackTrace(logRecord.getThrown(), (PrintWriter)logRecordArray2);
                    logRecordArray2.close();
                    stringBuilder.append(logRecordArray.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logRecordArray = NbFormatter.extractDelegates(stringBuilder, logRecord.getThrown(), set);
                if (logRecordArray != null) {
                    for (LogRecord logRecord2 : logRecordArray) {
                        this.print(stringBuilder, logRecord2, set);
                    }
                }
                this.specialProcessing(stringBuilder, logRecord.getThrown(), set);
            }
        }

        private static void addLoggerName(StringBuilder stringBuilder, LogRecord logRecord) {
            String string = logRecord.getLoggerName();
            if (!"".equals(string)) {
                stringBuilder.append(" [");
                stringBuilder.append(string);
                stringBuilder.append(']');
            }
        }

        private static LogRecord[] extractDelegates(StringBuilder stringBuilder, Throwable throwable, Set<Throwable> set) {
            if (!set.add(throwable)) {
                stringBuilder.append("warning: cyclic dependency between annotated throwables");
                return null;
            }
            if (throwable instanceof Callable) {
                Object var3_3 = null;
                try {
                    var3_3 = ((Callable)((Object)throwable)).call();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (var3_3 instanceof LogRecord[]) {
                    return var3_3;
                }
            }
            if (throwable == null) {
                return null;
            }
            return NbFormatter.extractDelegates(stringBuilder, throwable.getCause(), set);
        }

        private void specialProcessing(StringBuilder stringBuilder, Throwable throwable, Set<Throwable> set) {
            Object object;
            String string;
            Exception exception;
            if (throwable instanceof MissingResourceException) {
                exception = (MissingResourceException)throwable;
                string = ((MissingResourceException)exception).getClassName();
                if (string != null) {
                    object = new LogRecord(Level.CONFIG, null);
                    ((LogRecord)object).setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    ((LogRecord)object).setMessage("EXC_MissingResourceException_class_name");
                    ((LogRecord)object).setParameters(new Object[]{string});
                    this.print(stringBuilder, (LogRecord)object, set);
                }
                if ((object = ((MissingResourceException)exception).getKey()) != null) {
                    LogRecord logRecord = new LogRecord(Level.CONFIG, null);
                    logRecord.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    logRecord.setMessage("EXC_MissingResourceException_key");
                    logRecord.setParameters(new Object[]{object});
                    this.print(stringBuilder, logRecord, set);
                }
            }
            if (throwable instanceof SAXParseException) {
                exception = (SAXParseException)throwable;
                string = ((SAXParseException)exception).getPublicId();
                object = ((SAXParseException)exception).getSystemId();
                if (string != null || object != null) {
                    Object[] objectArray;
                    String string2;
                    int n = ((SAXParseException)exception).getColumnNumber();
                    int n2 = ((SAXParseException)exception).getLineNumber();
                    if (n != -1 || n2 != -1) {
                        string2 = "EXC_sax_parse_col_line";
                        objectArray = new Object[]{String.valueOf(string), String.valueOf(object), new Integer(n), new Integer(n2)};
                    } else {
                        string2 = "EXC_sax_parse";
                        objectArray = new Object[]{String.valueOf(string), String.valueOf(object)};
                    }
                    LogRecord logRecord = new LogRecord(Level.CONFIG, null);
                    logRecord.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    logRecord.setMessage(string2);
                    logRecord.setParameters(objectArray);
                    this.print(stringBuilder, logRecord, set);
                }
            }
        }
    }

    private static final class NonClose
    extends Handler
    implements Runnable {
        private static RequestProcessor RP = new RequestProcessor("Logging Flush");
        private static ThreadLocal<Boolean> FLUSHING = new ThreadLocal();
        private final Handler delegate;
        private RequestProcessor.Task flush;
        private int delay;

        public NonClose(Handler handler, int n) {
            this.delegate = handler;
            this.flush = RP.create((Runnable)this, true);
            this.flush.setPriority(1);
            this.delay = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(LogRecord logRecord) {
            this.delegate.publish(logRecord);
            if (!Boolean.TRUE.equals(FLUSHING.get())) {
                try {
                    FLUSHING.set(true);
                    this.flush.schedule(this.delay);
                }
                finally {
                    FLUSHING.set(false);
                }
            }
        }

        public void flush() {
            this.flush.cancel();
            this.flush.waitFinished();
            this.delegate.flush();
        }

        public void close() throws SecurityException {
            this.flush();
            this.delegate.flush();
        }

        public void doClose() throws SecurityException {
            this.flush();
            this.delegate.close();
        }

        public Formatter getFormatter() {
            return this.delegate.getFormatter();
        }

        static Handler getInternal(Handler handler) {
            if (handler instanceof NonClose) {
                return ((NonClose)handler).delegate;
            }
            return handler;
        }

        public void run() {
            this.delegate.flush();
        }
    }
}

