/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.IEndpointStatisticsData;
import com.sun.esb.management.common.data.ProvisioningEndpointStatisticsData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvisioningEndpointStatisticsDataCreator {
    static String[] STATS_TABLE_INDEX = new String[]{"InstanceName"};

    public static TabularData createTabularData(Map<String, IEndpointStatisticsData> map) throws ManagementRemoteException {
        Set<String> instanceNames = map.keySet();
        TabularType endpointStatsTableType = null;
        TabularDataSupport endpointsStatsTable = null;
        CompositeData[] endpointStats = new CompositeData[instanceNames.size()];
        int index = 0;
        for (String instanceName : instanceNames) {
            IEndpointStatisticsData value = map.get(instanceName);
            ProvisioningEndpointStatisticsData data = (ProvisioningEndpointStatisticsData)value;
            endpointStats[index++] = ProvisioningEndpointStatisticsDataCreator.composeProviderEndpointStats(data);
        }
        try {
            if (index > 0 && endpointStats[0] != null) {
                endpointStatsTableType = new TabularType("EndpointStats", "Endpoint Statistic Information", endpointStats[0].getCompositeType(), STATS_TABLE_INDEX);
                endpointsStatsTable = new TabularDataSupport(endpointStatsTableType);
                for (int innerIndex = 0; innerIndex < index; ++innerIndex) {
                    endpointsStatsTable.put(endpointStats[innerIndex]);
                }
            }
        }
        catch (OpenDataException e) {
            throw new ManagementRemoteException(e);
        }
        return endpointsStatsTable;
    }

    protected static CompositeData composeProviderEndpointStats(ProvisioningEndpointStatisticsData data) throws ManagementRemoteException {
        Object ojcStatsType = null;
        if (data.getCategoryToPerformanceDataMap() != null) {
            // empty if block
        }
        ArrayList<String> providerItemNames = new ArrayList<String>();
        providerItemNames.add("InstanceName");
        providerItemNames.add("ActivationTime");
        providerItemNames.add("UpTime");
        providerItemNames.add("NumActiveExchanges");
        providerItemNames.add("NumReceivedRequests");
        providerItemNames.add("NumSentReplies");
        providerItemNames.add("NumReceivedDONEs");
        providerItemNames.add("NumSentDONEs");
        providerItemNames.add("NumReceivedFaults");
        providerItemNames.add("NumSentFaults");
        providerItemNames.add("NumReceivedErrors");
        providerItemNames.add("NumSentErrors");
        providerItemNames.add("ComponentName");
        providerItemNames.add("ME-ResponseTime-Avg");
        providerItemNames.add("ME-ComponentTime-Avg");
        providerItemNames.add("ME-DeliveryChannelTime-Avg");
        providerItemNames.add("ME-MessageServiceTime-Avg");
        if (ojcStatsType != null) {
            providerItemNames.add("PerformanceMeasurements");
        }
        ArrayList<String> providerItemDescriptions = new ArrayList<String>();
        providerItemDescriptions.add("Instance Name");
        providerItemDescriptions.add("Time taken for activation");
        providerItemDescriptions.add("Endpoint upTime");
        providerItemDescriptions.add("Number of Active Exchanges");
        providerItemDescriptions.add("Number of Received Requests");
        providerItemDescriptions.add("Number of Sent Replies");
        providerItemDescriptions.add("Number of Received DONEs");
        providerItemDescriptions.add("Number of Sent DONEs");
        providerItemDescriptions.add("Number of Received Faults");
        providerItemDescriptions.add("Number of Sent Faults");
        providerItemDescriptions.add("Number of Received Errors");
        providerItemDescriptions.add("Number of Sent Errors");
        providerItemDescriptions.add("Component Name");
        providerItemDescriptions.add("Message Exchange ResponseTime Avg in ns");
        providerItemDescriptions.add("Message Exchange ComponentTime Avg in ns");
        providerItemDescriptions.add("Message Exchange DeliveryChannelTime Avg in ns");
        providerItemDescriptions.add("Message Exchange MessageServiceTime  Avg in ns");
        if (ojcStatsType != null) {
            providerItemDescriptions.add("Performance Measurements recorded by OJC Components");
        }
        ArrayList<SimpleType<Object>> providerItemTypes = new ArrayList<SimpleType<Object>>();
        providerItemTypes.add(SimpleType.STRING);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.STRING);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        providerItemTypes.add(SimpleType.LONG);
        if (ojcStatsType != null) {
            providerItemTypes.add((SimpleType<Object>)ojcStatsType);
        }
        ArrayList<Object> providerItemValues = new ArrayList<Object>();
        providerItemValues.add(data.getInstanceName());
        providerItemValues.add(data.getActivationTime());
        providerItemValues.add(new Long(Long.MIN_VALUE));
        providerItemValues.add(data.getNumberOfActiveExchanges());
        providerItemValues.add(data.getNumberOfReceivedRequests());
        providerItemValues.add(data.getNumberOfSentReplies());
        providerItemValues.add(data.getNumberOfReceivedDones());
        providerItemValues.add(data.getNumberOfSentDones());
        providerItemValues.add(data.getNumberOfReceivedFaults());
        providerItemValues.add(data.getNumberOfSentFaults());
        providerItemValues.add(data.getNumberOfReceivedErrors());
        providerItemValues.add(data.getNumberOfSentErrors());
        providerItemValues.add(data.getComponentName());
        providerItemValues.add(data.getMessageExchangeResponseTimeAverage());
        providerItemValues.add(data.getMessageExchangeDeliveryChannelTimeAverage());
        providerItemValues.add(data.getMessageExchangeComponentTimeAverage());
        providerItemValues.add(data.getMessageExchangeServiceTimeAverage());
        if (ojcStatsType != null) {
            // empty if block
        }
        try {
            return new CompositeDataSupport(new CompositeType("ProviderEndpointStats", "Provider Endpoint Statistics", providerItemNames.toArray(new String[0]), providerItemDescriptions.toArray(new String[0]), providerItemTypes.toArray(new SimpleType[0])), providerItemNames.toArray(new String[0]), providerItemValues.toArray(new Object[0]));
        }
        catch (OpenDataException ode) {
            throw new ManagementRemoteException(ode);
        }
    }

    public static void main(String[] args) {
    }
}

