/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repair
extends TreeTranslator {
    protected static final Context.Key<Repair> repairKey = new Context.Key();
    private static final String ERR_MESSAGE = "Uncompilable source code";
    private Symtab syms;
    private Resolve rs;
    private Enter enter;
    private Types types;
    private Log log;
    private TreeMaker make;
    private Env<AttrContext> attrEnv;
    private boolean hasError;
    private JCDiagnostic err;
    private JCTree classLevelErrTree;
    private String classLevelErrMessage;
    private JCTree.JCBlock staticInit;
    private List<JCTree> parents;
    private Set<Name> repairedClassNames = new HashSet<Name>();

    public static Repair instance(Context context) {
        Repair instance = context.get(repairKey);
        if (instance == null) {
            instance = new Repair(context);
        }
        return instance;
    }

    private Repair(Context context) {
        context.put(repairKey, this);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.enter = Enter.instance(context);
        this.types = Types.instance(context);
        this.log = Log.instance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JCTree> T translate(T tree) {
        JCTree parent;
        if (tree == null) {
            return null;
        }
        this.parents = this.parents.prepend(tree);
        try {
            if (this.hasError) {
                T t = super.translate(tree);
                return t;
            }
            this.err = this.log.getErrDiag(tree);
            if (this.err != null) {
                this.hasError = true;
            }
            tree = super.translate(tree);
        }
        finally {
            this.parents = this.parents.tail;
        }
        if (!this.hasError || !(tree instanceof JCTree.JCStatement)) {
            return tree;
        }
        if (tree.getTag() == 14) {
            return tree;
        }
        if ((tree.getTag() == 3 || tree.getTag() == 5) && ((parent = (JCTree)this.parents.head) == null || parent.getTag() != 7 && parent.getTag() != 14)) {
            return tree;
        }
        String msg = this.err != null ? this.err.getMessage(null) : null;
        this.hasError = false;
        this.err = null;
        if (tree.getTag() == 7) {
            ((JCTree.JCBlock)tree).stats = List.of(this.generateErrStat(tree.pos(), msg));
            return tree;
        }
        return (T)this.generateErrStat(tree.pos(), msg);
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        super.visitImport(tree);
        if (this.hasError && this.err != null) {
            this.classLevelErrTree = this.err.getTree();
            this.classLevelErrMessage = this.err.getMessage(null);
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.translateClass(tree.sym);
        this.result = tree;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        super.visitVarDef(tree);
        if (this.hasError) {
            JCTree parent;
            JCTree jCTree = parent = this.parents != null ? (JCTree)this.parents.tail.head : null;
            if (parent != null && parent.getTag() == 3) {
                if (tree.init != null) {
                    tree.init = this.generateErrExpr(tree.init.pos(), this.err != null ? this.err.getMessage(null) : null);
                }
                this.hasError = false;
                this.err = null;
            }
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        super.visitMethodDef(tree);
        if (this.hasError) {
            if (tree.sym != null) {
                tree.sym.flags_field &= 0xFFFFFFFFFFFFFAFFL;
            }
            if (tree.body == null) {
                tree.body = this.make.Block(0L, List.<JCTree.JCStatement>nil());
            }
            tree.body.stats = List.of(this.generateErrStat(tree.pos(), this.err != null ? this.err.getMessage(null) : null));
            this.hasError = false;
            this.err = null;
        }
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        if (tree.isStatic() && this.staticInit == null) {
            this.staticInit = tree;
        }
        List<JCTree.JCStatement> last = null;
        List<JCTree.JCStatement> l = tree.stats;
        while (l.nonEmpty()) {
            l.head = this.translate((JCTree)l.head);
            if (last == null && ((JCTree.JCStatement)l.head).getTag() == 24) {
                last = l;
            }
            l = l.tail;
        }
        if (last != null) {
            last.tail = List.nil();
        }
        this.result = tree;
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        Symbol meth = TreeInfo.symbol(tree.meth);
        if (meth == null || meth.type == null || meth.type.isErroneous()) {
            this.hasError = true;
        }
        super.visitApply(tree);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        Symbol ctor = tree.constructor;
        if (ctor == null || ctor.type == null || ctor.type.isErroneous()) {
            this.hasError = true;
        }
        super.visitNewClass(tree);
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        tree.pat = this.translate(tree.pat);
        List<JCTree.JCStatement> last = null;
        List<JCTree.JCStatement> l = tree.stats;
        while (l.nonEmpty()) {
            l.head = this.translate((JCTree)l.head);
            if (last == null && ((JCTree.JCStatement)l.head).getTag() == 24) {
                last = l;
            }
            l = l.tail;
        }
        if (last != null) {
            last.tail = List.nil();
        }
        this.result = tree;
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        this.hasError = true;
        this.result = tree;
    }

    private JCTree.JCStatement generateErrStat(JCDiagnostic.DiagnosticPosition pos, String msg) {
        this.make.at(pos);
        Type.ClassType ctype = (Type.ClassType)this.syms.runtimeExceptionType;
        JCTree.JCLiteral literal = this.make.Literal(msg != null ? "Uncompilable source code - " + msg : ERR_MESSAGE);
        JCTree.JCNewClass tree = this.make.NewClass(null, null, this.make.QualIdent(ctype.tsym), List.of(literal), null);
        tree.constructor = this.rs.resolveConstructor(pos, this.attrEnv, ctype, List.of(literal.type), null, false, false);
        tree.type = ctype;
        return this.make.Throw(tree);
    }

    private JCTree.JCExpression generateErrExpr(JCDiagnostic.DiagnosticPosition pos, String msg) {
        this.make.at(pos);
        JCTree.JCErroneous expr = this.make.Erroneous(List.of(this.generateErrStat(pos, msg)));
        expr.type = this.syms.errType;
        return expr;
    }

    private JCTree.JCBlock generateErrStaticInit(JCDiagnostic.DiagnosticPosition pos, String msg) {
        this.make.at(pos);
        return this.make.Block(8L, List.of(this.generateErrStat(pos, msg)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateClass(Symbol.ClassSymbol c) {
        if (c == null) {
            return;
        }
        Type st = this.types.supertype(c.type);
        if (st.tag == 10) {
            this.translateClass((Symbol.ClassSymbol)st.tsym);
        }
        if (this.repairedClassNames.contains(c.flatname)) {
            return;
        }
        this.repairedClassNames.add(c.flatname);
        Env<AttrContext> myEnv = this.enter.typeEnvs.get(c);
        if (myEnv == null) {
            return;
        }
        Env<AttrContext> oldEnv = this.attrEnv;
        try {
            this.attrEnv = myEnv;
            TreeMaker oldMake = this.make;
            this.make = this.make.forToplevel(this.attrEnv.toplevel);
            boolean oldHasError = this.hasError;
            JCDiagnostic oldErr = this.err;
            JCTree oldClassLevelErrTree = this.classLevelErrTree;
            String oldClassLevelErrMessage = this.classLevelErrMessage;
            JCTree.JCBlock oldStaticinit = this.staticInit;
            try {
                for (JCTree.JCImport imp : this.attrEnv.toplevel.getImports()) {
                    this.translate(imp);
                    if (this.classLevelErrTree == null) continue;
                    break;
                }
                this.hasError = false;
                this.err = null;
                this.staticInit = null;
                JCTree.JCClassDecl tree = (JCTree.JCClassDecl)this.attrEnv.tree;
                tree.mods = this.translate(tree.mods);
                tree.typarams = this.translateTypeParams(tree.typarams);
                tree.extending = this.translate(tree.extending);
                tree.implementing = this.translate((JCTree)((Object)tree.implementing));
                if (tree.defs != null) {
                    List<JCTree> last = null;
                    List<JCTree> l = tree.defs;
                    while (l != null && l.nonEmpty()) {
                        this.hasError = false;
                        this.err = null;
                        l.head = this.translate((JCTree)l.head);
                        if (this.hasError) {
                            if (last != null) {
                                last.tail = l.tail;
                            } else {
                                tree.defs = l.tail;
                            }
                            if (this.classLevelErrTree == null) {
                                if (this.err != null) {
                                    this.classLevelErrTree = this.err.getTree();
                                    this.classLevelErrMessage = this.err.getMessage(null);
                                } else {
                                    this.classLevelErrTree = (JCTree)l.head;
                                }
                            }
                        } else {
                            last = l;
                        }
                        l = l.tail;
                    }
                    if (this.classLevelErrTree != null) {
                        if (this.staticInit != null) {
                            this.staticInit.stats = List.of(this.generateErrStat(this.classLevelErrTree, this.classLevelErrMessage));
                        } else {
                            tree.defs = tree.defs.prepend(this.generateErrStaticInit(this.classLevelErrTree, this.classLevelErrMessage));
                        }
                    }
                }
            }
            finally {
                this.staticInit = oldStaticinit;
                this.classLevelErrTree = oldClassLevelErrTree;
                this.classLevelErrMessage = oldClassLevelErrMessage;
                this.err = oldErr;
                this.hasError = oldHasError;
                this.make = oldMake;
            }
        }
        finally {
            this.attrEnv = oldEnv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree translateTopLevelClass(Env<AttrContext> env, JCTree tree, TreeMaker localMake) {
        try {
            this.attrEnv = env;
            this.make = localMake;
            this.hasError = false;
            this.parents = List.nil();
            JCTree jCTree = this.translate(tree);
            return jCTree;
        }
        finally {
            this.attrEnv = null;
            this.make = null;
        }
    }

    public void flush() {
        this.repairedClassNames.clear();
    }
}

