/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JButton;
import org.netbeans.lib.uihandler.Decorable;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Decorations {
    private static final SimpleFormatter FORMATTER = new SimpleFormatter();

    Decorations() {
    }

    public static void decorate(LogRecord logRecord, Decorable decorable) {
        String string;
        if (logRecord.getMessage() == null) {
            decorable.setName("Seq: " + logRecord.getSequenceNumber());
        } else {
            decorable.setName(logRecord.getMessage());
        }
        if (logRecord.getResourceBundle() != null) {
            try {
                string = logRecord.getResourceBundle().getString(logRecord.getMessage());
                if (logRecord.getParameters() != null) {
                    string = MessageFormat.format(string, logRecord.getParameters());
                }
                decorable.setDisplayName(string);
            }
            catch (MissingResourceException missingResourceException) {
                Logger.getAnonymousLogger().log(Level.INFO, null, missingResourceException);
            }
            try {
                string = logRecord.getResourceBundle().getString(logRecord.getMessage() + "_ICON_BASE");
                decorable.setIconBaseWithExtension(string);
            }
            catch (MissingResourceException missingResourceException) {
                decorable.setIconBaseWithExtension("org/netbeans/lib/uihandler/def.png");
            }
        }
        if (logRecord.getThrown() != null) {
            decorable.setIconBaseWithExtension("org/netbeans/lib/uihandler/exception.gif");
            string = "HTML_exception";
        }
        if ("UI_ACTION_BUTTON_PRESS".equals(logRecord.getMessage())) {
            decorable.setDisplayName(Decorations.cutAmpersand(Decorations.getParam(logRecord, 4)));
            String string2 = Decorations.getParam(logRecord, 1, String.class);
            if (string2 != null && string2.contains("Toolbar") || Decorations.getParam(logRecord, 0, Object.class) instanceof JButton) {
                decorable.setIconBaseWithExtension("org/netbeans/lib/uihandler/toolbars.gif");
                string = "HTML_toolbar";
            } else if (string2 != null && string2.contains("MenuItem")) {
                decorable.setIconBaseWithExtension("org/netbeans/lib/uihandler/menus.gif");
                string = "HTML_menu";
            }
        } else if ("UI_ACTION_KEY_PRESS".equals(logRecord.getMessage())) {
            decorable.setDisplayName(Decorations.cutAmpersand(Decorations.getParam(logRecord, 4)));
            decorable.setIconBaseWithExtension("org/netbeans/lib/uihandler/key.png");
            string = "HTML_key";
        } else if ("UI_ACTION_EDITOR".equals(logRecord.getMessage())) {
            decorable.setDisplayName(Decorations.cutAmpersand(Decorations.getParam(logRecord, 4)));
            decorable.setIconBaseWithExtension("org/netbeans/lib/uihandler/key.png");
            string = "HTML_key";
        } else if ("UI_ENABLED_MODULES".equals(logRecord.getMessage())) {
            decorable.setDisplayName(NbBundle.getMessage(Decorations.class, (String)"MSG_EnabledModules"));
            decorable.setIconBaseWithExtension("org/netbeans/lib/uihandler/module.gif");
            string = null;
        } else if ("UI_DISABLED_MODULES".equals(logRecord.getMessage())) {
            decorable.setDisplayName(NbBundle.getMessage(Decorations.class, (String)"MSG_DisabledModules"));
            decorable.setIconBaseWithExtension("org/netbeans/lib/uihandler/module.gif");
            string = null;
        } else if ("UI_USER_CONFIGURATION".equals(logRecord.getMessage())) {
            decorable.setDisplayName(NbBundle.getMessage(Decorations.class, (String)"MSG_USER_CONFIGURATION"));
            string = null;
        }
        decorable.setShortDescription(FORMATTER.format(logRecord));
    }

    private static <T> T getParam(LogRecord logRecord, int n, Class<T> clazz) {
        if (logRecord == null || logRecord.getParameters() == null || logRecord.getParameters().length <= n) {
            return null;
        }
        Object object = logRecord.getParameters()[n];
        return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
    }

    private static String getParam(LogRecord logRecord, int n) {
        Object[] objectArray = logRecord.getParameters();
        if (objectArray == null || objectArray.length <= n || !(objectArray[n] instanceof String)) {
            return "";
        }
        return (String)objectArray[n];
    }

    static String cutAmpersand(String string) {
        String string2 = string;
        int n = string.indexOf("(&");
        string2 = n >= 0 && n + 3 < string.length() && string.charAt(n + 3) == ')' ? string.substring(0, n) + string.substring(n + 4) : ((n = string.indexOf(38)) < 0 ? string : (n == string.length() - 1 ? string.substring(0, n) : (" ".equals(string.substring(n + 1, n + 2)) ? string : string.substring(0, n) + string.substring(n + 1))));
        return string2;
    }
}

