/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.prefs.Preferences;
import org.netbeans.modules.groovy.support.options.SupportOptionsPanelController;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroovySettings
extends AdvancedOption {
    private static final String GROOVY_HOME = "groovyHome";
    private static final String GROOVY_DOC = "groovyDoc";
    private static final String GROOVY_HOME_PATH = "GROOVY_HOME";
    private static final String GROOVY_EXECUTABLE = "groovy";

    public String getGroovyHome() {
        String string = this.prefs().get(GROOVY_HOME, "");
        if (string == null || string.length() <= 0) {
            string = this.findGroovyPlatform();
        }
        return string;
    }

    public void setGroovyHome(String string) {
        this.prefs().put(GROOVY_HOME, string);
    }

    public String getGroovyDoc() {
        return this.prefs().get(GROOVY_DOC, "");
    }

    public void setGroovyDoc(String string) {
        this.prefs().put(GROOVY_DOC, string);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(GroovySettings.class, (String)"AdvancedOption_DisplayName_Support");
    }

    public String getTooltip() {
        return NbBundle.getMessage(GroovySettings.class, (String)"AdvancedOption_Tooltip_Support");
    }

    public OptionsPanelController create() {
        return new SupportOptionsPanelController();
    }

    private Preferences prefs() {
        return NbPreferences.forModule(GroovySettings.class);
    }

    private String findGroovyPlatform() {
        String string = System.getenv(GROOVY_HOME_PATH);
        if (string == null) {
            for (String string2 : GroovySettings.dirsOnPath()) {
                File file = null;
                file = Utilities.isWindows() ? new File(string2, "groovy.exe") : new File(string2, GROOVY_EXECUTABLE);
                if (!file.isFile()) continue;
                try {
                    string = file.getCanonicalFile().getParentFile().getParent();
                    break;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
        return string;
    }

    public static Iterable<String> dirsOnPath() {
        String string = System.getenv("PATH");
        if (string == null) {
            string = System.getenv("Path");
        }
        if (string == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(string.split(File.pathSeparator)));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (new File(string2).isDirectory()) continue;
            iterator.remove();
        }
        return NbCollections.iterable(linkedHashSet.iterator());
    }
}

