/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.sql.support;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Parameters;

public final class SQLIdentifiers {
    private SQLIdentifiers() {
    }

    public static Quoter createQuoter(DatabaseMetaData databaseMetaData) {
        return new DatabaseMetaDataQuoter(databaseMetaData);
    }

    private static class DatabaseMetaDataQuoter
    extends Quoter {
        private static final Logger LOGGER = Logger.getLogger(DatabaseMetaDataQuoter.class.getName());
        private static final int LC_RULE = 0;
        private static final int UC_RULE = 1;
        private static final int MC_RULE = 2;
        private final String extraNameChars;
        private final int caseRule;

        private DatabaseMetaDataQuoter(DatabaseMetaData databaseMetaData) {
            super(DatabaseMetaDataQuoter.getQuoteString(databaseMetaData));
            this.extraNameChars = DatabaseMetaDataQuoter.getExtraNameChars(databaseMetaData);
            this.caseRule = DatabaseMetaDataQuoter.getCaseRule(databaseMetaData);
        }

        public final String quoteIfNeeded(String string) {
            Parameters.notNull((CharSequence)"identifier", (Object)string);
            if (this.needToQuote(string)) {
                return this.doQuote(string);
            }
            return string;
        }

        private boolean needToQuote(String string) {
            assert (string != null);
            if (this.alreadyQuoted(string)) {
                return false;
            }
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!this.charNeedsQuoting(string.charAt(i), i == 0)) continue;
                return true;
            }
            if (this.caseRule == 1 && DatabaseMetaDataQuoter.containsLowerCase(string)) {
                return true;
            }
            return this.caseRule == 0 && DatabaseMetaDataQuoter.containsUpperCase(string);
        }

        private boolean charNeedsQuoting(char c, boolean bl) {
            if (DatabaseMetaDataQuoter.isUpperCase(c) || DatabaseMetaDataQuoter.isLowerCase(c)) {
                return false;
            }
            if (DatabaseMetaDataQuoter.isNumber(c) || c == '_') {
                return bl;
            }
            return this.extraNameChars.indexOf(c) == -1;
        }

        private static boolean isUpperCase(char c) {
            return c >= 'A' && c <= 'Z';
        }

        private static boolean isLowerCase(char c) {
            return c >= 'a' && c <= 'z';
        }

        private static boolean isNumber(char c) {
            return c >= '0' && c <= '9';
        }

        private static boolean containsLowerCase(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!DatabaseMetaDataQuoter.isLowerCase(string.charAt(i))) continue;
                return true;
            }
            return false;
        }

        private static boolean containsUpperCase(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!DatabaseMetaDataQuoter.isUpperCase(string.charAt(i))) continue;
                return true;
            }
            return false;
        }

        private static String getExtraNameChars(DatabaseMetaData databaseMetaData) {
            String string = "";
            try {
                string = databaseMetaData.getExtraNameCharacters();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, "DatabaseMetaData.getExtraNameCharacters() failed (" + sQLException.getMessage() + "). " + "Using standard set of characters");
                LOGGER.log(Level.FINE, null, sQLException);
            }
            return string;
        }

        private static String getQuoteString(DatabaseMetaData databaseMetaData) {
            String string = "\"";
            try {
                string = databaseMetaData.getIdentifierQuoteString().trim();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, "DatabaseMetaData.getIdentifierQuoteString() failed (" + sQLException.getMessage() + "). " + "Using '\"' for quoting SQL identifiers");
                LOGGER.log(Level.FINE, null, sQLException);
            }
            return string;
        }

        private static int getCaseRule(DatabaseMetaData databaseMetaData) {
            int n = 1;
            try {
                n = databaseMetaData.storesUpperCaseIdentifiers() ? 1 : (databaseMetaData.storesLowerCaseIdentifiers() ? 0 : (databaseMetaData.storesMixedCaseIdentifiers() ? 2 : 1));
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, "Exception trying to find out how the database stores unquoted identifiers, assuming upper case: " + sQLException.getMessage());
                LOGGER.log(Level.FINE, null, sQLException);
            }
            return n;
        }
    }

    public static abstract class Quoter {
        final String quoteString;

        Quoter(String string) {
            this.quoteString = string;
        }

        public abstract String quoteIfNeeded(String var1);

        boolean alreadyQuoted(String string) {
            return string.startsWith(this.quoteString) && string.endsWith(this.quoteString);
        }

        String doQuote(String string) {
            return this.quoteString + string + this.quoteString;
        }
    }
}

