/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.validation.ui;

import java.io.IOException;
import java.util.List;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationOutputWindow {
    OutputWriter normalWriter;
    OutputWriter errorWriter;
    private String warningMsgType = null;
    private String errorMsgType = null;

    public ValidationOutputWindow() {
        this.initialise();
    }

    public void displayValidationInformation(List<Validator.ResultItem> list) {
        for (Validator.ResultItem resultItem : list) {
            Validator.ResultType resultType = resultItem.getType();
            Component component = resultItem.getComponents();
            try {
                if (resultType.equals((Object)Validator.ResultType.ERROR)) {
                    this.showError(resultItem);
                } else if (resultType.equals((Object)Validator.ResultType.WARNING)) {
                    this.showWarning(resultItem);
                } else if (resultType.equals((Object)Validator.ResultType.ADVICE)) {
                    this.showAdvice(resultItem);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            this.normalWriter.println("");
        }
        this.printCountSummary(list);
    }

    private void initialise() {
        InputOutput inputOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(ValidationOutputWindow.class, (String)"TITLE_XML_check_window"), false);
        this.normalWriter = inputOutput.getOut();
        this.errorWriter = inputOutput.getErr();
        this.warningMsgType = NbBundle.getMessage(ValidationOutputWindow.class, (String)"MSG_WARNING");
        this.errorMsgType = NbBundle.getMessage(ValidationOutputWindow.class, (String)"MSG_ERROR");
    }

    private void showError(Validator.ResultItem resultItem) throws IOException {
        this.showMessage(this.errorMsgType, resultItem, true);
    }

    private void showWarning(Validator.ResultItem resultItem) throws IOException {
        this.showMessage(this.warningMsgType, resultItem, false);
    }

    private void showMessage(String string, Validator.ResultItem resultItem, boolean bl) throws IOException {
        ValidationOutputListener validationOutputListener = new ValidationOutputListener(resultItem);
        int n = this.getLineNumber(resultItem);
        int n2 = this.getColumnNumber(resultItem);
        if (n == -1 || n2 == -1) {
            this.errorWriter.println(this.getFileName(resultItem) + ": " + NbBundle.getMessage(ValidationOutputWindow.class, (String)"MSG_Position_Unavailable"), (OutputListener)validationOutputListener, bl);
        } else {
            this.errorWriter.println(this.getFileName(resultItem) + ":" + n + "," + n2, (OutputListener)validationOutputListener, bl);
        }
        this.errorWriter.println(string + " " + resultItem.getDescription());
    }

    private void showAdvice(Validator.ResultItem resultItem) throws IOException {
        this.normalWriter.println(this.getFileName(resultItem) + " :" + this.getLineNumber(resultItem) + "," + this.getColumnNumber(resultItem));
        this.normalWriter.println(resultItem.getDescription());
    }

    private String getFileName(Validator.ResultItem resultItem) {
        assert (resultItem.getModel() != null) : "Model associated with ResultItem is null";
        String string = ((FileObject)resultItem.getModel().getModelSource().getLookup().lookup(FileObject.class)).getPath();
        return string;
    }

    private StyledDocument getStyledDocument(Component component) {
        Model model;
        boolean bl = false;
        DataObject dataObject = null;
        try {
            model = component.getModel();
            if (model == null) {
                return null;
            }
            dataObject = DataObject.find((FileObject)((FileObject)model.getModelSource().getLookup().lookup(FileObject.class)));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        model = (CloneableEditorSupport)dataObject.getCookie(EditorCookie.class);
        StyledDocument styledDocument = model.getDocument();
        return styledDocument;
    }

    private int getLineNumber(Validator.ResultItem resultItem) {
        int n;
        if (resultItem.getComponents() != null) {
            StyledDocument styledDocument = this.getStyledDocument(resultItem.getComponents());
            if (styledDocument == null) {
                return -1;
            }
            int n2 = this.getPosition(resultItem.getComponents());
            n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n2) + 1;
        } else {
            n = resultItem.getLineNumber();
        }
        return n;
    }

    private int getColumnNumber(Validator.ResultItem resultItem) {
        int n;
        if (resultItem.getComponents() != null) {
            StyledDocument styledDocument = this.getStyledDocument(resultItem.getComponents());
            if (styledDocument == null) {
                return -1;
            }
            int n2 = this.getPosition(resultItem.getComponents());
            n = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n2);
        } else {
            n = resultItem.getColumnNumber();
        }
        return n;
    }

    private int getPosition(Component component) {
        int n = 0;
        if (component instanceof DocumentComponent) {
            n = ((DocumentComponent)component).findPosition();
        }
        return n;
    }

    private void printCountSummary(List<Validator.ResultItem> list) {
        int n = 0;
        int n2 = 0;
        for (Validator.ResultItem resultItem : list) {
            if (resultItem.getType().equals((Object)Validator.ResultType.ERROR)) {
                ++n2;
                continue;
            }
            if (!resultItem.getType().equals((Object)Validator.ResultType.WARNING)) continue;
            ++n;
        }
        this.normalWriter.println(n2 + " Error(s),  " + n + " Warning(s).");
    }

    private final class ValidationOutputListener
    implements OutputListener {
        FileObject fileObject;
        Validator.ResultItem resultItem;

        public ValidationOutputListener(Validator.ResultItem resultItem) {
            this.fileObject = (FileObject)resultItem.getModel().getModelSource().getLookup().lookup(FileObject.class);
            this.resultItem = resultItem;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.fileObject);
                if (dataObject == null) {
                    return;
                }
                ShowCookie showCookie = (ShowCookie)dataObject.getCookie(ShowCookie.class);
                if (showCookie != null) {
                    showCookie.show(this.resultItem);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

