/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLabelUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.diff.Diff;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.insync.ParserAnnotation;
import org.netbeans.modules.visualweb.insync.Util;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.w3c.tidy.Tidy;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ErrorPanelImpl
extends JPanel
implements JsfForm.ErrorPanel {
    private ParserAnnotation[] errors;
    private DefaultListModel model;
    private final FacesModel facesModel;
    private final JsfForm.ErrorPanelCallback errorPanelCallback;
    private ParserAnnotation activated = null;
    private JButton convertButton;
    private JList errorList;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane listScrollPane;
    private JButton previewButton;
    private JTextArea textArea;

    public ErrorPanelImpl(FacesModel facesModel, final ParserAnnotation[] parserAnnotationArray, JsfForm.ErrorPanelCallback errorPanelCallback) {
        if (facesModel == null) {
            throw new IllegalArgumentException("Null FacesModel.");
        }
        if (parserAnnotationArray == null) {
            throw new IllegalArgumentException("Null errors array.");
        }
        if (errorPanelCallback == null) {
            throw new NullPointerException("Null ErrorPanelCallback!");
        }
        this.errors = parserAnnotationArray;
        this.facesModel = facesModel;
        this.errorPanelCallback = errorPanelCallback;
        this.initComponents();
        this.updateErrors();
        Font font = this.jLabel3.getFont();
        if (font != null) {
            int n = font.getSize();
            float f = 2 * n;
            Font font2 = font.deriveFont(f);
            this.jLabel3.setFont(font2);
        }
        this.convertButton.setText(NbBundle.getMessage(ErrorPanelImpl.class, (String)"Convert"));
        this.previewButton.setText(NbBundle.getMessage(ErrorPanelImpl.class, (String)"Preview"));
        this.convertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanelImpl.convertToXHTML(ErrorPanelImpl.this.facesModel);
                ErrorPanelImpl.this.errorPanelCallback.updateTopComponentForErrors();
            }
        });
        this.previewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanelImpl.preview(ErrorPanelImpl.this.facesModel);
            }
        });
        this.textArea.setEnabled(false);
        this.textArea.setDisabledTextColor(Color.BLACK);
        this.textArea.setFont((Font)UIManager.getDefaults().get("Label.font"));
        this.listScrollPane.setBorder(null);
        this.errorList.setCellRenderer(new ErrorCellRenderer());
        this.errorList.addMouseListener(new MouseAdapter(){

            private ParserAnnotation getSelected(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = ErrorPanelImpl.this.errorList.locationToIndex(point);
                Rectangle rectangle = ErrorPanelImpl.this.errorList.getCellBounds(n, n);
                if (rectangle != null && rectangle.contains(point)) {
                    return parserAnnotationArray[n];
                }
                return null;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ErrorPanelImpl.this.activated = this.getSelected(mouseEvent);
                ErrorPanelImpl.this.errorList.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ErrorPanelImpl.this.activated = null;
                ErrorPanelImpl.this.errorList.repaint();
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Line.Set set;
                DataObject dataObject;
                ParserAnnotation parserAnnotation = this.getSelected(mouseEvent);
                if (parserAnnotation == null) {
                    return;
                }
                FileObject fileObject = parserAnnotation.getFileObject();
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    return;
                }
                LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                if (lineCookie != null && (set = lineCookie.getLineSet()) != null) {
                    Line line = set.getCurrent(parserAnnotation.getLine() - 1);
                    line.show(2);
                }
            }
        });
    }

    public void updateErrors() {
        this.textArea.setText(NbBundle.getMessage(ErrorPanelImpl.class, (String)"ErrorDescription"));
        FacesModel facesModel = this.facesModel;
        this.errors = facesModel.getErrors();
        DefaultListModel<ParserAnnotation> defaultListModel = new DefaultListModel<ParserAnnotation>();
        boolean bl = false;
        for (int i = 0; i < this.errors.length; ++i) {
            String string;
            defaultListModel.addElement(this.errors[i]);
            if (this.errors[i].getFileObject() == null || (string = this.errors[i].getFileObject().getExt()) == null || string.indexOf("jsp") == -1) continue;
            bl = true;
        }
        this.convertButton.setEnabled(bl);
        this.previewButton.setEnabled(bl);
        this.model = defaultListModel;
        this.errorList.setModel(this.model);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.textArea = new JTextArea();
        this.convertButton = new JButton();
        this.previewButton = new JButton();
        this.jPanel1 = new JPanel();
        this.listScrollPane = new JScrollPane();
        this.errorList = new JList();
        this.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.setLayout(new GridBagLayout());
        this.jPanel2.setBackground(Color.red);
        this.jLabel3.setForeground(Color.white);
        this.jLabel3.setText(NbBundle.getMessage(ErrorPanelImpl.class, (String)"SourceFileError"));
        this.jPanel2.add(this.jLabel3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.textArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 12, 11);
        this.add((Component)this.convertButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 12, 11);
        this.add((Component)this.previewButton, gridBagConstraints);
        this.jPanel1.setBackground(Color.white);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.listScrollPane.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.listScrollPane.setViewportView(this.errorList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.add((Component)this.listScrollPane, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void convertToXHTML(FacesModel facesModel) {
        FacesModel facesModel2;
        block13: {
            facesModel2 = facesModel;
            facesModel2.flush();
            StyledDocument styledDocument = facesModel2.getMarkupUnit().getSourceDocument();
            if (styledDocument == null) {
                return;
            }
            Tidy tidy = ErrorPanelImpl.getTidy();
            String string = ErrorPanelImpl.rewrite(tidy, styledDocument);
            if (string == null || string.length() == 0) {
                return;
            }
            try {
                try {
                    if (styledDocument instanceof BaseDocument) {
                        ((BaseDocument)styledDocument).atomicLock();
                    }
                    if (styledDocument instanceof AbstractDocument) {
                        ((AbstractDocument)((Object)styledDocument)).replace(0, styledDocument.getLength(), string, null);
                    } else {
                        styledDocument.remove(0, styledDocument.getLength());
                        styledDocument.insertString(0, string, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                    Object var7_6 = null;
                    if (styledDocument instanceof BaseDocument) {
                        ((BaseDocument)styledDocument).atomicUnlock();
                    }
                    break block13;
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (styledDocument instanceof BaseDocument) {
                    ((BaseDocument)styledDocument).atomicUnlock();
                }
                throw throwable;
            }
            if (styledDocument instanceof BaseDocument) {
                ((BaseDocument)styledDocument).atomicUnlock();
            }
        }
        facesModel2.sync();
    }

    private static String rewrite(Tidy tidy, Document document) {
        Object object;
        CharSequence charSequence;
        StringBufferInputStream stringBufferInputStream = null;
        try {
            charSequence = document.getText(0, document.getLength());
            stringBufferInputStream = new StringBufferInputStream((String)charSequence);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(16, (Throwable)badLocationException);
            return "";
        }
        charSequence = new StringBuffer(document.getLength() + 500);
        StringBufferOutputStream stringBufferOutputStream = new StringBufferOutputStream((StringBuffer)charSequence);
        boolean bl = tidy.getConfiguration().outputJspMode && !tidy.getConfiguration().inputJspMode;
        tidy.parse((InputStream)new Tidy.EntityWrapperInputStream((InputStream)stringBufferInputStream), (OutputStream)new Tidy.EntityWrapperOutputStream((OutputStream)stringBufferOutputStream, bl));
        String string = ((StringBuffer)charSequence).toString();
        if (string.length() == 0) {
            return string;
        }
        org.w3c.dom.Document document2 = null;
        try {
            object = new InputSource(new StringReader(string));
            boolean bl2 = false;
            DocumentBuilder documentBuilder = MarkupService.createRaveSourceDocumentBuilder((boolean)bl2);
            documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            document2 = documentBuilder.parse((InputSource)object);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify(1, (Throwable)sAXException);
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ErrorManager.getDefault().notify(1, (Throwable)parserConfigurationException);
            return null;
        }
        if (document2 == null) {
            return "";
        }
        object = Util.getHtmlStream((org.w3c.dom.Document)document2);
        return object;
    }

    private static void preview(FacesModel facesModel) {
        DataObject dataObject;
        FacesModel facesModel2 = facesModel;
        facesModel2.flush();
        StyledDocument styledDocument = facesModel2.getMarkupUnit().getSourceDocument();
        if (styledDocument == null) {
            return;
        }
        Tidy tidy = ErrorPanelImpl.getTidy();
        FileObject fileObject = facesModel2.getMarkupFile();
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            dataObject = null;
        }
        ErrorPanelImpl.diff(tidy, styledDocument, dataObject);
    }

    private static boolean diff(Tidy tidy, Document document, DataObject dataObject) {
        String string;
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(16, (Throwable)badLocationException);
            return false;
        }
        String string2 = ErrorPanelImpl.rewrite(tidy, document);
        String string3 = dataObject.getPrimaryFile().getMIMEType();
        if (string2 == null || string2.length() == 0) {
            ErrorManager.getDefault().log("Somehow got empty diff output");
            return false;
        }
        Diff diff = Diff.getDefault();
        if (diff == null) {
            return false;
        }
        String string4 = NbBundle.getMessage(ErrorPanelImpl.class, (String)"DiffBefore");
        String string5 = NbBundle.getMessage(ErrorPanelImpl.class, (String)"DiffAfter");
        String string6 = string4;
        String string7 = string5;
        Component component = null;
        try {
            component = diff.createDiff(string4, string6, (Reader)new StringReader(string), string5, string7, (Reader)new StringReader(string2), string3);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
        if (component == null) {
            return false;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, NbBundle.getMessage(ErrorPanelImpl.class, (String)"TITLE_diff"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setMessageType(-1);
        dialogDescriptor.setOptionType(2);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        return dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION;
    }

    private static Tidy getTidy() {
        Tidy tidy = new Tidy();
        tidy.getConfiguration().outputJspMode = true;
        tidy.getConfiguration().inputJspMode = true;
        tidy.setOnlyErrors(false);
        tidy.setShowWarnings(false);
        tidy.setQuiet(true);
        tidy.setXmlTags(false);
        tidy.setXHTML(true);
        return tidy;
    }

    private static final class HyperlinkLabelUI
    extends MetalLabelUI {
        private HyperlinkLabelUI() {
        }

        protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = n;
            int n4 = n2;
            int n5 = fontMetrics.stringWidth(string);
            int n6 = 1;
            graphics.fillRect(n3, n4 + 1, n5, n6);
        }
    }

    private class ErrorCellRenderer
    extends DefaultListCellRenderer {
        ErrorCellRenderer() {
            this.setUI(new HyperlinkLabelUI());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            bl2 = false;
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            assert (component == this);
            if (object instanceof ParserAnnotation) {
                ParserAnnotation parserAnnotation = (ParserAnnotation)object;
                String string = parserAnnotation.getFileObject().getNameExt();
                int n2 = string.lastIndexOf(47);
                if (n2 != -1) {
                    string = string.substring(n2);
                }
                this.setText(NbBundle.getMessage(ErrorPanelImpl.class, (String)"LineFormat", (Object)string, (Object)Integer.toString(parserAnnotation.getLine()), (Object)parserAnnotation.getMessage()));
                if (parserAnnotation.getIcon() != null) {
                    this.setIcon(parserAnnotation.getIcon());
                }
                if (parserAnnotation == ErrorPanelImpl.this.activated) {
                    component.setForeground(Color.RED);
                } else {
                    component.setForeground(Color.BLUE);
                }
                this.setBackground(jList.getBackground());
            }
            return component;
        }
    }

    private static class StringBufferOutputStream
    extends OutputStream {
        private StringBuffer sb;

        public StringBufferOutputStream(StringBuffer stringBuffer) {
            this.sb = stringBuffer;
        }

        public void write(int n) {
            this.sb.append((char)n);
        }
    }
}

