/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.designer.jsf.JsfSupportUtilities;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJsfTopComponent
extends TopComponent
implements ClipboardOwner {
    protected final transient CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    protected final transient CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    protected final transient DeleteActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    private final transient OwnPaste pasteActionPerformer = new OwnPaste();
    private CBListener cblistener;
    protected final JsfForm jsfForm;
    protected final Designer designer;

    public AbstractJsfTopComponent(JsfForm jsfForm, Designer designer) {
        this.jsfForm = jsfForm;
        this.designer = designer;
    }

    protected void designerActivated() {
        this.cblistener = new CBListener();
        Clipboard clipboard = AbstractJsfTopComponent.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            exClipboard.addClipboardListener((ClipboardListener)WeakListeners.create(ClipboardListener.class, (EventListener)((Object)this.cblistener), (Object)exClipboard));
        }
        this.updatePasteAction();
        this.jsfForm.setModelActivated(true);
    }

    protected void designerDeactivated() {
        this.jsfForm.setModelActivated(false);
        this.cblistener = null;
        this.deactivateActions();
    }

    protected abstract void deleteSelection();

    protected abstract Transferable copy();

    protected abstract Element getPasteParentComponent();

    protected abstract void selectComponents(Element[] var1);

    protected abstract void showKeyboardPopup();

    public void deactivateActions() {
    }

    void updatePasteAction() {
        Clipboard clipboard = AbstractJsfTopComponent.getClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (this.jsfForm.canPasteTransferable(this.designer.getSelectedComponents(), transferable)) {
            PasteType[] pasteTypeArray = new PasteType[]{new Paste()};
            this.pasteActionPerformer.setPasteTypes(pasteTypeArray);
            return;
        }
        this.pasteActionPerformer.setPasteTypes(null);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    public UndoRedo getUndoRedo() {
        return this.jsfForm.isValid() ? this.jsfForm.getUndoManager() : UndoRedo.NONE;
    }

    protected void removeChildrenComponents(List<Element> list) {
        ListIterator<Element> listIterator = list.listIterator();
        block0: while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            for (Element element2 : list) {
                if (element == element2 || !AbstractJsfTopComponent.isBelow(element2, element)) continue;
                listIterator.remove();
                continue block0;
            }
        }
    }

    private static boolean isBelow(Element element, Element element2) {
        if (element2 == null) {
            return false;
        }
        if (element2 == element) {
            return true;
        }
        return AbstractJsfTopComponent.isBelow(element, JsfSupportUtilities.getParentComponent(element2));
    }

    protected void installActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", this.copyActionPerformer);
        actionMap.put("cut-to-clipboard", this.cutActionPerformer);
        actionMap.put("delete", this.deleteActionPerformer);
        actionMap.put("paste-from-clipboard", this.pasteActionPerformer);
        actionMap.put("org.openide.actions.PopupAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AbstractJsfTopComponent.this.showKeyboardPopup();
                    }
                });
            }
        });
    }

    private class CBListener
    implements ClipboardListener {
        private CBListener() {
        }

        public void clipboardChanged(ClipboardEvent clipboardEvent) {
            if (!clipboardEvent.isConsumed()) {
                if (SwingUtilities.isEventDispatchThread()) {
                    AbstractJsfTopComponent.this.updatePasteAction();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AbstractJsfTopComponent.this.updatePasteAction();
                        }
                    });
                }
            }
        }
    }

    class CopyCutActionPerformer
    extends AbstractAction {
        boolean isCopy;

        public CopyCutActionPerformer(boolean bl) {
            this.isCopy = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.performAction(null);
        }

        public void performAction(SystemAction systemAction) {
            Transferable transferable;
            if (AbstractJsfTopComponent.this.designer.isInlineEditing() && (transferable = AbstractJsfTopComponent.this.designer.inlineCopyText(!this.isCopy)) != null) {
                AbstractJsfTopComponent.getClipboard().setContents(transferable, AbstractJsfTopComponent.this);
                return;
            }
            transferable = AbstractJsfTopComponent.this.copy();
            if (transferable == null) {
                return;
            }
            if (transferable != null) {
                AbstractJsfTopComponent.getClipboard().setContents(transferable, AbstractJsfTopComponent.this);
                if (!this.isCopy) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AbstractJsfTopComponent.this.designer.finishInlineEditing(false);
                            AbstractJsfTopComponent.this.deleteSelection();
                        }
                    });
                }
            }
        }
    }

    class DeleteActionPerformer
    extends AbstractAction {
        DeleteActionPerformer() {
        }

        public void actionPerformed(final ActionEvent actionEvent) {
            if (EventQueue.isDispatchThread()) {
                this.doActionPerformed(actionEvent);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DeleteActionPerformer.this.doActionPerformed(actionEvent);
                    }
                });
            }
        }

        private void doActionPerformed(ActionEvent actionEvent) {
            if (AbstractJsfTopComponent.this.designer.isInlineEditing()) {
                AbstractJsfTopComponent.this.designer.invokeDeleteNextCharAction(actionEvent);
                return;
            }
            if (Utilities.getOperatingSystem() == 4096 && AbstractJsfTopComponent.this.designer.isInlineEditing() && actionEvent.getSource() == this) {
                return;
            }
            this.performAction(null);
        }

        public void performAction(SystemAction systemAction) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractJsfTopComponent.this.designer.finishInlineEditing(false);
                    AbstractJsfTopComponent.this.deleteSelection();
                }
            });
        }
    }

    private static class Paste
    extends PasteType {
        private Paste() {
        }

        public Transferable paste() throws IOException {
            Clipboard clipboard = AbstractJsfTopComponent.getClipboard();
            final Transferable transferable = clipboard.getContents((Object)this);
            if (transferable != null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            Paste.this.pasteSynchronous(transferable);
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify(invocationTargetException.getCause());
                    ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                }
                catch (InterruptedException interruptedException) {
                    ErrorManager.getDefault().notify((Throwable)interruptedException);
                }
            }
            return transferable;
        }

        private void pasteSynchronous(Transferable transferable) {
            JComponent jComponent;
            TransferHandler transferHandler;
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                jTextComponent.paste();
            } else if (component instanceof JComponent && (transferHandler = (jComponent = (JComponent)component).getTransferHandler()) != null) {
                transferHandler.importData(jComponent, transferable);
            }
        }
    }

    private static class OwnPaste
    extends AbstractAction {
        private PasteType[] pasteTypes;

        private OwnPaste() {
        }

        public boolean isEnabled() {
            return super.isEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPasteTypes(PasteType[] pasteTypeArray) {
            OwnPaste ownPaste = this;
            synchronized (ownPaste) {
                this.pasteTypes = pasteTypeArray;
            }
            this.setEnabled(pasteTypeArray != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            throw new IllegalStateException("Should not be invoked at all. Paste types: " + Arrays.asList(this.pasteTypes));
        }

        public Object getValue(String string) {
            if ("delegates".equals(string)) {
                return this.pasteTypes;
            }
            return super.getValue(string);
        }
    }
}

