/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.text;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.designer.jsf.text.DomDocumentImpl;
import org.netbeans.modules.visualweb.designer.jsf.text.DomPositionImpl;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

class DomRangeImpl
implements DomProvider.DomRange {
    private final DomDocumentImpl domDocumentImpl;
    private Range domRange;
    private boolean dotIsFirst;
    private DomProvider.DomPosition cachedDot = DomProvider.DomPosition.NONE;
    private DomProvider.DomPosition cachedMark = DomProvider.DomPosition.NONE;
    private DomProvider.DomPosition.Bias dotBias = DomProvider.DomPosition.Bias.FORWARD;
    private DomProvider.DomPosition.Bias markBias = DomProvider.DomPosition.Bias.FORWARD;

    public static DomProvider.DomRange create(DomDocumentImpl domDocumentImpl, Node node, int n, Node node2, int n2) {
        if (node.getOwnerDocument() == domDocumentImpl.getJsfForm().getJspDom()) {
            return new DomRangeImpl(domDocumentImpl, node, n, node2, n2);
        }
        Logger logger = Logger.getLogger(DomRangeImpl.class.getName());
        logger.log(Level.INFO, null, new IllegalStateException("Can not create dom range for provided node in source DOM, dotNode=" + node + ", dotNode owner=" + node.getOwnerDocument() + ", jsp dom=" + domDocumentImpl.getJsfForm().getJspDom()));
        return DomProvider.DomRange.NONE;
    }

    private DomRangeImpl(DomDocumentImpl domDocumentImpl, Node node, int n, Node node2, int n2) {
        this.domDocumentImpl = domDocumentImpl;
        DocumentRange documentRange = (DocumentRange)((Object)domDocumentImpl.getJsfForm().getJspDom());
        this.domRange = documentRange.createRange();
        this.domRange.setStart(node2, n2);
        this.domRange.setEnd(node, n);
        this.dotIsFirst = false;
        this.ensureMarkIsFirst();
    }

    public void detach() {
        if (this.domRange != null) {
            this.domRange.detach();
            this.domRange = null;
        }
    }

    public void setRange(Node node, int n, Node node2, int n2) {
        if (node == node2) {
            this.domRange.setEnd(node2, n2);
            this.domRange.setStart(node, n);
        } else {
            this.domRange.detach();
            DocumentRange documentRange = (DocumentRange)((Object)this.domDocumentImpl.getJsfForm().getJspDom());
            this.domRange = documentRange.createRange();
            this.domRange.setStart(node2, n2);
            this.domRange.setEnd(node, n);
            this.dotIsFirst = false;
        }
        this.ensureMarkIsFirst();
        if (this.dotIsFirst) {
            this.dotBias = DomProvider.DomPosition.Bias.FORWARD;
            this.markBias = DomProvider.DomPosition.Bias.BACKWARD;
        } else {
            this.markBias = DomProvider.DomPosition.Bias.FORWARD;
            this.dotBias = DomProvider.DomPosition.Bias.BACKWARD;
        }
    }

    public void setDot(Node node, int n, DomProvider.DomPosition.Bias bias) {
        int n2;
        Node node2;
        if (this.dotIsFirst) {
            node2 = this.domRange.getEndContainer();
            n2 = this.domRange.getEndOffset();
        } else {
            node2 = this.domRange.getStartContainer();
            n2 = this.domRange.getStartOffset();
        }
        short s = DomPositionImpl.compareBoundaryPoints(node2, n2, node, n);
        boolean bl = this.dotIsFirst;
        boolean bl2 = this.dotIsFirst = s < 0;
        if (this.dotIsFirst) {
            this.domRange.setStart(node, n);
            if (bl != this.dotIsFirst) {
                this.domRange.setEnd(node2, n2);
            }
        } else {
            this.domRange.setEnd(node, n);
            if (bl != this.dotIsFirst) {
                this.domRange.setStart(node2, n2);
            }
        }
        this.dotBias = bias;
        this.ensureMarkIsFirst();
    }

    public void setMark(Node node, int n, DomProvider.DomPosition.Bias bias) {
        int n2;
        Node node2;
        if (this.dotIsFirst) {
            node2 = this.domRange.getStartContainer();
            n2 = this.domRange.getStartOffset();
        } else {
            node2 = this.domRange.getEndContainer();
            n2 = this.domRange.getEndOffset();
        }
        short s = DomPositionImpl.compareBoundaryPoints(node, n, node2, n2);
        boolean bl = this.dotIsFirst;
        boolean bl2 = this.dotIsFirst = s < 0;
        if (this.dotIsFirst) {
            this.domRange.setEnd(node, n);
            if (bl != this.dotIsFirst) {
                this.domRange.setStart(node2, n2);
            }
        } else {
            this.domRange.setStart(node, n);
            if (bl != this.dotIsFirst) {
                this.domRange.setEnd(node2, n2);
            }
        }
        this.markBias = bias;
        this.ensureMarkIsFirst();
    }

    private void ensureMarkIsFirst() {
        short s = DomPositionImpl.compareBoundaryPoints(this.domRange.getStartContainer(), this.domRange.getStartOffset(), this.domRange.getEndContainer(), this.domRange.getEndOffset());
        if (s < 0) {
            Node node = this.domRange.getStartContainer();
            int n = this.domRange.getStartOffset();
            this.domRange.setStart(this.domRange.getEndContainer(), this.domRange.getEndOffset());
            this.domRange.setEnd(node, n);
            this.dotIsFirst = !this.dotIsFirst;
        }
    }

    public boolean isDot(DomProvider.DomPosition domPosition) {
        if (this.dotIsFirst) {
            return domPosition.getNode() == this.domRange.getStartContainer() && domPosition.getOffset() == this.domRange.getStartOffset();
        }
        return domPosition.getNode() == this.domRange.getEndContainer() && domPosition.getOffset() == this.domRange.getEndOffset();
    }

    public boolean isEmpty() {
        return this.domRange.getStartContainer() == this.domRange.getEndContainer() && this.domRange.getStartOffset() == this.domRange.getEndOffset();
    }

    public String toString() {
        return "Range(dot=" + this.getDot() + ";" + this.getMark() + ")";
    }

    public DomProvider.DomPosition getDot() {
        boolean bl = true;
        this.cachedDot = this.dotIsFirst ? this.domDocumentImpl.createDomPosition(this.domRange.getStartContainer(), this.domRange.getStartOffset(), bl ? this.dotBias : DomProvider.DomPosition.Bias.FORWARD) : this.domDocumentImpl.createDomPosition(this.domRange.getEndContainer(), this.domRange.getEndOffset(), bl ? this.dotBias : DomProvider.DomPosition.Bias.FORWARD);
        return this.cachedDot;
    }

    public DomProvider.DomPosition getFirstPosition() {
        if (this.dotIsFirst) {
            return this.getDot();
        }
        return this.getMark();
    }

    public DomProvider.DomPosition getLastPosition() {
        if (this.dotIsFirst) {
            return this.getMark();
        }
        return this.getDot();
    }

    public DomProvider.DomPosition getMark() {
        boolean bl = true;
        this.cachedMark = this.dotIsFirst ? this.domDocumentImpl.createDomPosition(this.domRange.getEndContainer(), this.domRange.getEndOffset(), bl ? this.markBias : DomProvider.DomPosition.Bias.FORWARD) : this.domDocumentImpl.createDomPosition(this.domRange.getStartContainer(), this.domRange.getStartOffset(), bl ? this.markBias : DomProvider.DomPosition.Bias.FORWARD);
        return this.cachedMark;
    }

    public boolean deleteRangeContents() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.domRange != null) {
            Node node = this.domRange.getStartContainer();
            int n = this.domRange.getStartOffset();
            Node node2 = this.domRange.getEndContainer();
            int n2 = this.domRange.getEndOffset();
            this.domRange.deleteContents();
            this.domRange.setStart(node, n);
            this.domRange.setEnd(node, n);
            return true;
        }
        return false;
    }

    public boolean isReadOnlyRegion() {
        return this.domRange == null;
    }
}

