/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Util {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-\\S+)?");
    public static final Logger LOGGER = Logger.getLogger(Util.class.getName());

    public static void finest(String message) {
        LOGGER.finest(message);
    }

    public static void finer(String message) {
        LOGGER.finer(message);
    }

    public static void fine(String message) {
        LOGGER.fine(message);
    }

    public static void info(String message) {
        LOGGER.info(message);
    }

    public static void warning(String message) {
        LOGGER.warning(message);
    }

    public static void severe(String failure) {
        LOGGER.log(Level.SEVERE, failure);
    }

    public static void severe(Throwable t) {
        LOGGER.log(Level.SEVERE, t.getMessage(), t);
    }

    public static void severe(String message, Throwable t) {
        LOGGER.log(Level.SEVERE, message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    Util.severe("Cannot close socket.", e);
                }
            }
        }
        return -1;
    }

    public static boolean isRunning(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException ex) {
            return true;
        }
    }

    public static int compareVersions(String version1, String version2) {
        if (version1.equals(version2)) {
            return 0;
        }
        Matcher matcher1 = VERSION_PATTERN.matcher(version1);
        if (matcher1.matches()) {
            int major1 = Integer.parseInt(matcher1.group(1));
            int minor1 = Integer.parseInt(matcher1.group(2));
            int micro1 = Integer.parseInt(matcher1.group(3));
            Matcher matcher2 = VERSION_PATTERN.matcher(version2);
            if (matcher2.matches()) {
                int major2 = Integer.parseInt(matcher2.group(1));
                int minor2 = Integer.parseInt(matcher2.group(2));
                int micro2 = Integer.parseInt(matcher2.group(3));
                if (major1 != major2) {
                    return major1 - major2;
                }
                if (minor1 != minor2) {
                    return minor1 - minor2;
                }
                if (micro1 != micro2) {
                    return micro1 - micro2;
                }
            }
        }
        return version1.compareTo(version2);
    }
}

