/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;
import org.rubyforge.debugcommons.reader.BreakpointAddedReader;
import org.rubyforge.debugcommons.reader.BreakpointDeletedReader;
import org.rubyforge.debugcommons.reader.ConditionSetReader;
import org.rubyforge.debugcommons.reader.ErrorReader;
import org.rubyforge.debugcommons.reader.FramesReader;
import org.rubyforge.debugcommons.reader.SuspensionReader;
import org.rubyforge.debugcommons.reader.ThreadInfoReader;
import org.rubyforge.debugcommons.reader.VariablesReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReadersSupport {
    private static final String BREAKPOINT_ELEMENT = "breakpoint";
    private static final String SUSPENDED_ELEMENT = "suspended";
    private static final String EXCEPTION_ELEMENT = "exception";
    private static final String ERROR_ELEMENT = "error";
    private static final String MESSAGE_ELEMENT = "message";
    private static final String BREAKPOINT_ADDED_ELEMENT = "breakpointAdded";
    private static final String BREAKPOINT_DELETED_ELEMENT = "breakpointDeleted";
    private static final String CONDITION_SET_ELEMENT = "conditionSet";
    private static final String THREADS_ELEMENT = "threads";
    private static final String FRAMES_ELEMENT = "frames";
    private static final String VARIABLES_ELEMENT = "variables";
    private static final String PROCESSING_EXCEPTION_ELEMENT = "processingException";
    private static final String RUBY_DEBUG_PROMPT = "PROMPT";
    private static final String FINISHED = "finished";
    private final long timeout;
    private final BlockingQueue<RubyThreadInfo[]> threads;
    private final BlockingQueue<RubyFrameInfo[]> frames;
    private final BlockingQueue<RubyVariableInfo[]> variables;
    private final BlockingQueue<SuspensionPoint> suspensions;
    private final BlockingQueue<Integer> addedBreakpoints;
    private final BlockingQueue<Integer> removedBreakpoints;
    private final BlockingQueue<Integer> conditionSets;
    private boolean finished;
    private boolean unexpectedFail;

    ReadersSupport(long timeout) throws RubyDebuggerException {
        this.timeout = timeout;
        this.threads = new LinkedBlockingQueue<RubyThreadInfo[]>();
        this.frames = new LinkedBlockingQueue<RubyFrameInfo[]>();
        this.variables = new LinkedBlockingQueue<RubyVariableInfo[]>();
        this.suspensions = new LinkedBlockingQueue<SuspensionPoint>();
        this.addedBreakpoints = new LinkedBlockingQueue<Integer>();
        this.removedBreakpoints = new LinkedBlockingQueue<Integer>();
        this.conditionSets = new LinkedBlockingQueue<Integer>();
    }

    void startCommandLoop(InputStream is) throws RubyDebuggerException {
        try {
            new XPPLoop(is, ReadersSupport.class + " command loop").start();
        }
        catch (IOException e) {
            throw new RubyDebuggerException(e);
        }
        catch (XmlPullParserException e) {
            throw new RubyDebuggerException(e);
        }
    }

    private void startXPPLoop(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        do {
            if (eventType == 2) {
                this.processElement(xpp);
                continue;
            }
            if (eventType == 3) {
                assert (false) : "Unexpected state: end tag " + xpp.getName();
                continue;
            }
            if (eventType == 4) {
                if (xpp.getText().contains(RUBY_DEBUG_PROMPT)) {
                    Util.finest("got ruby-debug prompt message");
                    continue;
                }
                assert (false) : "Unexpected state: text " + xpp.getText();
                continue;
            }
            if (eventType != 0) assert (false) : "Unexpected state: " + eventType;
        } while (!this.finished && (eventType = xpp.next()) != 1);
    }

    private void processElement(XmlPullParser xpp) throws IOException, XmlPullParserException {
        String element = xpp.getName();
        if (BREAKPOINT_ADDED_ELEMENT.equals(element)) {
            this.addedBreakpoints.add(BreakpointAddedReader.readBreakpointNo(xpp));
        } else if (BREAKPOINT_DELETED_ELEMENT.equals(element)) {
            this.removedBreakpoints.add(BreakpointDeletedReader.readBreakpointNo(xpp));
        } else if (BREAKPOINT_ELEMENT.equals(element) || SUSPENDED_ELEMENT.equals(element) || EXCEPTION_ELEMENT.equals(element)) {
            SuspensionPoint sp = SuspensionReader.readSuspension(xpp);
            this.suspensions.add(sp);
        } else if (CONDITION_SET_ELEMENT.equals(element)) {
            this.conditionSets.add(ConditionSetReader.readBreakpointNo(xpp));
        } else if (ERROR_ELEMENT.equals(element)) {
            Util.warning(ErrorReader.readMessage(xpp));
        } else if (MESSAGE_ELEMENT.equals(element)) {
            String text = ErrorReader.readMessage(xpp);
            Util.info(text);
            if (text.equals(FINISHED)) {
                Util.fine("Got <message>, text == finished");
                this.finished = true;
            }
        } else if (THREADS_ELEMENT.equals(element)) {
            this.threads.add(ThreadInfoReader.readThreads(xpp));
        } else if (FRAMES_ELEMENT.equals(element)) {
            this.frames.add(FramesReader.readFrames(xpp));
        } else if (VARIABLES_ELEMENT.equals(element)) {
            this.variables.add(VariablesReader.readVariables(xpp));
        } else if (PROCESSING_EXCEPTION_ELEMENT.equals(element)) {
            VariablesReader.logProcessingException(xpp);
            this.variables.add(new RubyVariableInfo[0]);
        } else assert (false) : "Unexpected element: " + element;
    }

    private <T> T[] readInfo(BlockingQueue<T[]> queue) throws RubyDebuggerException {
        try {
            T[] result = queue.poll(this.timeout, TimeUnit.SECONDS);
            if (result == null) {
                throw new RubyDebuggerException("Unable to read information in the specified timeout [" + this.timeout + "s]");
            }
            return result;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RubyDebuggerException("Interruped during reading information " + queue.getClass(), ex);
        }
    }

    RubyThreadInfo[] readThreads() throws RubyDebuggerException {
        return (RubyThreadInfo[])this.readInfo(this.threads);
    }

    RubyFrameInfo[] readFrames() throws RubyDebuggerException {
        return (RubyFrameInfo[])this.readInfo(this.frames);
    }

    RubyVariableInfo[] readVariables() throws RubyDebuggerException {
        return (RubyVariableInfo[])this.readInfo(this.variables);
    }

    int readAddedBreakpointNo() throws RubyDebuggerException {
        return this.pollInteger(this.addedBreakpoints, "added breakpoint number");
    }

    int readConditionSet() throws RubyDebuggerException {
        return this.pollInteger(this.conditionSets, "breakpoint number of the set condition");
    }

    int waitForRemovedBreakpoint(int breakpointID) throws RubyDebuggerException {
        int removedID = this.pollInteger(this.removedBreakpoints, "breakpoint number of the removed breakpoint (" + breakpointID + ")");
        if (removedID != breakpointID) {
            throw new RubyDebuggerException("Unexpected breakpoint removed. Received id: " + removedID + ", expected: " + breakpointID);
        }
        return removedID;
    }

    private int pollInteger(BlockingQueue<Integer> queue, String toRead) throws RubyDebuggerException {
        try {
            Integer num = queue.poll(this.timeout, TimeUnit.SECONDS);
            if (num == null) {
                throw new RubyDebuggerException("Unable to read " + toRead + " in the specified timeout [" + this.timeout + "s]");
            }
            return num;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RubyDebuggerException("Interruped during reading " + toRead, ex);
        }
    }

    SuspensionPoint readSuspension() {
        try {
            return this.suspensions.take();
        }
        catch (InterruptedException ex) {
            Util.severe("Interruped during reading suspension point", ex);
            return null;
        }
    }

    boolean isUnexpectedFail() {
        return this.unexpectedFail;
    }

    private static XmlPullParser getXpp(InputStream is) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)"org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer", null);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput((Reader)new BufferedReader(new InputStreamReader(is)));
        return xpp;
    }

    private class XPPLoop
    extends Thread {
        private final XmlPullParser xpp;
        private final InputStream is;

        XPPLoop(InputStream is, String loopName) throws XmlPullParserException, IOException {
            super(loopName);
            this.is = is;
            this.xpp = ReadersSupport.getXpp(is);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Util.fine("Starting ReadersSupport readloop: " + this.getName());
                ReadersSupport.this.startXPPLoop(this.xpp);
                Util.fine("ReadersSupport readloop [" + this.getName() + "] successfully finished.");
            }
            catch (IOException e) {
                Util.fine("SocketException. Loop [" + this.getName() + "]: " + e.getMessage());
                ReadersSupport.this.unexpectedFail = true;
            }
            catch (XmlPullParserException e) {
                Util.severe("Exception during ReadersSupport loop [" + this.getName() + ']', e);
                ReadersSupport.this.unexpectedFail = true;
            }
            finally {
                ReadersSupport.this.suspensions.add(SuspensionPoint.END);
                try {
                    this.is.close();
                    Thread.sleep(1000L);
                }
                catch (IOException e) {
                    Util.severe("Cannot close socket's input stream", e);
                }
                catch (InterruptedException e) {
                    Util.severe("Readers loop interrupted", e);
                }
            }
        }
    }
}

