/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.bpel.project.ui.catalog.ResourcesNode;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

class IcanproViews {
    private static Logger logger = Logger.getLogger(IcanproViews.class.getName());
    private static final DataFilter NO_FOLDERS_FILTER = new NoFoldersDataFilter();

    private IcanproViews() {
    }

    static final class NoFoldersDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public NoFoldersDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = this.ell.getListenerList();
            ChangeEvent changeEvent2 = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent2 == null) {
                    changeEvent2 = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.ell.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.ell.remove(ChangeListener.class, changeListener);
        }
    }

    private static final class DocBaseNode
    extends FilterNode {
        private static Image CONFIGURATION_FILES_BADGE = Utilities.loadImage((String)"org/netbeans/modules/bpel/project/ui/resources/docjar.gif", (boolean)true);

        DocBaseNode(Node node) {
            super(node);
        }

        public Image getIcon(int n) {
            return this.computeIcon(false, n);
        }

        public Image getOpenedIcon(int n) {
            return this.computeIcon(true, n);
        }

        private Image computeIcon(boolean bl, int n) {
            Node node = this.getOriginal();
            Image image = bl ? node.getOpenedIcon(n) : node.getIcon(n);
            return Utilities.mergeImages((Image)image, (Image)CONFIGURATION_FILES_BADGE, (int)7, (int)7);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(IcanproViews.class, (String)"LBL_Node_DocBase");
        }
    }

    private static final class RootNode
    extends FilterNode {
        public RootNode(Node node, DataFolder dataFolder) {
            super(node, dataFolder.createNodeChildren(NO_FOLDERS_FILTER));
            this.disableDelegation(172);
            this.setDisplayName(NbBundle.getMessage(RootNode.class, (String)"LBL_ProcessFiles"));
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class)};
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }
    }

    static final class LogicalViewChildren
    extends Children.Keys
    implements FileChangeListener {
        private static final String KEY_SOURCE_DIR = "srcDir";
        private static final String KEY_RESOURCE_DIR = "resourceDir";
        private AntProjectHelper helper;
        private final PropertyEvaluator evaluator;
        private FileObject projectDir;
        private Project project;

        public LogicalViewChildren(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, Project project) {
            assert (antProjectHelper != null);
            this.helper = antProjectHelper;
            this.projectDir = antProjectHelper.getProjectDirectory();
            this.evaluator = propertyEvaluator;
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.projectDir.addFileChangeListener((FileChangeListener)this);
            this.createNodes();
        }

        private void createNodes() {
            ArrayList<String> arrayList = new ArrayList<String>();
            DataFolder dataFolder = this.getFolder("src.dir");
            if (dataFolder != null) {
                arrayList.add(KEY_SOURCE_DIR);
            }
            arrayList.add(KEY_RESOURCE_DIR);
            if (arrayList.size() > 0) {
                this.setKeys(arrayList);
            }
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.projectDir.removeFileChangeListener((FileChangeListener)this);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray;
            Object object2 = null;
            if (object == KEY_SOURCE_DIR) {
                FileObject fileObject = this.helper.resolveFileObject(this.evaluator.getProperty("src.dir"));
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                Sources sources = ProjectUtils.getSources((Project)project);
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("BIZPRO");
                for (int i = 0; i < sourceGroupArray.length; ++i) {
                    if (!sourceGroupArray[i].contains(fileObject)) continue;
                    try {
                        FileObject fileObject2 = sourceGroupArray[i].getRootFolder();
                        DataObject dataObject = DataObject.find((FileObject)fileObject2);
                        object2 = new RootNode(dataObject.getNodeDelegate(), (DataFolder)dataObject);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {}
                    break;
                }
            } else if (object == KEY_RESOURCE_DIR) {
                FileObject fileObject = this.helper.resolveFileObject(this.evaluator.getProperty("src.dir"));
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                object2 = new ResourcesNode(project);
            }
            if (object2 == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = object2;
            }
            return nodeArray;
        }

        private DataFolder getFolder(String string) {
            FileObject fileObject;
            String string2 = this.evaluator.getProperty(string);
            if (string2 != null && (fileObject = this.helper.resolveFileObject(this.evaluator.getProperty(string))) != null && fileObject.isValid()) {
                try {
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    return dataFolder;
                }
                catch (Exception exception) {
                    logger.fine(exception.getMessage());
                }
            }
            return null;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.createNodes();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.createNodes();
        }
    }
}

