/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class J2SEPlatformCustomizer
extends JTabbedPane {
    private static final int CLASSPATH = 0;
    private static final int SOURCES = 1;
    private static final int JAVADOC = 2;
    private J2SEPlatformImpl platform;

    public J2SEPlatformCustomizer(J2SEPlatformImpl j2SEPlatformImpl) {
        this.platform = j2SEPlatformImpl;
        this.initComponents();
    }

    private void initComponents() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AN_J2SEPlatformCustomizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_J2SEPlatformCustomizer"));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Classes"), this.createPathTab(0));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Sources"), this.createPathTab(1));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Javadoc"), this.createPathTab(2));
    }

    private JComponent createPathTab(int n) {
        return new PathView(this.platform, n);
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            return this.extensions.contains(string2);
        }

        public String getDescription() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathModel
    extends AbstractListModel {
        private J2SEPlatformImpl platform;
        private int type;
        private List<URL> data;

        public PathModel(J2SEPlatformImpl j2SEPlatformImpl, int n) {
            this.platform = j2SEPlatformImpl;
            this.type = n;
        }

        @Override
        public int getSize() {
            return this.getData().size();
        }

        @Override
        public Object getElementAt(int n) {
            Serializable serializable;
            List<URL> list = this.getData();
            URL uRL = list.get(n);
            if ("jar".equals(uRL.getProtocol())) {
                serializable = FileUtil.getArchiveFile((URL)uRL);
                if (FileUtil.getArchiveRoot((URL)serializable).equals(uRL)) {
                    uRL = serializable;
                } else {
                    return uRL.toExternalForm();
                }
            }
            if ("file".equals(uRL.getProtocol())) {
                serializable = new File(URI.create(uRL.toExternalForm()));
                return ((File)serializable).getAbsolutePath();
            }
            return uRL.toExternalForm();
        }

        private void removePath(int[] nArray) {
            List<URL> list = this.getData();
            for (int i = nArray.length - 1; i >= 0; --i) {
                list.remove(nArray[i]);
            }
            this.updatePlatform();
            this.fireIntervalRemoved(this, nArray[0], nArray[nArray.length - 1]);
        }

        private void moveUpPath(int[] nArray) {
            List<URL> list = this.getData();
            for (int i = 0; i < nArray.length; ++i) {
                URL uRL = list.get(nArray[i]);
                URL uRL2 = list.set(nArray[i] - 1, uRL);
                list.set(nArray[i], uRL2);
            }
            this.updatePlatform();
            this.fireContentsChanged(this, nArray[0] - 1, nArray[nArray.length - 1]);
        }

        private void moveDownPath(int[] nArray) {
            List<URL> list = this.getData();
            for (int i = nArray.length - 1; i >= 0; --i) {
                URL uRL = list.get(nArray[i]);
                URL uRL2 = list.set(nArray[i] + 1, uRL);
                list.set(nArray[i], uRL2);
            }
            this.updatePlatform();
            this.fireContentsChanged(this, nArray[0], nArray[nArray.length - 1] + 1);
        }

        private boolean addPath(File file) {
            try {
                URL uRL = file.toURI().toURL();
                return this.addPath(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }

        private boolean addPath(URL uRL) {
            if (FileUtil.isArchiveFile((URL)uRL)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            } else if (!uRL.toExternalForm().endsWith("/")) {
                try {
                    uRL = new URL(uRL.toExternalForm() + "/");
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify((Throwable)malformedURLException);
                }
            }
            List<URL> list = this.getData();
            int n = list.size();
            list.add(uRL);
            this.updatePlatform();
            this.fireIntervalAdded(this, n, n);
            return true;
        }

        private synchronized List<URL> getData() {
            if (this.data == null) {
                switch (this.type) {
                    case 0: {
                        this.data = PathModel.getPathList(this.platform.getBootstrapLibraries());
                        break;
                    }
                    case 1: {
                        this.data = PathModel.getPathList(this.platform.getSourceFolders());
                        break;
                    }
                    case 2: {
                        this.data = new ArrayList<URL>(this.platform.getJavadocFolders());
                    }
                }
            }
            return this.data;
        }

        private static List<URL> getPathList(ClassPath classPath) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (ClassPath.Entry entry : classPath.entries()) {
                arrayList.add(entry.getURL());
            }
            return arrayList;
        }

        private static ClassPath createClassPath(List<URL> list) {
            ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
            for (URL uRL : list) {
                arrayList.add(ClassPathSupport.createResource((URL)uRL));
            }
            return ClassPathSupport.createClassPath(arrayList);
        }

        private void updatePlatform() {
            switch (this.type) {
                case 1: {
                    this.platform.setSourceFolders(PathModel.createClassPath(this.data));
                    break;
                }
                case 2: {
                    this.platform.setJavadocFolders(this.data);
                    break;
                }
                default: {
                    assert (false) : "Trying to update unknown property";
                    break;
                }
            }
        }
    }

    private static class PathView
    extends JPanel {
        private JList resources;
        private JButton addButton;
        private JButton removeButton;
        private JButton moveUpButton;
        private JButton moveDownButton;
        private int type;
        private File currentDir;

        public PathView(J2SEPlatformImpl j2SEPlatformImpl, int n) {
            this.type = n;
            this.initComponents(j2SEPlatformImpl);
        }

        private void initComponents(J2SEPlatformImpl j2SEPlatformImpl) {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            String string = null;
            String string2 = null;
            String string3 = null;
            switch (this.type) {
                case 0: {
                    string = "TXT_JDKClasspath";
                    string2 = "MNE_JDKClasspath";
                    string3 = "AD_JDKClasspath";
                    break;
                }
                case 1: {
                    string = "TXT_JDKSources";
                    string2 = "MNE_JDKSources";
                    string3 = "AD_JDKSources";
                    break;
                }
                case 2: {
                    string = "TXT_JDKJavadoc";
                    string2 = "MNE_JDKJavadoc";
                    string3 = "AD_JDKJavadoc";
                    break;
                }
                default: {
                    assert (false) : "Illegal type of panel";
                    return;
                }
            }
            jLabel.setText(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)string));
            jLabel.setDisplayedMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)string2).charAt(0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(6, 6, 2, 6);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.resources = new JList(new PathModel(j2SEPlatformImpl, this.type));
            jLabel.setLabelFor(this.resources);
            this.resources.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)string3));
            this.resources.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    PathView.this.selectionChanged();
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.resources);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 5;
            gridBagConstraints.insets = new Insets(0, 6, 6, 6);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            if (this.type == 1 || this.type == 2) {
                char c;
                String string4;
                this.addButton = new JButton();
                if (this.type == 1) {
                    string4 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Add");
                    c = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Add").charAt(0);
                    string3 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Add");
                } else {
                    string4 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddZip");
                    c = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_AddZip").charAt(0);
                    string3 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_AddZip");
                }
                this.addButton.setText(string4);
                this.addButton.setMnemonic(c);
                this.addButton.getAccessibleContext().setAccessibleDescription(string3);
                this.addButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PathView.this.addPathElement();
                    }
                });
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(0, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.addButton, gridBagConstraints);
                this.add(this.addButton);
                this.removeButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Remove"));
                this.removeButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Remove").charAt(0));
                this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Remove"));
                this.removeButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PathView.this.removePathElement();
                    }
                });
                this.removeButton.setEnabled(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.removeButton, gridBagConstraints);
                this.add(this.removeButton);
                this.moveUpButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Up"));
                this.moveUpButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Up").charAt(0));
                this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Up"));
                this.moveUpButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PathView.this.moveUpPathElement();
                    }
                });
                this.moveUpButton.setEnabled(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveUpButton, gridBagConstraints);
                this.add(this.moveUpButton);
                this.moveDownButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Down"));
                this.moveDownButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Down").charAt(0));
                this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Down"));
                this.moveDownButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PathView.this.moveDownPathElement();
                    }
                });
                this.moveDownButton.setEnabled(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(5, 6, 6, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveDownButton, gridBagConstraints);
                this.add(this.moveDownButton);
            }
        }

        private void addPathElement() {
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setMultiSelectionEnabled(true);
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (this.type == 1) {
                string = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenSources");
                string2 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Sources");
                string3 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenSources");
                string4 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_OpenSources");
            } else if (this.type == 2) {
                string = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenJavadoc");
                string2 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Javadoc");
                string3 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenJavadoc");
                string4 = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_OpenJavadoc");
            }
            jFileChooser.setDialogTitle(string);
            jFileChooser.setApproveButtonText(string3);
            jFileChooser.setApproveButtonMnemonic(string4.charAt(0));
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new SimpleFileFilter(string2, new String[]{"ZIP", "JAR"}));
            if (this.currentDir != null) {
                jFileChooser.setCurrentDirectory(this.currentDir);
            }
            if (jFileChooser.showOpenDialog(this) == 0) {
                Object object;
                int n;
                File[] fileArray = jFileChooser.getSelectedFiles();
                PathModel pathModel = (PathModel)this.resources.getModel();
                boolean bl = false;
                int n2 = this.resources.getModel().getSize();
                for (n = 0; n < fileArray.length; ++n) {
                    File file;
                    object = fileArray[n];
                    if (!((File)object).exists() && (file = ((File)object).getParentFile()) != null && ((File)object).getName().equals(file.getName()) && file.exists()) {
                        object = file;
                    }
                    bl |= !pathModel.addPath((File)object);
                }
                if (bl) {
                    new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_CanNotAddResolve"), 0);
                }
                if (n2 <= (n = this.resources.getModel().getSize() - 1)) {
                    object = new int[n - n2 + 1];
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        object[i] = n2 + i;
                    }
                    this.resources.setSelectedIndices((int[])object);
                }
                this.currentDir = FileUtil.normalizeFile((File)jFileChooser.getCurrentDirectory());
            }
        }

        private void removePathElement() {
            int[] nArray = this.resources.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            PathModel pathModel = (PathModel)this.resources.getModel();
            pathModel.removePath(nArray);
            if (nArray[nArray.length - 1] - nArray.length + 1 < this.resources.getModel().getSize()) {
                this.resources.setSelectedIndex(nArray[nArray.length - 1] - nArray.length + 1);
            } else if (nArray[0] > 0) {
                this.resources.setSelectedIndex(nArray[0] - 1);
            }
        }

        private void moveDownPathElement() {
            int[] nArray = this.resources.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            PathModel pathModel = (PathModel)this.resources.getModel();
            pathModel.moveDownPath(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = nArray[i] + 1;
            }
            this.resources.setSelectedIndices(nArray);
        }

        private void moveUpPathElement() {
            int[] nArray = this.resources.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            PathModel pathModel = (PathModel)this.resources.getModel();
            pathModel.moveUpPath(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = nArray[i] - 1;
            }
            this.resources.setSelectedIndices(nArray);
        }

        private void selectionChanged() {
            if (this.type == 0) {
                return;
            }
            int[] nArray = this.resources.getSelectedIndices();
            this.removeButton.setEnabled(nArray.length > 0);
            this.moveUpButton.setEnabled(nArray.length > 0 && nArray[0] > 0);
            this.moveDownButton.setEnabled(nArray.length > 0 && nArray[nArray.length - 1] < this.resources.getModel().getSize() - 1);
        }
    }
}

