/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.modules.editor.lib.BeforeSaveTasks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrailingWhitespaceRemove
implements BeforeSaveTasks.Task,
DocumentListener {
    static final Logger LOG = Logger.getLogger(TrailingWhitespaceRemove.class.getName());
    static final int GET_ELEMENT_INDEX_THRESHOLD = 100;
    Document doc;
    CharSequence docText;
    GapList<MutablePositionRegion> modRegions;
    private int lastRegionIndex;
    private boolean inWhitespaceRemove;

    public static synchronized TrailingWhitespaceRemove install(BaseDocument baseDocument) {
        TrailingWhitespaceRemove trailingWhitespaceRemove = (TrailingWhitespaceRemove)baseDocument.getProperty(TrailingWhitespaceRemove.class);
        if (trailingWhitespaceRemove == null) {
            trailingWhitespaceRemove = new TrailingWhitespaceRemove(baseDocument);
            BeforeSaveTasks beforeSaveTasks = BeforeSaveTasks.get(baseDocument);
            beforeSaveTasks.addTask(trailingWhitespaceRemove);
            baseDocument.putProperty(TrailingWhitespaceRemove.class, trailingWhitespaceRemove);
        }
        return trailingWhitespaceRemove;
    }

    private TrailingWhitespaceRemove(BaseDocument baseDocument) {
        this.doc = baseDocument;
        this.docText = DocumentUtilities.getText((Document)baseDocument);
        this.modRegions = this.emptyModRegions();
        baseDocument.addUpdateDocumentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run(CompoundEdit compoundEdit) {
        this.inWhitespaceRemove = true;
        try {
            new ModsProcessor().removeWhitespace();
            NewModRegionsEdit newModRegionsEdit = new NewModRegionsEdit();
            compoundEdit.addEdit(newModRegionsEdit);
            newModRegionsEdit.run();
        }
        finally {
            this.inWhitespaceRemove = false;
        }
    }

    public void resetModRegions() {
        this.modRegions = this.emptyModRegions();
    }

    GapList<MutablePositionRegion> emptyModRegions() {
        return new GapList(3);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        CompoundEdit compoundEdit = (CompoundEdit)((Object)documentEvent);
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getLength();
        boolean bl = false;
        if (this.lastRegionIndex >= 0 && this.lastRegionIndex < this.modRegions.size()) {
            bl = this.isCovered(n, n2);
        }
        if (!bl) {
            this.lastRegionIndex = this.findRegionIndex(n, false);
            if (this.lastRegionIndex >= 0) {
                bl = this.isCovered(n, n2);
            }
        }
        if (!bl) {
            this.addRegion(compoundEdit, n, n + n2);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.inWhitespaceRemove) {
            DocumentUtilities.putEventProperty((DocumentEvent)documentEvent, (Object)"caretIgnore", (Object)Boolean.TRUE);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private boolean isCovered(int n, int n2) {
        PositionRegion positionRegion = (PositionRegion)this.modRegions.get(this.lastRegionIndex);
        return positionRegion.getStartOffset() <= n && n + n2 <= positionRegion.getEndOffset();
    }

    private MutablePositionRegion addRegion(CompoundEdit compoundEdit, int n, int n2) {
        try {
            MutablePositionRegion mutablePositionRegion = new MutablePositionRegion(this.doc, n, n2);
            this.lastRegionIndex = this.findRegionIndex(n, true);
            AddRegionEdit addRegionEdit = new AddRegionEdit(this.lastRegionIndex, mutablePositionRegion);
            addRegionEdit.run();
            compoundEdit.addEdit(addRegionEdit);
            return mutablePositionRegion;
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    void addRegion(int n, MutablePositionRegion mutablePositionRegion) {
        this.modRegions.add(n, (Object)mutablePositionRegion);
    }

    private int findRegionIndex(int n, boolean bl) {
        int n2 = 0;
        int n3 = this.modRegions.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = ((MutablePositionRegion)this.modRegions.get(n4)).getStartOffset();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            while (++n4 < this.modRegions.size() && ((MutablePositionRegion)this.modRegions.get(n4)).getStartOffset() == n) {
            }
            --n4;
            if (bl) {
                n2 = n4 + 1;
                break;
            }
            n3 = n4;
            break;
        }
        return bl ? n2 : n3;
    }

    public void checkConsistency() {
        int n = 0;
        for (int i = 0; i < this.modRegions.size(); ++i) {
            PositionRegion positionRegion = (PositionRegion)this.modRegions.get(i);
            int n2 = positionRegion.getStartOffset();
            if (n2 < n) {
                throw new IllegalStateException("region[" + i + "].getStartOffset()=" + n2 + " < lastOffset=" + n);
            }
            n = n2;
            n2 = positionRegion.getEndOffset();
            if (n2 < n) {
                throw new IllegalStateException("region[" + i + "].getEndOffset()=" + n2 + " < region.getStartOffset()=" + n);
            }
            n = n2;
        }
    }

    public String toString() {
        int n = this.modRegions.size();
        int n2 = String.valueOf(n).length();
        StringBuilder stringBuilder = new StringBuilder(100);
        for (int i = 0; i < n; ++i) {
            PositionRegion positionRegion = (PositionRegion)this.modRegions.get(i);
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)i, (int)n2);
            stringBuilder.append(positionRegion.toString(this.doc));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private final class NewModRegionsEdit
    extends AbstractUndoableEdit {
        private GapList<MutablePositionRegion> oldModRegions;
        private GapList<MutablePositionRegion> newModRegions;

        public NewModRegionsEdit() {
            this.oldModRegions = TrailingWhitespaceRemove.this.modRegions;
            this.newModRegions = TrailingWhitespaceRemove.this.emptyModRegions();
        }

        public void run() {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Abandoning old regions\n" + TrailingWhitespaceRemove.this.modRegions);
            }
            TrailingWhitespaceRemove.this.modRegions = this.newModRegions;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            TrailingWhitespaceRemove.this.modRegions = this.oldModRegions;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Restored old regions\n" + TrailingWhitespaceRemove.this.modRegions);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.run();
        }
    }

    private final class AddRegionEdit
    extends AbstractUndoableEdit {
        private int index;
        private MutablePositionRegion region;

        public AddRegionEdit(int n, MutablePositionRegion mutablePositionRegion) {
            this.index = n;
            this.region = mutablePositionRegion;
        }

        public void run() {
            TrailingWhitespaceRemove.this.addRegion(this.index, this.region);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Added region " + this.region + " at index=" + this.index + '\n');
                LOG.fine("Regions:\n" + TrailingWhitespaceRemove.this.modRegions + '\n');
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            TrailingWhitespaceRemove.this.modRegions.remove((Object)this.region);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Removed region " + this.region + " at index=" + this.index + '\n');
                LOG.fine("Regions:\n" + TrailingWhitespaceRemove.this.modRegions + '\n');
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.run();
        }
    }

    private final class ModsProcessor {
        private final Element lineElementRoot;
        private int regionIndex;
        private int regionStartOffset;
        private int regionEndOffset;
        private int lineIndex;
        private int lineStartOffset;
        private int lineLastOffset;
        private final int excludeLineIndex;

        ModsProcessor() {
            this.lineElementRoot = DocumentUtilities.getParagraphRootElement((Document)TrailingWhitespaceRemove.this.doc);
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            this.excludeLineIndex = jTextComponent != null && jTextComponent.getDocument() == TrailingWhitespaceRemove.this.doc ? this.lineElementRoot.getElementIndex(jTextComponent.getCaretPosition()) : -1;
        }

        void removeWhitespace() {
            this.regionIndex = TrailingWhitespaceRemove.this.modRegions.size();
            this.lineStartOffset = Integer.MAX_VALUE;
            while (this.fetchPreviousNonEmptyRegion()) {
                int n = this.regionEndOffset - 1;
                int n2 = this.lineIndex;
                if (n + 100 < this.lineStartOffset) {
                    this.lineIndex = this.lineElementRoot.getElementIndex(this.regionEndOffset - 1);
                    this.fetchLineElement();
                } else {
                    while (this.lineStartOffset > n) {
                        --this.lineIndex;
                        this.fetchLineElement();
                    }
                }
                if (n2 == this.lineIndex) continue;
                this.removeWhitespaceOnLine();
                while (this.regionStartOffset < this.lineStartOffset) {
                    --this.lineIndex;
                    this.fetchLineElement();
                    this.removeWhitespaceOnLine();
                }
            }
        }

        private boolean fetchPreviousNonEmptyRegion() {
            while (--this.regionIndex >= 0) {
                PositionRegion positionRegion = (PositionRegion)TrailingWhitespaceRemove.this.modRegions.get(this.regionIndex);
                this.regionStartOffset = positionRegion.getStartOffset();
                this.regionEndOffset = positionRegion.getEndOffset();
                if (this.regionStartOffset == this.regionEndOffset) continue;
                return true;
            }
            return false;
        }

        private void fetchLineElement() {
            Element element = this.lineElementRoot.getElement(this.lineIndex);
            this.lineStartOffset = element.getStartOffset();
            this.lineLastOffset = element.getEndOffset() - 1;
        }

        private void removeWhitespaceOnLine() {
            char c;
            int n;
            if (this.lineIndex == this.excludeLineIndex) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Line index " + this.lineIndex + " excluded from whitespace removal.\n");
                }
                return;
            }
            for (n = this.lineLastOffset - 1; n >= this.lineStartOffset && ((c = TrailingWhitespaceRemove.this.docText.charAt(n)) == ' ' || c == '\t'); --n) {
            }
            if (++n < this.lineLastOffset) {
                BadLocationException badLocationException = null;
                try {
                    TrailingWhitespaceRemove.this.doc.remove(n, this.lineLastOffset - n);
                }
                catch (BadLocationException badLocationException2) {
                    badLocationException = badLocationException2;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Remove between " + DocumentUtilities.debugOffset((Document)TrailingWhitespaceRemove.this.doc, (int)n) + " and " + DocumentUtilities.debugOffset((Document)TrailingWhitespaceRemove.this.doc, (int)this.lineLastOffset) + (badLocationException == null ? " succeeded." : " failed.") + '\n');
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.INFO, "Exception thrown during removal:", badLocationException);
                    }
                }
            }
        }
    }
}

