/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.options.indentation.IndentationModel;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class IndentationPanel
extends JPanel
implements ChangeListener,
ActionListener,
PreferenceChangeListener,
HierarchyListener {
    private static final Logger LOG = Logger.getLogger(IndentationPanel.class.getName());
    private IndentationModel model;
    private String originalText;
    private boolean listen = false;
    private boolean changed = false;
    private final Preferences prefs;
    private final JEditorPane epPreview;
    private JCheckBox cbExpandTabsToSpaces;
    private JLabel lExpandTabsToSpaces;
    private JLabel lNumberOfSpacesPerIndent;
    private JLabel lRightMargin;
    private JLabel lTabSize;
    private JSpinner sNumberOfSpacesPerIndent;
    private JSpinner sRightMargin;
    private JSpinner sTabSize;
    private static final String MIME_TYPE = "text/xml";

    public IndentationPanel(Preferences preferences, JEditorPane jEditorPane) {
        this.prefs = preferences;
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)preferences));
        this.epPreview = jEditorPane;
        this.initComponents();
        this.setName(IndentationPanel.loc("Indentation_Tab"));
        IndentationPanel.loc(this.lNumberOfSpacesPerIndent, "Indent");
        IndentationPanel.loc(this.lTabSize, "TabSize");
        IndentationPanel.loc(this.lExpandTabsToSpaces, "Expand_Tabs");
        IndentationPanel.loc(this.lRightMargin, "Right_Margin");
        this.cbExpandTabsToSpaces.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_Expand_Tabs"));
        this.cbExpandTabsToSpaces.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_Expand_Tabs"));
        this.epPreview.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_Preview"));
        this.epPreview.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_Preview"));
        this.epPreview.setBorder(new EtchedBorder());
        this.cbExpandTabsToSpaces.addActionListener(this);
        this.sNumberOfSpacesPerIndent.setModel(new SpinnerNumberModel(4, 1, 50, 1));
        this.sNumberOfSpacesPerIndent.addChangeListener(this);
        this.sTabSize.setModel(new SpinnerNumberModel(4, 1, 50, 1));
        this.sTabSize.addChangeListener(this);
        this.sRightMargin.setModel(new SpinnerNumberModel(120, 1, 200, 10));
        this.sRightMargin.addChangeListener(this);
        this.epPreview.setEnabled(false);
        this.epPreview.putClientProperty("HighlightsLayerIncludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.SyntaxHighlighting$");
        this.addHierarchyListener(this);
    }

    private void initComponents() {
        this.lNumberOfSpacesPerIndent = new JLabel();
        this.sNumberOfSpacesPerIndent = new JSpinner();
        this.cbExpandTabsToSpaces = new JCheckBox();
        this.lTabSize = new JLabel();
        this.sTabSize = new JSpinner();
        this.lExpandTabsToSpaces = new JLabel();
        this.lRightMargin = new JLabel();
        this.sRightMargin = new JSpinner();
        this.lNumberOfSpacesPerIndent.setLabelFor(this.sNumberOfSpacesPerIndent);
        this.lNumberOfSpacesPerIndent.setText("Number of Spaces per Indent:");
        this.cbExpandTabsToSpaces.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbExpandTabsToSpaces.setMargin(new Insets(0, 0, 0, 0));
        this.lTabSize.setLabelFor(this.sTabSize);
        this.lTabSize.setText("Tab Size:");
        this.lExpandTabsToSpaces.setLabelFor(this.cbExpandTabsToSpaces);
        this.lExpandTabsToSpaces.setText("Expand Tabs To Spaces:");
        this.lRightMargin.setLabelFor(this.sRightMargin);
        this.lRightMargin.setText("Right Margin:");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbExpandTabsToSpaces).addPreferredGap(0).add((Component)this.lExpandTabsToSpaces)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lRightMargin).add((Component)this.lTabSize).add((Component)this.lNumberOfSpacesPerIndent)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.sNumberOfSpacesPerIndent, -1, 42, Short.MAX_VALUE).add((Component)this.sTabSize, -1, 42, Short.MAX_VALUE).add((Component)this.sRightMargin, -1, 42, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.sNumberOfSpacesPerIndent, this.sRightMargin, this.sTabSize}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(14, 14, 14).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbExpandTabsToSpaces).add((Component)this.lExpandTabsToSpaces)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lNumberOfSpacesPerIndent).addPreferredGap(0).add((Component)this.lTabSize).add(6, 6, 6).add((Component)this.lRightMargin)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.sNumberOfSpacesPerIndent, -2, -1, -2).addPreferredGap(0).add((Component)this.sTabSize, -2, -1, -2).add(6, 6, 6).add((Component)this.sRightMargin, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.sNumberOfSpacesPerIndent, this.sRightMargin, this.sTabSize}, 2);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(IndentationPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)IndentationPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)IndentationPanel.loc("CTL_" + string));
        }
    }

    private void updateModel() {
        this.model.setExpandTabs(this.cbExpandTabsToSpaces.isSelected());
        this.model.setSpacesPerTab((Integer)this.sNumberOfSpacesPerIndent.getValue());
        this.model.setTabSize((Integer)this.sTabSize.getValue());
        this.model.setRightMargin((Integer)this.sRightMargin.getValue());
    }

    private void refreshPreview() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IndentationPanel.this.epPreview.setText(IndentationPanel.this.originalText);
                BaseDocument baseDocument = (BaseDocument)IndentationPanel.this.epPreview.getDocument();
                Reformat reformat = Reformat.get((Document)baseDocument);
                reformat.lock();
                try {
                    baseDocument.atomicLock();
                    try {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Refreshing preview: expandTabs=" + IndentUtils.isExpandTabs((Document)baseDocument) + ", indentLevelSize=" + IndentUtils.indentLevelSize((Document)baseDocument) + ", tabSize=" + IndentUtils.tabSize((Document)baseDocument) + ", mimeType='" + baseDocument.getProperty((Object)"mimeType") + "'" + ", doc=" + baseDocument);
                        }
                        reformat.reformat(0, baseDocument.getLength());
                    }
                    finally {
                        baseDocument.atomicUnlock();
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                finally {
                    reformat.unlock();
                }
            }
        });
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.listen) {
            return;
        }
        this.updateModel();
        if (this.changed != this.model.isChanged()) {
            this.firePropertyChange("changed", (Object)this.changed, (Object)this.model.isChanged());
        }
        this.changed = this.model.isChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        this.updateModel();
        if (this.changed != this.model.isChanged()) {
            this.firePropertyChange("changed", (Object)this.changed, (Object)this.model.isChanged());
        }
        this.changed = this.model.isChanged();
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey() == null || "expand-tabs".equals(preferenceChangeEvent.getKey()) || "indent-shift-width".equals(preferenceChangeEvent.getKey()) || "spaces-per-tab".equals(preferenceChangeEvent.getKey()) || "tab-size".equals(preferenceChangeEvent.getKey())) {
            this.refreshPreview();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        this.model = new IndentationModel(this.prefs);
        if (this.originalText == null) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/org/netbeans/modules/options/indentation/indentationExample");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        stringBuffer.append(string).append('\n');
                        string = bufferedReader.readLine();
                    }
                    this.originalText = new String(stringBuffer);
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.listen = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndentationPanel.this.epPreview.setEditorKit(CloneableEditorSupport.getEditorKit((String)IndentationPanel.MIME_TYPE));
                IndentationPanel.this.epPreview.setText(IndentationPanel.this.originalText);
                IndentationPanel.this.cbExpandTabsToSpaces.setSelected(IndentationPanel.this.model.isExpandTabs());
                IndentationPanel.this.sNumberOfSpacesPerIndent.setValue(IndentationPanel.this.model.getSpacesPerTab());
                IndentationPanel.this.sTabSize.setValue(IndentationPanel.this.model.getTabSize());
                IndentationPanel.this.sRightMargin.setValue(IndentationPanel.this.model.getRightMargin());
                IndentationPanel.this.listen = true;
                IndentationPanel.this.refreshPreview();
            }
        });
    }

    public void applyChanges() {
        if (this.model != null) {
            this.model.applyChanges();
        }
    }

    public void cancel() {
        if (this.model != null) {
            this.model.revertChanges();
        }
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (this.isShowing()) {
            this.refreshPreview();
        }
    }
}

