/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.generaleditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.generaleditor.Model;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GeneralEditorPanel
extends JPanel
implements ActionListener {
    private boolean changed = false;
    private boolean listen = false;
    private JCheckBox cbAutoPopup;
    private JCheckBox cbCamelCaseBehavior;
    private JCheckBox cbCaseSensitive;
    private JCheckBox cbDocsAutoPopup;
    private JCheckBox cbFoldImports;
    private JCheckBox cbFoldInitialComments;
    private JCheckBox cbFoldInnerClasses;
    private JCheckBox cbFoldJavadocComments;
    private JCheckBox cbFoldMethods;
    private JCheckBox cbGuessMethodArgs;
    private JCheckBox cbInsertClosingBracketsAutomatically;
    private JCheckBox cbInsertSingleProposalsAutomatically;
    private JCheckBox cbShowDeprecated;
    private JCheckBox cbUseCodeFolding;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lCamelCaseBehavior;
    private JLabel lCamelCaseBehaviorExample;
    private JLabel lCodeCompletion;
    private JLabel lCodeCompletion2;
    private JLabel lCodeFolding;
    private JLabel lCollapseByDefault;
    private JLabel lUseCodeFolding;
    private Model model;

    public GeneralEditorPanel() {
        this.initComponents();
        GeneralEditorPanel.loc(this.lCodeFolding, "Code_Folding");
        GeneralEditorPanel.loc(this.lUseCodeFolding, "Code_Folding_Section");
        GeneralEditorPanel.loc(this.lCollapseByDefault, "Fold_by_Default");
        GeneralEditorPanel.loc(this.lCodeCompletion, "Code_Completion");
        GeneralEditorPanel.loc(this.lCodeCompletion2, "Code_Completion_Section");
        GeneralEditorPanel.loc(this.cbUseCodeFolding, "Use_Folding");
        GeneralEditorPanel.loc(this.cbFoldMethods, "Fold_Methods");
        GeneralEditorPanel.loc(this.cbFoldInnerClasses, "Fold_Classes");
        GeneralEditorPanel.loc(this.cbFoldImports, "Fold_Imports");
        GeneralEditorPanel.loc(this.cbFoldJavadocComments, "Fold_JavaDoc");
        GeneralEditorPanel.loc(this.cbFoldInitialComments, "Fold_Licence");
        GeneralEditorPanel.loc(this.cbAutoPopup, "Auto_Popup_Completion_Window");
        GeneralEditorPanel.loc(this.cbDocsAutoPopup, "Auto_Popup_Documentation_Window");
        GeneralEditorPanel.loc(this.cbInsertSingleProposalsAutomatically, "Insert_Single_Proposals_Automatically");
        GeneralEditorPanel.loc(this.cbCaseSensitive, "Case_Sensitive_Code_Completion");
        GeneralEditorPanel.loc(this.cbShowDeprecated, "Show_Deprecated_Members");
        GeneralEditorPanel.loc(this.cbInsertClosingBracketsAutomatically, "Pair_Character_Completion");
        GeneralEditorPanel.loc(this.cbGuessMethodArgs, "Guess_Filled_Method_Arguments");
        GeneralEditorPanel.loc(this.lCamelCaseBehavior, "Camel_Case_Behavior");
        GeneralEditorPanel.loc(this.cbCamelCaseBehavior, "Enable_Camel_Case_In_Java");
        GeneralEditorPanel.loc(this.lCamelCaseBehaviorExample, "Camel_Case_Behavior_Example");
    }

    private void initComponents() {
        this.lCodeFolding = new JLabel();
        this.lUseCodeFolding = new JLabel();
        this.lCollapseByDefault = new JLabel();
        this.cbUseCodeFolding = new JCheckBox();
        this.cbFoldMethods = new JCheckBox();
        this.cbFoldInnerClasses = new JCheckBox();
        this.cbFoldImports = new JCheckBox();
        this.cbFoldJavadocComments = new JCheckBox();
        this.cbFoldInitialComments = new JCheckBox();
        this.lCodeCompletion = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lCodeCompletion2 = new JLabel();
        this.cbAutoPopup = new JCheckBox();
        this.cbInsertSingleProposalsAutomatically = new JCheckBox();
        this.cbCaseSensitive = new JCheckBox();
        this.cbShowDeprecated = new JCheckBox();
        this.cbInsertClosingBracketsAutomatically = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.lCamelCaseBehavior = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.cbCamelCaseBehavior = new JCheckBox();
        this.lCamelCaseBehaviorExample = new JLabel();
        this.cbDocsAutoPopup = new JCheckBox();
        this.cbGuessMethodArgs = new JCheckBox();
        this.setForeground(new Color(99, 130, 191));
        this.lCodeFolding.setText("Code Folding");
        this.lUseCodeFolding.setText("Use Code Folding:");
        this.lCollapseByDefault.setText("Collapse by Default:");
        this.cbUseCodeFolding.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldMethods.setText("Methods");
        this.cbFoldMethods.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldInnerClasses.setText("Inner Classes");
        this.cbFoldInnerClasses.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldImports.setText("Imports");
        this.cbFoldImports.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldJavadocComments.setText("Javadoc Comments");
        this.cbFoldJavadocComments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldInitialComments.setText("Initial Comments");
        this.cbFoldInitialComments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lCodeCompletion.setText("Code Completion");
        this.lCodeCompletion2.setText("Code Completion:");
        this.cbAutoPopup.setText("Auto Popup Code Completion Window");
        this.cbAutoPopup.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbInsertSingleProposalsAutomatically.setText("Insert Single Proposals Automatically");
        this.cbInsertSingleProposalsAutomatically.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbCaseSensitive.setText("Case Sensitive Code Completion");
        this.cbCaseSensitive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbShowDeprecated.setText("Show Deprecated Members In Code Completion");
        this.cbShowDeprecated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbInsertClosingBracketsAutomatically.setText("Insert Closing Brackets Automatically");
        this.cbInsertClosingBracketsAutomatically.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lCamelCaseBehavior.setText("Camel Case  Behavior");
        this.cbCamelCaseBehavior.setText("Enable Camel Case Navigation For Java");
        this.cbCamelCaseBehavior.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lCamelCaseBehaviorExample.setText("(Example: Caret stops at J, T, N in \"JavaTypeName\" when using next/previous word acctions)");
        this.lCamelCaseBehaviorExample.setEnabled(false);
        this.cbDocsAutoPopup.setText("Auto Popup Documentation Window");
        this.cbDocsAutoPopup.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbGuessMethodArgs.setText("Guess Filled Method Arguments");
        this.cbGuessMethodArgs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lUseCodeFolding).add((Component)this.lCodeCompletion2).add((Component)this.lCollapseByDefault)).add(14, 14, 14).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbCamelCaseBehavior).add((Component)this.cbInsertClosingBracketsAutomatically).add((Component)this.cbShowDeprecated).add((Component)this.cbCaseSensitive).add((Component)this.cbFoldInitialComments).add((Component)this.cbFoldJavadocComments).add((Component)this.cbFoldImports).add((Component)this.cbFoldInnerClasses).add((Component)this.cbFoldMethods).add((Component)this.cbUseCodeFolding).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbAutoPopup).add((Component)this.cbInsertSingleProposalsAutomatically)).add(91, 91, 91).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbGuessMethodArgs).add((Component)this.cbDocsAutoPopup))))).add((Component)this.lCamelCaseBehavior)).addContainerGap(147, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(138, 138, 138).add((Component)this.lCamelCaseBehaviorExample).addContainerGap(177, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(116, 116, 116).add((Component)this.jSeparator3, -1, 775, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lCodeCompletion).addPreferredGap(0).add((Component)this.jSeparator2, -1, 770, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lCodeFolding).addPreferredGap(0).add((Component)this.jSeparator1, -1, 796, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lCodeFolding).add((Component)this.jSeparator1, -2, 10, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lUseCodeFolding).add((Component)this.cbUseCodeFolding)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lCollapseByDefault).add((Component)this.cbFoldMethods)).addPreferredGap(0).add((Component)this.cbFoldInnerClasses).addPreferredGap(0).add((Component)this.cbFoldImports).addPreferredGap(0).add((Component)this.cbFoldJavadocComments).addPreferredGap(0).add((Component)this.cbFoldInitialComments).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lCodeCompletion).add((Component)this.jSeparator2, -2, 10, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lCodeCompletion2).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbAutoPopup).add((Component)this.cbDocsAutoPopup))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbInsertSingleProposalsAutomatically).add((Component)this.cbGuessMethodArgs)).addPreferredGap(0).add((Component)this.cbCaseSensitive).addPreferredGap(0).add((Component)this.cbShowDeprecated).addPreferredGap(0).add((Component)this.cbInsertClosingBracketsAutomatically).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lCamelCaseBehavior).add((Component)this.jSeparator3, -2, 10, -2)).addPreferredGap(0).add((Component)this.cbCamelCaseBehavior).addPreferredGap(0).add((Component)this.lCamelCaseBehaviorExample).addContainerGap(28, Short.MAX_VALUE)));
    }

    private static String loc(String string) {
        return NbBundle.getMessage(GeneralEditorPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(GeneralEditorPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(GeneralEditorPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)GeneralEditorPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)GeneralEditorPanel.loc("CTL_" + string));
        }
    }

    void update() {
        this.listen = false;
        if (this.model == null) {
            this.model = new Model();
            this.cbUseCodeFolding.addActionListener(this);
            this.cbFoldMethods.addActionListener(this);
            this.cbFoldInnerClasses.addActionListener(this);
            this.cbFoldImports.addActionListener(this);
            this.cbFoldJavadocComments.addActionListener(this);
            this.cbFoldInitialComments.addActionListener(this);
            this.cbAutoPopup.addActionListener(this);
            this.cbDocsAutoPopup.addActionListener(this);
            this.cbInsertSingleProposalsAutomatically.addActionListener(this);
            this.cbCaseSensitive.addActionListener(this);
            this.cbShowDeprecated.addActionListener(this);
            this.cbInsertClosingBracketsAutomatically.addActionListener(this);
            this.cbGuessMethodArgs.addActionListener(this);
            this.cbCamelCaseBehavior.addActionListener(this);
        }
        this.cbUseCodeFolding.setSelected(this.model.isShowCodeFolding());
        this.cbFoldImports.setSelected(this.model.isFoldImports());
        this.cbFoldInitialComments.setSelected(this.model.isFoldInitialComment());
        this.cbFoldInnerClasses.setSelected(this.model.isFoldInnerClasses());
        this.cbFoldJavadocComments.setSelected(this.model.isFoldJavaDocComments());
        this.cbFoldMethods.setSelected(this.model.isFoldMethods());
        this.cbInsertClosingBracketsAutomatically.setSelected(this.model.isPairCharacterCompletion());
        this.cbAutoPopup.setSelected(this.model.isCompletionAutoPopup());
        this.cbDocsAutoPopup.setSelected(this.model.isDocumentationAutoPopup());
        this.cbShowDeprecated.setSelected(this.model.isShowDeprecatedMembers());
        this.cbInsertSingleProposalsAutomatically.setSelected(this.model.isCompletionInstantSubstitution());
        this.cbCaseSensitive.setSelected(this.model.isCompletionCaseSensitive());
        this.cbGuessMethodArgs.setSelected(this.model.isGuessMethodArguments());
        Boolean bl = this.model.isCamelCaseJavaNavigation();
        if (bl == null) {
            this.cbCamelCaseBehavior.setEnabled(false);
            this.cbCamelCaseBehavior.setSelected(false);
        } else {
            this.cbCamelCaseBehavior.setEnabled(true);
            this.cbCamelCaseBehavior.setSelected(bl);
        }
        this.updateEnabledState();
        this.listen = true;
    }

    void applyChanges() {
        if (this.model == null || !this.changed) {
            return;
        }
        this.model.setFoldingOptions(this.cbUseCodeFolding.isSelected(), this.cbFoldImports.isSelected(), this.cbFoldInitialComments.isSelected(), this.cbFoldInnerClasses.isSelected(), this.cbFoldJavadocComments.isSelected(), this.cbFoldMethods.isSelected());
        this.model.setCompletionOptions(this.cbInsertClosingBracketsAutomatically.isSelected(), this.cbAutoPopup.isSelected(), this.cbDocsAutoPopup.isSelected(), this.cbShowDeprecated.isSelected(), this.cbInsertSingleProposalsAutomatically.isSelected(), this.cbCaseSensitive.isSelected(), this.cbGuessMethodArgs.isSelected());
        this.model.setCamelCaseNavigation(this.cbCamelCaseBehavior.isSelected());
        this.changed = false;
    }

    void cancel() {
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        if (actionEvent.getSource() == this.cbUseCodeFolding) {
            this.updateEnabledState();
        }
        this.changed = true;
    }

    private void updateEnabledState() {
        boolean bl = this.cbUseCodeFolding.isSelected();
        this.cbFoldImports.setEnabled(bl);
        this.cbFoldInitialComments.setEnabled(bl);
        this.cbFoldInnerClasses.setEnabled(bl);
        this.cbFoldJavadocComments.setEnabled(bl);
        this.cbFoldMethods.setEnabled(bl);
    }
}

