/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.editor.keymap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.EditorKit;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorBridge
extends KeymapManager {
    private static final Logger LOG = Logger.getLogger(EditorBridge.class.getName());
    private static final String EDITOR_BRIDGE = "EditorBridge";
    private Map<String, Set<ShortcutAction>> actions;
    private Map<String, EditorAction> editorActionsMap;
    private Map<String, Set<String>> actionNameToMimeTypes = new HashMap<String, Set<String>>();
    private EditorSettings editorSettings;
    private final Map<String, KeyBindingSettingsFactory> keyBindingSettings = new HashMap<String, KeyBindingSettingsFactory>();
    private static final String[] EMPTY = new String[0];
    private Listener listener;

    public EditorBridge() {
        super(EDITOR_BRIDGE);
    }

    public Map<String, Set<ShortcutAction>> getActions() {
        if (this.actions == null) {
            Map<String, String> map = EditorBridge.readCategories();
            this.actions = new HashMap<String, Set<ShortcutAction>>();
            for (EditorAction editorAction : this.getEditorActionsMap().values()) {
                Set<ShortcutAction> set;
                String string = map.get(editorAction.getId());
                if (string == null) {
                    string = NbBundle.getMessage(EditorBridge.class, (String)"CTL_Other");
                }
                if ((set = this.actions.get(string)) == null) {
                    set = new HashSet<ShortcutAction>();
                    this.actions.put(string, set);
                }
                set.add(editorAction);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Action='" + editorAction.getId() + "' -> Category='" + string + "'");
            }
            this.actions.remove("Hidden");
        }
        return this.actions;
    }

    public void refreshActions() {
        this.editorActionsMap = null;
        this.actions = null;
        this.actionNameToMimeTypes = new HashMap<String, Set<String>>();
    }

    public String getCurrentProfile() {
        return this.getEditorSettings().getCurrentKeyMapProfile();
    }

    public void setCurrentProfile(String string) {
        this.getEditorSettings().setCurrentKeyMapProfile(string);
    }

    public boolean isCustomProfile(String string) {
        return this.getEditorSettings().isCustomKeymapProfile(string);
    }

    public Map<ShortcutAction, Set<String>> getKeymap(String string) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        this.readKeymap(string, null, false, hashMap);
        for (String string2 : this.getEditorSettings().getMimeTypes()) {
            this.readKeymap(string, string2, false, hashMap);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Map<ShortcutAction, Set<String>> getDefaultKeymap(String string) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        this.readKeymap(string, null, true, hashMap);
        for (String string2 : this.getEditorSettings().getMimeTypes()) {
            this.readKeymap(string, string2, true, hashMap);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public void deleteProfile(String string) {
        KeyBindingSettingsFactory keyBindingSettingsFactory = this.getKeyBindingSettings(null);
        keyBindingSettingsFactory.setKeyBindings(string, null);
    }

    public void saveKeymap(String string, Map<ShortcutAction, Set<String>> map) {
        KeyBindingSettingsFactory keyBindingSettingsFactory;
        HashMap<String, ArrayList<MultiKeyBinding>> hashMap = new HashMap<String, ArrayList<MultiKeyBinding>>();
        for (ShortcutAction shortcutAction : map.keySet()) {
            keyBindingSettingsFactory = map.get(shortcutAction);
            ShortcutAction object = shortcutAction.getKeymapManagerInstance(EDITOR_BRIDGE);
            if (!(object instanceof EditorAction)) continue;
            EditorAction editorAction = (EditorAction)object;
            Set<String> set = this.getMimeTypes(editorAction);
            for (String string2 : keyBindingSettingsFactory) {
                MultiKeyBinding multiKeyBinding = new MultiKeyBinding(EditorBridge.stringToKeyStrokes2(string2), editorAction.getId());
                for (String string3 : set) {
                    ArrayList<MultiKeyBinding> arrayList = (ArrayList<MultiKeyBinding>)hashMap.get(string3);
                    if (arrayList == null) {
                        arrayList = new ArrayList<MultiKeyBinding>();
                        hashMap.put(string3, arrayList);
                    }
                    arrayList.add(multiKeyBinding);
                }
            }
        }
        for (String string4 : this.keyBindingSettings.keySet()) {
            keyBindingSettingsFactory = this.keyBindingSettings.get(string4);
            keyBindingSettingsFactory.setKeyBindings(string, (List)hashMap.get(string4));
        }
    }

    private Map<String, EditorAction> getEditorActionsMap() {
        if (this.editorActionsMap == null) {
            this.editorActionsMap = new HashMap<String, EditorAction>();
            this.initActionMap(null, null);
            HashMap<String, EditorAction> hashMap = new HashMap<String, EditorAction>(this.editorActionsMap);
            for (String string : this.getEditorSettings().getMimeTypes()) {
                this.initActionMap(string, hashMap);
            }
        }
        return this.editorActionsMap;
    }

    private Set<String> getMimeTypes(EditorAction editorAction) {
        this.getEditorActionsMap();
        return this.actionNameToMimeTypes.get(editorAction.getId());
    }

    private void initActionMap(String string, Map<String, EditorAction> map) {
        Action[] actionArray;
        Object object = null;
        if (string == null) {
            object = BaseKit.getKit(NbEditorKit.class);
        } else {
            actionArray = MimeLookup.getLookup((MimePath)MimePath.parse((String)string));
            object = (EditorKit)actionArray.lookup(EditorKit.class);
        }
        if (object == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("EditorKit not found for: " + string);
            }
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Loading actions for '" + (string == null ? "" : string) + "' using " + object);
        }
        actionArray = ((EditorKit)object).getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            Set<String> set;
            Object object2 = actionArray[i].getValue("no-keybinding");
            if (object2 instanceof Boolean && ((Boolean)object2).booleanValue()) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("! Action '" + actionArray[i].getValue("Name") + "' is hidden, ignoring");
                continue;
            }
            EditorAction editorAction = new EditorAction((TextAction)actionArray[i]);
            String string2 = editorAction.getId();
            if (map != null && map.containsKey(string2)) {
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest("Action '" + string2 + "' was already listed among all alnguages actions, skipping");
                continue;
            }
            this.editorActionsMap.put(string2, editorAction);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Action '" + string2 + "' loaded for '" + (string == null ? "" : string) + "'");
            }
            if ((set = this.actionNameToMimeTypes.get(string2)) == null) {
                set = new HashSet<String>();
                this.actionNameToMimeTypes.put(string2, set);
            }
            set.add(string);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Actions for '" + (string == null ? "" : string) + "' loaded successfully");
        }
    }

    private EditorSettings getEditorSettings() {
        if (this.editorSettings == null) {
            this.editorSettings = EditorSettings.getDefault();
        }
        return this.editorSettings;
    }

    private KeyBindingSettingsFactory getKeyBindingSettings(String string) {
        KeyBindingSettingsFactory keyBindingSettingsFactory = this.keyBindingSettings.get(string);
        if (keyBindingSettingsFactory == null) {
            String[] stringArray;
            EditorSettings editorSettings = EditorSettings.getDefault();
            if (string == null) {
                stringArray = EMPTY;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string;
            }
            keyBindingSettingsFactory = editorSettings.getKeyBindingSettings(stringArray);
            this.keyBindingSettings.put(string, keyBindingSettingsFactory);
            this.getListener().add(keyBindingSettingsFactory);
        }
        return keyBindingSettingsFactory;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
        return this.listener;
    }

    private void readKeymap(String string, String string2, boolean bl, Map<ShortcutAction, Set<String>> map) {
        List list;
        KeyBindingSettingsFactory keyBindingSettingsFactory = this.getKeyBindingSettings(string2);
        if (keyBindingSettingsFactory == null) {
            return;
        }
        List list2 = list = bl ? keyBindingSettingsFactory.getKeyBindingDefaults(string) : keyBindingSettingsFactory.getKeyBindings(string);
        if (list == null) {
            return;
        }
        Map<String, Set<String>> map2 = EditorBridge.convertKeymap(list);
        for (String string3 : map2.keySet()) {
            Set<String> set = map2.get(string3);
            ShortcutAction shortcutAction = this.getEditorActionsMap().get(string3);
            if (shortcutAction == null) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("action not found " + string3);
                continue;
            }
            Set<String> set2 = map.get(shortcutAction);
            if (set2 == null) {
                set2 = new HashSet<String>();
                map.put(shortcutAction, set2);
            }
            set2.addAll(set);
        }
    }

    private static Map<String, Set<String>> convertKeymap(List<MultiKeyBinding> list) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (int i = 0; i < list.size(); ++i) {
            MultiKeyBinding multiKeyBinding = list.get(i);
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < multiKeyBinding.getKeyStrokeCount(); ++j) {
                if (j > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(Utilities.keyToString((KeyStroke)((KeyStroke)multiKeyBinding.getKeyStrokeList().get(j))));
            }
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(multiKeyBinding.getActionName());
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(multiKeyBinding.getActionName(), hashSet);
            }
            hashSet.add(stringBuilder.toString());
        }
        return hashMap;
    }

    private static Map<String, String> readCategories() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("OptionsDialog/Actions");
        if (fileObject == null) {
            return hashMap;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string = fileObjectArray[i].getName();
            String string2 = (String)fileObjectArray[i].getAttribute("SystemFileSystem.localizingBundle");
            if (string2 != null) {
                try {
                    string = NbBundle.getBundle((String)string2).getString(fileObjectArray[i].getPath());
                }
                catch (MissingResourceException missingResourceException) {
                    ErrorManager.getDefault().notify((Throwable)missingResourceException);
                }
            }
            FileObject[] fileObjectArray2 = fileObjectArray[i].getChildren();
            for (int j = 0; j < fileObjectArray2.length; ++j) {
                if (fileObjectArray2[j].getExt().length() > 0) continue;
                String string3 = fileObjectArray2[j].getName();
                hashMap.put(string3, string);
            }
        }
        return hashMap;
    }

    public List<String> getProfiles() {
        return null;
    }

    private static KeyStroke[] stringToKeyStrokes2(String string) {
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = Utilities.stringToKey((String)string2);
            if (keyStroke == null) {
                LOG.warning("'" + string2 + "' is not a valid keystroke");
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    private static final class EditorAction
    implements ShortcutAction {
        private TextAction action;
        private String name;
        private String id;
        private String delegaitngActionId;

        public EditorAction(TextAction textAction) {
            this.action = textAction;
        }

        public String getDisplayName() {
            if (this.name == null) {
                this.name = (String)this.action.getValue("ShortDescription");
                if (this.name == null) {
                    LOG.warning("The action " + this.action + " doesn't provide short description, using its name.");
                    this.name = this.getId();
                }
                this.name = this.name.replaceAll("&", "").trim();
            }
            return this.name;
        }

        public String getId() {
            if (this.id == null) {
                this.id = (String)this.action.getValue("Name");
                assert (this.id != null) : "Actions must have name, offending action: " + this.action;
            }
            return this.id;
        }

        public String getDelegatingActionId() {
            if (this.delegaitngActionId == null) {
                this.delegaitngActionId = (String)this.action.getValue("systemActionClassName");
            }
            return this.delegaitngActionId;
        }

        public boolean equals(Object object) {
            if (!(object instanceof EditorAction)) {
                return false;
            }
            return ((EditorAction)object).getId().equals(this.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return "EditorAction[" + this.getDisplayName() + ":" + this.getId() + "]";
        }

        public ShortcutAction getKeymapManagerInstance(String string) {
            if (EditorBridge.EDITOR_BRIDGE.equals(string)) {
                return this;
            }
            return null;
        }

        public TextAction getRealAction() {
            return this.action;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private Reference<EditorBridge> model;
        private Set<KeyBindingSettingsFactory> factories = new HashSet<KeyBindingSettingsFactory>();

        Listener(EditorBridge editorBridge) {
            this.model = new WeakReference<EditorBridge>(editorBridge);
        }

        void add(KeyBindingSettingsFactory keyBindingSettingsFactory) {
            this.factories.add(keyBindingSettingsFactory);
            keyBindingSettingsFactory.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private EditorBridge getModel() {
            EditorBridge editorBridge = this.model.get();
            if (editorBridge != null) {
                return editorBridge;
            }
            for (KeyBindingSettingsFactory keyBindingSettingsFactory : this.factories) {
                keyBindingSettingsFactory.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.factories = new HashSet<KeyBindingSettingsFactory>();
            return null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EditorBridge editorBridge = this.getModel();
            if (editorBridge == null) {
                return;
            }
        }
    }
}

