/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.project.ui.ProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassPathSupport {
    private static final String LIBRARY_PREFIX = "${libs.";
    private static final String LIBRARY_SUFFIX = ".classpath}";
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private AntProjectHelper antProjectHelper;
    private UpdateHelper updateHelper;
    private static Set<String> wellKnownPaths = new HashSet<String>(Arrays.asList(ProjectProperties.WELL_KNOWN_PATHS));
    private static String antArtifactPrefix = "${reference.";
    private Callback callback;

    public ClassPathSupport(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, UpdateHelper updateHelper, Callback callback) {
        this.evaluator = propertyEvaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.updateHelper = updateHelper;
        this.callback = callback;
    }

    public Iterator<Item> itemsIterator(String string) {
        return this.itemsIterator(string, null);
    }

    public Iterator<Item> itemsIterator(String string, String string2) {
        return this.itemsList(string, string2).iterator();
    }

    public List<Item> itemsList(String string) {
        return this.itemsList(string, null);
    }

    public List<Item> itemsList(String string, String string2) {
        String[] stringArray = PropertyUtils.tokenizePath((String)(string == null ? "" : string));
        ArrayList<Item> arrayList = new ArrayList<Item>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Item item;
            if (this.isWellKnownPath(stringArray[i])) {
                item = Item.create(stringArray[i]);
            } else if (ClassPathSupport.isLibrary(stringArray[i])) {
                object4 = ClassPathSupport.getLibraryNameFromReference(stringArray[i]);
                assert (object4 != null) : "Not a library reference: " + stringArray[i];
                object3 = this.referenceHelper.findLibrary((String)object4);
                item = object3 == null ? Item.createBroken(1, stringArray[i]) : Item.create((Library)object3, stringArray[i]);
            } else if (this.isAntArtifact(stringArray[i])) {
                object4 = this.referenceHelper.findArtifactAndLocation(stringArray[i]);
                if (object4[0] == null || object4[1] == null) {
                    item = Item.createBroken(2, stringArray[i]);
                } else {
                    object3 = (AntArtifact)object4[0];
                    object2 = (URI)object4[1];
                    object = this.antProjectHelper.resolveFile(this.evaluator.evaluate(stringArray[i]));
                    File file = null;
                    file = ((URI)object2).isAbsolute() ? new File((URI)object2) : new File(object3.getScriptLocation().getParent(), ((URI)object2).getPath());
                    item = ((File)object).equals(file = FileUtil.normalizeFile((File)file)) ? Item.create((AntArtifact)object3, (URI)object2, stringArray[i]) : Item.createBroken(2, stringArray[i]);
                }
            } else {
                object4 = this.evaluator.evaluate(stringArray[i]);
                object3 = null;
                if (object4 != null) {
                    object3 = this.antProjectHelper.resolveFile((String)object4);
                }
                object2 = CommonProjectUtils.getAntPropertyName((String)stringArray[i]);
                object = this.antProjectHelper.getProperties("nbproject/project.properties").getProperty((String)object2);
                if (!ClassPathSupport.isVariableBasedReference((String)object)) {
                    object = null;
                }
                item = object3 == null || !((File)object3).exists() ? Item.createBroken((String)object4, FileUtil.toFile((FileObject)this.antProjectHelper.getProjectDirectory()), stringArray[i]) : Item.create((String)object4, FileUtil.toFile((FileObject)this.antProjectHelper.getProjectDirectory()), stringArray[i], (String)object);
                item.initSourceAndJavadoc(this.antProjectHelper);
            }
            arrayList.add(item);
        }
        if (string2 != null) {
            this.callback.readAdditionalProperties(arrayList, string2);
        }
        return arrayList;
    }

    public String[] encodeToStrings(List<Item> list) {
        return this.encodeToStrings(list, null);
    }

    public String[] encodeToStrings(List<Item> list, String string) {
        return this.encodeToStrings(list, string, "classpath");
    }

    public String[] encodeToStrings(List<Item> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = list.iterator();
        while (stringArray.hasNext()) {
            Item item = stringArray.next();
            String string3 = null;
            switch (item.getType()) {
                case 0: {
                    Library library;
                    string3 = item.getReference();
                    if (item.isBroken()) break;
                    if (string3 == null) {
                        string3 = this.referenceHelper.createForeignFileReferenceAsIs(item.getFilePath(), null);
                        if (item.getVariableBasedProperty() != null) {
                            library = this.antProjectHelper.getProperties("nbproject/project.properties");
                            library.setProperty(CommonProjectUtils.getAntPropertyName((String)string3), item.getVariableBasedProperty());
                            this.antProjectHelper.putProperties("nbproject/project.properties", (EditableProperties)library);
                        }
                        item.setReference(string3);
                    }
                    item.saveSourceAndJavadoc(this.referenceHelper, this.updateHelper);
                    break;
                }
                case 1: {
                    string3 = item.getReference();
                    if (item.isBroken()) break;
                    Library library = item.getLibrary();
                    if (string3 != null || library == null) break;
                    string3 = this.getLibraryReference(item, string2);
                    item.setReference(string3);
                    break;
                }
                case 2: {
                    string3 = item.getReference();
                    if (item.isBroken()) break;
                    AntArtifact antArtifact = item.getArtifact();
                    if (string3 != null || antArtifact == null) break;
                    string3 = this.referenceHelper.addReference(item.getArtifact(), item.getArtifactURI());
                    item.setReference(string3);
                    break;
                }
                case 3: {
                    string3 = item.getReference();
                }
            }
            arrayList.add(string3 + ":");
        }
        if (string != null) {
            this.callback.storeAdditionalProperties(list, string);
        }
        if ((stringArray = arrayList.toArray(new String[arrayList.size()])).length != 0) {
            stringArray[stringArray.length - 1] = stringArray[stringArray.length - 1].substring(0, stringArray[stringArray.length - 1].length() - 1);
        }
        return stringArray;
    }

    public String getLibraryReference(Item item) {
        return this.getLibraryReference(item, "classpath");
    }

    public String getLibraryReference(Item item, String string) {
        if (item.getType() != 1) {
            throw new IllegalArgumentException("Item must be of type LIBRARY");
        }
        return this.referenceHelper.createLibraryReference(item.getLibrary(), string);
    }

    private boolean isWellKnownPath(String string) {
        return wellKnownPaths == null ? false : wellKnownPaths.contains(string);
    }

    private boolean isAntArtifact(String string) {
        return antArtifactPrefix == null ? false : string.startsWith(antArtifactPrefix);
    }

    private static boolean isLibrary(String string) {
        return string.startsWith(LIBRARY_PREFIX) && string.endsWith(LIBRARY_SUFFIX);
    }

    public static boolean isVariableBasedReference(String string) {
        return string != null && string.startsWith("${var.");
    }

    public static String getLibraryNameFromReference(String string) {
        if (!ClassPathSupport.isLibrary(string)) {
            return null;
        }
        return string.substring(LIBRARY_PREFIX.length(), string.lastIndexOf(46));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callback {
        public void readAdditionalProperties(List<Item> var1, String var2);

        public void storeAdditionalProperties(List<Item> var1, String var2);
    }

    private static final class RelativePath {
        private String filePath;
        private final File base;
        private final File resolvedFile;

        private RelativePath(String string, File file) {
            Parameters.notNull((CharSequence)"filePath", (Object)string);
            Parameters.notNull((CharSequence)"base", (Object)file);
            this.filePath = string;
            this.base = file;
            this.resolvedFile = PropertyUtils.resolveFile((File)file, (String)string);
        }

        public static RelativePath createRelativePath(String string, File file) {
            return new RelativePath(string, file);
        }

        public String getFilePath() {
            return this.filePath;
        }

        public File getResolvedFile() {
            return this.resolvedFile;
        }

        public int hashCode() {
            return this.filePath.hashCode() + this.base.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RelativePath)) {
                return false;
            }
            RelativePath relativePath = (RelativePath)object;
            return this.filePath.equals(relativePath.filePath) && this.base.equals(relativePath.base);
        }
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        private static final String REF_START = "${file.reference.";
        private static final int REF_START_INDEX = "${file.reference.".length();
        private static final String JAVADOC_START = "${javadoc.reference.";
        private static final String SOURCE_START = "${source.reference.";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;
        private String raw;
        private String eval;
        private boolean broken;
        private String sourceFilePath;
        private String javadocFilePath;
        private String initialSourceFilePath;
        private String initialJavadocFilePath;
        private String libraryName;
        private String variableBasedProperty;
        private Map<String, String> additionalProperties = new HashMap<String, String>();

        private Item(int n, Object object, String string, String string2, String string3, boolean bl) {
            this.type = n;
            this.object = object;
            this.broken = bl;
            if (!(object == null || n == 3 || bl || n == 0 && object instanceof RelativePath || n == 2 && object instanceof AntArtifact || n == 1 && object instanceof Library)) {
                throw new IllegalArgumentException("invalid classpath item, type=" + n + " object type:" + object.getClass().getName());
            }
            this.raw = string;
            this.eval = string2;
            this.property = string3;
        }

        private Item(int n, Object object, String string, String string2, URI uRI, String string3) {
            this(n, object, string, string2, string3);
            this.artifactURI = uRI;
        }

        private Item(int n, Object object, String string, String string2, String string3) {
            this(n, object, string, string2, string3, false);
        }

        public String getAdditionalProperty(String string) {
            return this.additionalProperties.get(string);
        }

        public void setAdditionalProperty(String string, String string2) {
            this.additionalProperties.put(string, string2);
        }

        public void setRaw(String string) {
            this.raw = string;
        }

        public String getRaw() {
            return this.raw;
        }

        public static Item create(Library library, String string) {
            if (library == null) {
                throw new IllegalArgumentException("library must not be null");
            }
            String string2 = library.getName();
            Item item = new Item(1, library, ClassPathSupport.LIBRARY_PREFIX + string2 + ClassPathSupport.LIBRARY_SUFFIX, string2, string);
            item.libraryName = string2;
            item.reassignLibraryManager(library.getManager());
            return item;
        }

        public static Item create(AntArtifact antArtifact, URI uRI, String string) {
            if (uRI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (antArtifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(2, (Object)antArtifact, null, antArtifact.getArtifactLocations()[0].toString(), uRI, string);
        }

        public static Item create(String string, File file, String string2, String string3) {
            if (string == null) {
                throw new IllegalArgumentException("file path must not be null");
            }
            Item item = new Item(0, RelativePath.createRelativePath(string, file), null, string, string2);
            item.variableBasedProperty = string3;
            return item;
        }

        public static Item create(String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, null, null, string);
        }

        public static Item createBroken(int n, String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            Item item = new Item(n, null, null, null, string, true);
            if (n == 1) {
                Pattern pattern = Pattern.compile("\\$\\{libs\\.([a-zA-Z0-9_\\-\\.]+)\\.([^.]+)\\}");
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    item.libraryName = matcher.group(1);
                } else assert (false) : string;
            }
            return item;
        }

        public static Item createBroken(String string, File file, String string2) {
            return new Item(0, (Object)RelativePath.createRelativePath(string, file), null, null, string2, true);
        }

        public int getType() {
            return this.type;
        }

        public Library getLibrary() {
            if (this.getType() != 1) {
                throw new IllegalArgumentException("Item is not of required type - LIBRARY");
            }
            if (this.isBroken()) {
                return null;
            }
            assert (this.object == null || this.object instanceof Library) : "Invalid object type: " + this.object.getClass().getName() + " instance: " + this.object.toString() + " expected type: Library";
            return (Library)this.object;
        }

        public File getResolvedFile() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return ((RelativePath)this.object).getResolvedFile();
        }

        public String getFilePath() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return ((RelativePath)this.object).getFilePath();
        }

        public String getVariableBasedProperty() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return this.variableBasedProperty;
        }

        public AntArtifact getArtifact() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            if (this.isBroken()) {
                return null;
            }
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public void reassignLibraryManager(LibraryManager libraryManager) {
            if (this.getType() != 1) {
                throw new IllegalArgumentException(" reassigning only works for type - LIBRARY");
            }
            assert (this.libraryName != null);
            if (this.getLibrary() == null || libraryManager != this.getLibrary().getManager()) {
                Library library = libraryManager.getLibrary(this.libraryName);
                if (library == null) {
                    this.broken = true;
                    this.object = null;
                } else {
                    this.object = library;
                    this.broken = false;
                }
            }
        }

        public boolean canDelete() {
            return this.getType() != 3;
        }

        public String getReference() {
            return this.property;
        }

        public void setReference(String string) {
            this.property = string;
        }

        private String getSourceProperty() {
            if (this.property == null || !this.property.startsWith(REF_START)) {
                return null;
            }
            return CommonProjectUtils.getAntPropertyName((String)(SOURCE_START + this.property.substring(REF_START_INDEX)));
        }

        private String getJavadocProperty() {
            if (this.property == null || !this.property.startsWith(REF_START)) {
                return null;
            }
            return CommonProjectUtils.getAntPropertyName((String)(JAVADOC_START + this.property.substring(REF_START_INDEX)));
        }

        public boolean canEdit() {
            if (this.isBroken()) {
                return false;
            }
            if (this.getType() == 0) {
                if (this.property == null) {
                    return true;
                }
                return this.getSourceProperty() != null && this.getJavadocProperty() != null;
            }
            return this.getType() == 1;
        }

        public String getSourceFilePath() {
            return this.sourceFilePath;
        }

        public String getJavadocFilePath() {
            return this.javadocFilePath;
        }

        public void setJavadocFilePath(String string) {
            this.javadocFilePath = string;
        }

        public void setSourceFilePath(String string) {
            this.sourceFilePath = string;
        }

        private void setInitialSourceAndJavadoc(String string, String string2) {
            this.initialSourceFilePath = string;
            this.initialJavadocFilePath = string2;
            this.sourceFilePath = string;
            this.javadocFilePath = string2;
        }

        private boolean hasChangedSource() {
            if (this.initialSourceFilePath == null != (this.sourceFilePath == null)) {
                return true;
            }
            if (this.initialSourceFilePath != null && this.sourceFilePath != null) {
                return !this.initialSourceFilePath.equals(this.sourceFilePath);
            }
            return true;
        }

        private boolean hasChangedJavadoc() {
            if (this.initialJavadocFilePath == null != (this.javadocFilePath == null)) {
                return true;
            }
            if (this.initialJavadocFilePath != null && this.javadocFilePath != null) {
                return !this.initialJavadocFilePath.equals(this.javadocFilePath);
            }
            return true;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public void initSourceAndJavadoc(AntProjectHelper antProjectHelper) {
            assert (this.getType() == 0) : this.getType();
            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
            String string = null;
            String string2 = this.getSourceProperty();
            if (string2 != null) {
                string = editableProperties.getProperty(string2);
            }
            String string3 = null;
            string2 = this.getJavadocProperty();
            if (string2 != null) {
                string3 = editableProperties.getProperty(string2);
            }
            this.setInitialSourceAndJavadoc(string, string3);
        }

        public void saveSourceAndJavadoc(ReferenceHelper referenceHelper, UpdateHelper updateHelper) {
            assert (this.getType() == 0) : this.getType();
            if (this.hasChangedSource()) {
                if (this.getSourceFilePath() != null) {
                    referenceHelper.createExtraForeignFileReferenceAsIs(this.getSourceFilePath(), this.getSourceProperty());
                } else {
                    this.removeSource(updateHelper);
                }
            }
            if (this.hasChangedJavadoc()) {
                if (this.getJavadocFilePath() != null) {
                    referenceHelper.createExtraForeignFileReferenceAsIs(this.getJavadocFilePath(), this.getJavadocProperty());
                } else {
                    this.removeJavadoc(updateHelper);
                }
            }
        }

        public void removeSourceAndJavadoc(UpdateHelper updateHelper) {
            assert (this.getType() == 0) : this.getType();
            this.removeSource(updateHelper);
            this.removeJavadoc(updateHelper);
        }

        private void removeSource(UpdateHelper updateHelper) {
            EditableProperties editableProperties = updateHelper.getProperties("nbproject/project.properties");
            if (this.getSourceProperty() != null) {
                editableProperties.remove((Object)this.getSourceProperty());
            }
            updateHelper.putProperties("nbproject/project.properties", editableProperties);
        }

        private void removeJavadoc(UpdateHelper updateHelper) {
            EditableProperties editableProperties = updateHelper.getProperties("nbproject/project.properties");
            if (this.getJavadocProperty() != null) {
                editableProperties.remove((Object)this.getJavadocProperty());
            }
            updateHelper.putProperties("nbproject/project.properties", editableProperties);
        }

        public void updateJarReference(AntProjectHelper antProjectHelper) {
            assert (this.getType() == 0) : this.getType();
            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
            String string = editableProperties.getProperty(CommonProjectUtils.getAntPropertyName((String)this.getReference()));
            RelativePath relativePath = (RelativePath)this.object;
            relativePath.filePath = string;
            String string2 = this.getSourceProperty();
            if (string2 != null && (string = editableProperties.getProperty(string2)) != null) {
                this.setSourceFilePath(string);
            }
            if ((string2 = this.getJavadocProperty()) != null && (string = editableProperties.getProperty(string2)) != null) {
                this.setJavadocFilePath(string);
            }
        }

        public int hashCode() {
            int n = this.getType();
            if (this.broken) {
                return 42;
            }
            switch (this.getType()) {
                case 2: {
                    n += this.getArtifact().getType().hashCode();
                    n += this.getArtifact().getScriptLocation().hashCode();
                    n += this.getArtifactURI().hashCode();
                    break;
                }
                case 3: {
                    n += this.property.hashCode();
                    break;
                }
                default: {
                    n += this.object.hashCode();
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Item)) {
                return false;
            }
            Item item = (Item)object;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 2: {
                    if (!this.getArtifact().getType().equals(item.getArtifact().getType())) {
                        return false;
                    }
                    if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                        return false;
                    }
                    return this.getArtifactURI().equals(item.getArtifactURI());
                }
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }

        public String toString() {
            return "artifactURI=" + this.artifactURI + ", type=" + this.type + ", property=" + this.property + ", raw=" + this.raw + ", eval=" + this.eval + ", object=" + this.object + ", broken=" + this.broken + ", additional=" + this.additionalProperties;
        }
    }
}

