/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.method.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.j2ee.common.method.impl.ParametersPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExceptionsPanel
extends JPanel {
    private final ExceptionsTableModel tableModel;
    private final ClasspathInfo cpInfo;
    private JButton addButton;
    private JButton downButton;
    private JButton editButton;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JTable table;
    private JButton upButton;

    public ExceptionsPanel(List<String> list, ClasspathInfo classpathInfo) {
        this.initComponents();
        this.tableModel = new ExceptionsTableModel(list);
        this.cpInfo = classpathInfo;
        this.table.setModel(this.tableModel);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ListSelectionListenerImpl listSelectionListenerImpl = new ListSelectionListenerImpl();
        this.table.getSelectionModel().addListSelectionListener(listSelectionListenerImpl);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListenerImpl);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ExceptionsPanel.this.updateButtons();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ExceptionsPanel.this.updateButtons();
            }
        });
        this.updateButtons();
    }

    public List<String> getExceptions() {
        return this.tableModel.getExceptions();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.editButton = new JButton();
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.table);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSN_ExceptionsTab"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_ExceptionsTab"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ParametersPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionsPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ParametersPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionsPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ParametersPanel.upButton.text"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionsPanel.this.upButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ParametersPanel.downButton.text"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionsPanel.this.downButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ExceptionsPanel.editButton.text_1"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionsPanel.this.editButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 241, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addButton).add((Component)this.removeButton).add((Component)this.editButton).add((Component)this.upButton).add((Component)this.downButton)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addButton, this.downButton, this.editButton, this.removeButton, this.upButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton).addPreferredGap(0).add((Component)this.editButton).add(18, 18, 18).add((Component)this.upButton).addPreferredGap(0).add((Component)this.downButton)).add((Component)this.jScrollPane1, -1, 276, Short.MAX_VALUE)).addContainerGap()));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_AddExceptionIntoTab"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_RemoveExceptionFromTab"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_MoveUpInExcepTab"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_MoveDownInExceptionTab"));
        this.editButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_editExceptionButton"));
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        int n2 = n + 1;
        if (n2 < this.tableModel.getExceptions().size()) {
            this.tableModel.set(n2, this.tableModel.set(n, this.tableModel.getException(n2)));
            this.table.setRowSelectionInterval(n2, n2);
            this.updateButtons();
        }
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        int n2 = n - 1;
        if (n2 >= 0) {
            this.tableModel.set(n2, this.tableModel.set(n, this.tableModel.getException(n2)));
            this.table.setRowSelectionInterval(n2, n2);
            this.updateButtons();
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n > -1) {
            this.tableModel.removeException(n);
        }
        if (n == this.table.getRowCount()) {
            --n;
        }
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.updateButtons();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        ElementHandle<TypeElement> elementHandle = this.browseExceptions();
        if (elementHandle != null) {
            int n = this.tableModel.addException(elementHandle.getQualifiedName());
            this.table.getSelectionModel().setSelectionInterval(n, n);
            this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            this.updateButtons();
        }
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        ElementHandle<TypeElement> elementHandle = this.browseExceptions();
        if (elementHandle != null) {
            int n = this.table.getSelectedRow();
            this.table.getSelectionModel().setSelectionInterval(n, n);
            this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            this.tableModel.setValueAt(elementHandle.getQualifiedName(), n, 0);
        }
    }

    private ElementHandle<TypeElement> browseExceptions() {
        return TypeElementFinder.find((ClasspathInfo)this.cpInfo, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String string, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> set) {
                return classpathInfo.getClassIndex().getDeclaredTypes(string, nameKind, set);
            }

            public boolean accept(ElementHandle<TypeElement> elementHandle) {
                return true;
            }
        });
    }

    private void updateButtons() {
        int n = this.table.getSelectedRow();
        boolean bl = this.table.getSelectedRowCount() == 1;
        this.removeButton.setEnabled(bl);
        this.editButton.setEnabled(bl);
        this.upButton.setEnabled(bl && n > 0);
        this.downButton.setEnabled(bl && n < this.tableModel.getRowCount() - 1);
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ExceptionsPanel.this.table.editCellAt(ExceptionsPanel.this.table.getSelectedRow(), ExceptionsPanel.this.table.getSelectedColumn());
            Component component = ExceptionsPanel.this.table.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
            if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                jTextComponent.selectAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExceptionsTableModel
    extends AbstractTableModel {
        private final List<String> exceptions;

        public ExceptionsTableModel(List<String> list) {
            this.exceptions = new ArrayList<String>(list);
        }

        public List<String> getExceptions() {
            return this.exceptions;
        }

        public int addException(String string) {
            int n = this.exceptions.size();
            this.exceptions.add(string);
            this.fireTableRowsInserted(n, n);
            return n;
        }

        public void removeException(int n) {
            this.exceptions.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public String getException(int n) {
            return this.exceptions.get(n);
        }

        public String set(int n, String string) {
            return this.exceptions.set(n, string);
        }

        @Override
        public int getRowCount() {
            return this.exceptions.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n >= 0) {
                string = this.exceptions.get(n);
            }
            return string;
        }

        @Override
        public String getColumnName(int n) {
            return NbBundle.getMessage(ParametersPanel.class, (String)"ExceptionsPanel.LBL_Exception");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.exceptions.set(n, (String)object);
            this.fireTableCellUpdated(n, n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

