/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.method;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.impl.FieldCustomizerPanel;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FieldCustomizer {
    private final Entity entity;
    private final FieldCustomizerPanel panel;

    public FieldCustomizer(Entity entity, MethodModel.Variable variable, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.entity = entity;
        this.panel = new FieldCustomizerPanel(variable, string, bl, bl2, bl3, bl4, bl5, bl6);
    }

    public boolean customizeField() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(FieldCustomizer.class, (String)"LBL_AddCmpField"), true, 2, (Object)-1, null);
        this.panel.addPropertyChangeListener(new Validator(this.panel, (NotifyDescriptor)dialogDescriptor, this.entity));
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == NotifyDescriptor.OK_OPTION;
    }

    public MethodModel.Variable getField() {
        return MethodModel.Variable.create(this.panel.getReturnType(), this.panel.getMethodName());
    }

    public String getDescription() {
        return this.panel.getDescription();
    }

    public boolean isLocalGetter() {
        return this.panel.isLocalGetter();
    }

    public boolean isLocalSetter() {
        return this.panel.isLocalSetter();
    }

    public boolean isRemoteGetter() {
        return this.panel.isRemoteGetter();
    }

    public boolean isRemoteSetter() {
        return this.panel.isRemoteSetter();
    }

    private static class Validator
    implements PropertyChangeListener {
        private final FieldCustomizerPanel panel;
        private final NotifyDescriptor notifyDescriptor;
        private final Entity entity;

        public Validator(FieldCustomizerPanel fieldCustomizerPanel, NotifyDescriptor notifyDescriptor, Entity entity) {
            this.panel = fieldCustomizerPanel;
            this.notifyDescriptor = notifyDescriptor;
            this.entity = entity;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.validate();
        }

        private boolean validate() {
            String string = this.panel.getMethodName();
            if (!Utilities.isJavaIdentifier((String)string)) {
                this.setError(NbBundle.getMessage(FieldCustomizer.class, (String)"ERROR_nameNonJavaIdentifier"));
                return false;
            }
            CmpField[] cmpFieldArray = this.entity.getCmpField();
            for (int i = 0; i < cmpFieldArray.length; ++i) {
                CmpField cmpField = cmpFieldArray[i];
                if (!string.equals(cmpField.getFieldName())) continue;
                this.setError(NbBundle.getMessage(FieldCustomizer.class, (String)"MSG_Duplicate_Field_Name", (Object)string));
                return false;
            }
            String string2 = this.panel.getReturnType();
            if ("".equals(string2)) {
                this.setError(NbBundle.getMessage(FieldCustomizer.class, (String)"ERROR_returnTypeInvalid"));
                return false;
            }
            if (!(this.panel.isLocalGetter() || this.panel.isLocalSetter() || this.panel.isRemoteGetter() || this.panel.isRemoteSetter())) {
                this.setError(NbBundle.getMessage(FieldCustomizer.class, (String)"ERROR_selectSomeInterface"));
                return false;
            }
            this.unsetError();
            return true;
        }

        private void setError(String string) {
            this.notifyDescriptor.setValid(false);
            this.panel.setError(string);
        }

        private void unsetError() {
            this.notifyDescriptor.setValid(true);
            this.panel.setError("");
        }
    }
}

