/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalogsupport.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.xml.catalogsupport.ui.customizer.CustomizerProjectReferences;
import org.netbeans.modules.xml.catalogsupport.ui.customizer.CustomizerXMLCatalog;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizerProviderImpl
implements CustomizerProvider {
    private final Project project;
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper refHelper;
    private List<ProjectCustomizer.Category> categories;
    private PanelProvider panelProvider;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private static Map<Project, Dialog> project2Dialog = new HashMap<Project, Dialog>();
    private static final String REFERENCE = "Project References";
    private static final String CATALOG = "XML Catalog";

    public CustomizerProviderImpl(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.project = project;
        this.refHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String string) {
        this.showCustomizer(string, null);
    }

    public void showCustomizer(String string, String string2) {
        Dialog dialog = project2Dialog.get(this.getProject());
        if (dialog != null) {
            dialog.setVisible(true);
            return;
        }
        this.init();
        OptionListener optionListener = new OptionListener(this.getProject());
        List<ProjectCustomizer.Category> list = this.getCategories();
        if (string != null && string2 != null) {
            for (ProjectCustomizer.Category category : list) {
                if (!string.equals(category.getName())) continue;
                JComponent jComponent = this.panelProvider.create(category);
                if (!(jComponent instanceof SubCategoryProvider)) break;
                ((SubCategoryProvider)((Object)jComponent)).showSubCategory(string2);
                break;
            }
        }
        dialog = ProjectCustomizer.createCustomizerDialog((ProjectCustomizer.Category[])list.toArray(new ProjectCustomizer.Category[list.size()]), (ProjectCustomizer.CategoryComponentProvider)this.panelProvider, (String)string, (ActionListener)optionListener, null);
        dialog.addWindowListener(new OptionListener(this.getProject()));
        dialog.setTitle(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Customizer_Title", (Object)ProjectUtils.getInformation((Project)this.getProject()).getDisplayName()));
        project2Dialog.put(this.getProject(), dialog);
        dialog.setVisible(true);
    }

    protected void init() {
        this.categories = new ArrayList<ProjectCustomizer.Category>();
        this.panelProvider = new PanelProvider(this.createCategoriesMap());
    }

    protected Project getProject() {
        return this.project;
    }

    protected AntProjectHelper getAntProjectHelper() {
        return this.antProjectHelper;
    }

    protected ReferenceHelper getRefHelper() {
        return this.refHelper;
    }

    protected List<ProjectCustomizer.Category> getCategories() {
        return this.categories;
    }

    protected Map<ProjectCustomizer.Category, JComponent> createCategoriesMap() {
        ProjectCustomizer.Category category = ProjectCustomizer.Category.create((String)REFERENCE, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Customizer_Category_ProjectReferences"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        ProjectCustomizer.Category category2 = ProjectCustomizer.Category.create((String)CATALOG, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Customizer_Category_XMLCatalog"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        this.getCategories().add(category);
        this.getCategories().add(category2);
        HashMap<ProjectCustomizer.Category, JComponent> hashMap = new HashMap<ProjectCustomizer.Category, JComponent>();
        hashMap.put(category, new CustomizerProjectReferences(this.getProject(), this.getRefHelper()));
        hashMap.put(category2, new CustomizerXMLCatalog(this.getProject()));
        return hashMap;
    }

    protected void storeProjectData() {
        for (JComponent jComponent : this.panelProvider.panels.values()) {
            if (!(jComponent instanceof CustomizerXMLCatalog)) continue;
            ((CustomizerXMLCatalog)jComponent).storeProjectData();
        }
    }

    public static interface SubCategoryProvider {
        public void showSubCategory(String var1);
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;

        OptionListener(Project project) {
            this.project = project;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomizerProviderImpl.this.storeProjectData();
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            project2Dialog.remove(this.project);
        }

        public void windowClosing(WindowEvent windowEvent) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PanelProvider
    implements ProjectCustomizer.CategoryComponentProvider {
        private JPanel EMPTY_PANEL = new JPanel();
        private Map<ProjectCustomizer.Category, JComponent> panels;

        PanelProvider(Map<ProjectCustomizer.Category, JComponent> map) {
            this.panels = map;
        }

        public JComponent create(ProjectCustomizer.Category category) {
            JComponent jComponent = this.panels.get(category);
            return jComponent == null ? this.EMPTY_PANEL : jComponent;
        }
    }
}

