/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.resource;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractField;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractSetterMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.impl.application.InjectableProviderFactory;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.resource.InjectableProviderContext;
import com.sun.jersey.spi.service.ComponentContext;
import com.sun.jersey.spi.service.ComponentProvider;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceClassInjector {
    private Field[] singletonFields;
    private Object[] singletonFieldValues;
    private Field[] perRequestFields;
    private Injectable<?>[] perRequestFieldInjectables;
    private Method[] singletonSetters;
    private Object[] singletonSetterValues;
    private Method[] perRequestSetters;
    private Injectable<?>[] perRequestSetterInjectables;

    public ResourceClassInjector(InjectableProviderContext ipc, ComponentProvider.Scope s, AbstractResource resource) {
        this.processFields(ipc, s, resource.getFields());
        this.processSetters(ipc, s, resource.getSetterMethods());
    }

    private void processFields(InjectableProviderContext ipc, ComponentProvider.Scope s, List<AbstractField> fields) {
        HashMap<Field, Injectable> singletons = new HashMap<Field, Injectable>();
        HashMap<Field, Injectable> perRequest = new HashMap<Field, Injectable>();
        InjectableProviderFactory.AccessibleObjectContext aoc = new InjectableProviderFactory.AccessibleObjectContext();
        for (AbstractField af : fields) {
            Injectable i;
            aoc.setAccesibleObject(af.getField());
            Parameter p = af.getParameters().get(0);
            if (p.getAnnotation() == null) continue;
            if (s == ComponentProvider.Scope.PerRequest) {
                i = ipc.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)aoc, p.getAnnotation(), p, ComponentProvider.Scope.PerRequest);
                if (i != null) {
                    this.configureField(af.getField());
                    perRequest.put(af.getField(), i);
                    continue;
                }
                i = ipc.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)aoc, p.getAnnotation(), p.getParameterType(), Arrays.asList(ComponentProvider.Scope.PerRequest, ComponentProvider.Scope.Undefined));
                if (i != null) {
                    this.configureField(af.getField());
                    perRequest.put(af.getField(), i);
                    continue;
                }
                i = ipc.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)aoc, p.getAnnotation(), p.getParameterType(), ComponentProvider.Scope.Singleton);
                if (i == null) continue;
                this.configureField(af.getField());
                singletons.put(af.getField(), i);
                continue;
            }
            i = ipc.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)aoc, p.getAnnotation(), p.getParameterType(), Arrays.asList(ComponentProvider.Scope.Undefined, ComponentProvider.Scope.Singleton));
            if (i == null) continue;
            this.configureField(af.getField());
            singletons.put(af.getField(), i);
        }
        int size = singletons.entrySet().size();
        this.singletonFields = new Field[size];
        this.singletonFieldValues = new Object[size];
        int i = 0;
        for (Map.Entry e : singletons.entrySet()) {
            this.singletonFields[i] = (Field)e.getKey();
            this.singletonFieldValues[i++] = ((Injectable)e.getValue()).getValue(null);
        }
        size = perRequest.entrySet().size();
        this.perRequestFields = new Field[size];
        this.perRequestFieldInjectables = new Injectable[size];
        i = 0;
        for (Map.Entry e : perRequest.entrySet()) {
            this.perRequestFields[i] = (Field)e.getKey();
            this.perRequestFieldInjectables[i++] = (Injectable)e.getValue();
        }
    }

    private void configureField(final Field f) {
        if (!f.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    f.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private void processSetters(InjectableProviderContext ipc, ComponentProvider.Scope s, List<AbstractSetterMethod> setterMethods) {
        HashMap<Method, Injectable> singletons = new HashMap<Method, Injectable>();
        HashMap<Method, Injectable> perRequest = new HashMap<Method, Injectable>();
        InjectableProviderFactory.AccessibleObjectContext aoc = new InjectableProviderFactory.AccessibleObjectContext();
        for (AbstractSetterMethod sm : setterMethods) {
            Injectable i;
            Parameter p = sm.getParameters().get(0);
            aoc.setAccesibleObject(sm.getMethod(), p.getAnnotations());
            if (p.getAnnotation() == null) continue;
            if (s == ComponentProvider.Scope.PerRequest) {
                i = ipc.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)aoc, p.getAnnotation(), p, ComponentProvider.Scope.PerRequest);
                if (i != null) {
                    perRequest.put(sm.getMethod(), i);
                    continue;
                }
                i = ipc.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)aoc, p.getAnnotation(), p.getParameterType(), Arrays.asList(ComponentProvider.Scope.PerRequest, ComponentProvider.Scope.Undefined));
                if (i != null) {
                    perRequest.put(sm.getMethod(), i);
                    continue;
                }
                i = ipc.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)aoc, p.getAnnotation(), p.getParameterType(), ComponentProvider.Scope.Singleton);
                if (i == null) continue;
                singletons.put(sm.getMethod(), i);
                continue;
            }
            i = ipc.getInjectable(p.getAnnotation().annotationType(), (ComponentContext)aoc, p.getAnnotation(), p.getParameterType(), Arrays.asList(ComponentProvider.Scope.Undefined, ComponentProvider.Scope.Singleton));
            if (i == null) continue;
            singletons.put(sm.getMethod(), i);
        }
        int size = singletons.entrySet().size();
        this.singletonSetters = new Method[size];
        this.singletonSetterValues = new Object[size];
        int i = 0;
        for (Map.Entry e : singletons.entrySet()) {
            this.singletonSetters[i] = (Method)e.getKey();
            this.singletonSetterValues[i++] = ((Injectable)e.getValue()).getValue(null);
        }
        size = perRequest.entrySet().size();
        this.perRequestSetters = new Method[size];
        this.perRequestSetterInjectables = new Injectable[size];
        i = 0;
        for (Map.Entry e : perRequest.entrySet()) {
            this.perRequestSetters[i] = (Method)e.getKey();
            this.perRequestSetterInjectables[i++] = (Injectable)e.getValue();
        }
    }

    public void inject(HttpContext c, Object o) {
        int i = 0;
        for (Field field : this.singletonFields) {
            try {
                if (field.get(o) == null) {
                    field.set(o, this.singletonFieldValues[i]);
                }
                ++i;
            }
            catch (IllegalAccessException ex) {
                throw new ContainerException(ex);
            }
        }
        i = 0;
        for (Field field : this.perRequestFields) {
            try {
                if (field.get(o) == null) {
                    field.set(o, this.perRequestFieldInjectables[i].getValue(c));
                }
                ++i;
            }
            catch (IllegalAccessException ex) {
                throw new ContainerException(ex);
            }
        }
        i = 0;
        for (AccessibleObject accessibleObject : this.singletonSetters) {
            try {
                ((Method)accessibleObject).invoke(o, this.singletonSetterValues[i++]);
            }
            catch (Exception ex) {
                throw new ContainerException(ex);
            }
        }
        i = 0;
        for (AccessibleObject accessibleObject : this.perRequestSetters) {
            try {
                ((Method)accessibleObject).invoke(o, this.perRequestSetterInjectables[i++].getValue(c));
            }
            catch (Exception ex) {
                throw new ContainerException(ex);
            }
        }
    }
}

