/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.wadl;

import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.impl.model.method.ResourceMethod;
import com.sun.jersey.impl.uri.PathPattern;
import com.sun.jersey.impl.wadl.WadlMethodFactory;
import com.sun.jersey.impl.wadl.WadlResource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WadlFactory {
    private static final Logger LOGGER = Logger.getLogger(WadlFactory.class.getName());

    public static Object createWadlResource(Set<AbstractResource> rootResources) {
        try {
            WadlFactory.checkForJAXB();
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning("WADL generation is disabled because JAXB jars are not included in the java class path. To enable WADL include JAXB 2.x jars in the java class path.");
            return null;
        }
        return new WadlResource(rootResources);
    }

    public static ResourceMethod createWadlOptionsMethod(Map<String, List<ResourceMethod>> methods, AbstractResource resource, PathPattern p) {
        try {
            WadlFactory.checkForJAXB();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (p == null) {
            return new WadlMethodFactory.WadlOptionsMethod(methods, resource, null);
        }
        String path = p.getTemplate().getTemplate().substring(1);
        return new WadlMethodFactory.WadlOptionsMethod(methods, resource, path);
    }

    private static void checkForJAXB() throws ClassNotFoundException {
        Class.forName("javax.xml.bind.JAXBElement");
    }
}

