/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.provider.entity;

import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.impl.provider.entity.AbstractMessageReaderWriterProvider;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import com.sun.syndication.io.WireFeedOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AtomEntryProvider
extends AbstractMessageReaderWriterProvider<Entry> {
    private static final String FEED_TYPE = "atom_1.0";

    public AtomEntryProvider() {
        Class<Entry> c = Entry.class;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return type == Entry.class;
    }

    public Entry readFrom(Class<Entry> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return AtomEntryProvider.parseEntry(entityStream);
        }
        catch (FeedException cause) {
            IOException effect = new IOException(ImplMessages.ERROR_CREATING_ATOM(type));
            effect.initCause(cause);
            throw effect;
        }
        catch (JDOMException cause2) {
            IOException effect = new IOException(ImplMessages.ERROR_CREATING_ATOM(type));
            effect.initCause(cause2);
            throw effect;
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations) {
        return type == Entry.class;
    }

    public void writeTo(Entry t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            AtomEntryProvider.serializeEntry(t, entityStream);
        }
        catch (FeedException cause) {
            IOException effect = new IOException(ImplMessages.ERROR_MARSHALLING_ATOM(t.getClass()));
            effect.initCause(cause);
            throw effect;
        }
    }

    private static Entry parseEntry(InputStream in) throws JDOMException, IOException, IllegalArgumentException, FeedException {
        SAXBuilder builder = new SAXBuilder();
        Document entryDoc = builder.build(in);
        Element fetchedEntryElement = entryDoc.getRootElement();
        fetchedEntryElement.detach();
        Feed feed = new Feed();
        feed.setFeedType(FEED_TYPE);
        WireFeedOutput wireFeedOutput = new WireFeedOutput();
        Document feedDoc = wireFeedOutput.outputJDom((WireFeed)feed);
        feedDoc.getRootElement().addContent((Content)fetchedEntryElement);
        WireFeedInput input = new WireFeedInput();
        Feed parsedFeed = (Feed)input.build(feedDoc);
        return (Entry)parsedFeed.getEntries().get(0);
    }

    private static void serializeEntry(Entry entry, OutputStream out) throws IllegalArgumentException, FeedException, IOException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(entry);
        Feed feed1 = new Feed();
        feed1.setFeedType(FEED_TYPE);
        feed1.setEntries(entries);
        WireFeedOutput wireFeedOutput = new WireFeedOutput();
        Document feedDoc = wireFeedOutput.outputJDom((WireFeed)feed1);
        Element entryElement = (Element)feedDoc.getRootElement().getChildren().get(0);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        outputter.output(entryElement, out);
    }
}

