/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.core;

import com.sun.jersey.api.core.ResourceConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceConfig
extends ResourceConfig {
    private final Set<Class<?>> resources = new HashSet();
    private final Set<Class<?>> providers = new HashSet();
    private final Map<String, MediaType> mediaExtentions = new HashMap<String, MediaType>();
    private final Map<String, String> languageExtentions = new HashMap<String, String>();
    private final Map<String, Boolean> features = new HashMap<String, Boolean>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<Object> providerInstances = new HashSet<Object>();

    public DefaultResourceConfig() {
        this((Set)null);
    }

    public DefaultResourceConfig(Class<?> ... resources) {
        this(new HashSet(Arrays.asList(resources)));
    }

    public DefaultResourceConfig(Set<Class<?>> resources) {
        this.features.put("com.sun.jersey.config.feature.CanonicalizeURIPath", false);
        this.features.put("com.sun.jersey.config.feature.IgnoreMatrixParams", false);
        this.features.put("com.sun.jersey.config.feature.NormalizeURI", false);
        this.features.put("com.sun.jersey.config.feature.Redirect", false);
        this.features.put("com.sun.jersey.config.feature.ImplicitViewables", false);
        if (null != resources) {
            this.resources.addAll(resources);
        }
    }

    public Set<Class<?>> getResourceClasses() {
        return this.resources;
    }

    public Set<Class<?>> getProviderClasses() {
        return this.providers;
    }

    public Map<String, MediaType> getMediaTypeMappings() {
        return this.mediaExtentions;
    }

    public Map<String, String> getLanguageMappings() {
        return this.languageExtentions;
    }

    @Override
    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    @Override
    public boolean getFeature(String featureName) {
        Boolean v = this.features.get(featureName);
        return v != null ? v : false;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public Set<Object> getProviderInstances() {
        return this.providerInstances;
    }
}

