/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

class PropertiesStorage {
    private static final String USERROOT_PREFIX = "/Preferences";
    private static final FileObject SFS_ROOT = Repository.getDefault().getDefaultFileSystem().getRoot();
    private final String folderPath;
    private String filePath;

    static PropertiesStorage instance(String string) {
        return new PropertiesStorage(string);
    }

    FileObject preferencesRoot() throws IOException {
        return FileUtil.createFolder((FileObject)SFS_ROOT, (String)USERROOT_PREFIX);
    }

    private PropertiesStorage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(USERROOT_PREFIX).append(string);
        this.folderPath = stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties load() throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = this.inputStream();
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        Properties properties2 = properties;
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Properties properties) throws IOException {
        if (!properties.isEmpty()) {
            OutputStream outputStream = null;
            try {
                outputStream = this.outputStream();
                properties.store(outputStream, new Date().toString());
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        } else {
            FileObject fileObject = this.toPropertiesFile();
            if (fileObject != null) {
                fileObject.delete();
            }
            for (FileObject fileObject2 = this.toFolder(); fileObject2 != null && fileObject2 != this.preferencesRoot() && fileObject2.getChildren().length == 0; fileObject2 = fileObject2.getParent()) {
                fileObject2.delete();
            }
        }
    }

    private InputStream inputStream() throws IOException {
        FileObject fileObject = this.toPropertiesFile(false);
        return fileObject == null ? null : fileObject.getInputStream();
    }

    private OutputStream outputStream() throws IOException {
        FileObject fileObject = this.toPropertiesFile(true);
        final FileLock fileLock = fileObject.lock();
        OutputStream outputStream = fileObject.getOutputStream(fileLock);
        return new FilterOutputStream(outputStream){

            public void close() throws IOException {
                super.close();
                fileLock.releaseLock();
            }
        };
    }

    private String folderPath() {
        return this.folderPath;
    }

    private String filePath() {
        if (this.filePath == null) {
            String[] stringArray = this.folderPath().split("/");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i]).append("/");
            }
            if (stringArray.length > 0) {
                stringBuilder.append(stringArray[stringArray.length - 1]).append(".properties");
            } else {
                stringBuilder.append("root.properties");
            }
            this.filePath = stringBuilder.toString();
        }
        return this.filePath;
    }

    protected FileObject toFolder() {
        return SFS_ROOT.getFileObject(this.folderPath);
    }

    protected FileObject toPropertiesFile() {
        return SFS_ROOT.getFileObject(this.filePath());
    }

    protected FileObject toFolder(boolean bl) throws IOException {
        FileObject fileObject = this.toFolder();
        if (fileObject == null && bl) {
            fileObject = FileUtil.createFolder((FileObject)SFS_ROOT, (String)this.folderPath);
        }
        assert (fileObject == null && !bl || fileObject != null && fileObject.isFolder());
        return fileObject;
    }

    protected FileObject toPropertiesFile(boolean bl) throws IOException {
        FileObject fileObject = this.toPropertiesFile();
        if (fileObject == null && bl) {
            fileObject = FileUtil.createData((FileObject)SFS_ROOT, (String)this.filePath());
        }
        assert (fileObject == null && !bl || fileObject != null && fileObject.isData());
        return fileObject;
    }
}

