/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.core.InvokeOperationCookie;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ProjectClientView;
import org.netbeans.modules.websvc.core.WebServiceActionProvider;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ClientExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private ExplorerManager manager;
    private BeanTreeView treeView;
    private FileObject srcFileObject;
    private Node selectedMethod;
    private Project[] projects;
    private Children rootChildren;
    private Node explorerClientRoot;
    private List<Node> projectNodeList;
    private JLabel jLblTreeView;

    public ClientExplorerPanel(FileObject fileObject) {
        this.srcFileObject = fileObject;
        this.projects = OpenProjects.getDefault().getOpenProjects();
        this.rootChildren = new Children.Array();
        this.explorerClientRoot = new AbstractNode(this.rootChildren);
        this.projectNodeList = new ArrayList<Node>();
        this.manager = new ExplorerManager();
        this.selectedMethod = null;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(ClientExplorerPanel.class, (String)"LBL_AvailableWebServices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientExplorerPanel.class, (String)"ACSD_AvailableWebServicesTree"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientExplorerPanel.class, (String)"ACSD_AvailableWebServicesTree"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.projects.length; ++i) {
            LogicalViewProvider logicalViewProvider;
            Project project = FileOwnerQuery.getOwner((FileObject)this.srcFileObject);
            if (project == null || !JaxWsUtils.isProjectReferenceable(this.projects[i], project) || (logicalViewProvider = (LogicalViewProvider)this.projects[i].getLookup().lookup(LogicalViewProvider.class)) == null) continue;
            Node node = logicalViewProvider.createLogicalView();
            Node[] nodeArray = ProjectClientView.createClientView(this.projects[i]);
            if (nodeArray == null || nodeArray.length <= 0) continue;
            Children.Array array = new Children.Array();
            for (Node node2 : nodeArray) {
                Node[] nodeArray2 = node2.getChildren().getNodes();
                if (nodeArray2 == null || nodeArray2.length <= 0) continue;
                Node[] nodeArray3 = new Node[nodeArray2.length];
                for (int j = 0; j < nodeArray2.length; ++j) {
                    nodeArray3[j] = new FilterNode(nodeArray2[j]);
                }
                array.add(nodeArray3);
            }
            if (array.getNodesCount() <= 0) continue;
            this.projectNodeList.add((Node)new ProjectNode((Children)array, node));
        }
        Node[] nodeArray = new Node[this.projectNodeList.size()];
        this.projectNodeList.toArray(nodeArray);
        this.rootChildren.add(nodeArray);
        this.manager.setRootContext(this.explorerClientRoot);
        this.treeView.expandAll();
        this.descriptor.setValid(false);
    }

    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
    }

    public Node getSelectedMethod() {
        return this.selectedMethod;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Node[] nodeArray;
        if (propertyChangeEvent.getSource() == this.manager && "selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = this.manager.getSelectedNodes()) != null && nodeArray.length > 0) {
            Node node = nodeArray[0];
            InvokeOperationCookie invokeOperationCookie = WebServiceActionProvider.getInvokeOperationAction(this.srcFileObject, node);
            if (invokeOperationCookie != null) {
                if (invokeOperationCookie.isWebServiceOperation(node)) {
                    this.selectedMethod = node;
                    this.descriptor.setValid(true);
                } else {
                    this.selectedMethod = null;
                    this.descriptor.setValid(false);
                }
            } else {
                this.selectedMethod = null;
                this.descriptor.setValid(false);
            }
        }
    }

    private class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node node) {
            super(children);
            this.rootNode = node;
            this.setName(node.getDisplayName());
        }

        public Image getIcon(int n) {
            return this.rootNode.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.rootNode.getOpenedIcon(n);
        }
    }
}

