/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.saas;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsCodeGenerator;
import org.netbeans.modules.websvc.core.jaxws.saas.Constants;
import org.netbeans.modules.websvc.core.jaxws.saas.JavaSourceHelper;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestWrapperForSoapGenerator {
    private FileObject targetFile;
    private WSService service;
    private WSPort port;
    private WSOperation operation;
    private Project project;
    private Map<String, Class> primitiveTypes;
    public static final Modifier[] PUBLIC = new Modifier[]{Modifier.PUBLIC};
    public static final String GET_ANNOTATION = "GET";
    public static final String INDENT = "        ";
    public static final String INDENT_2 = "             ";
    public static final String PRODUCE_MIME_ANNOTATION = "ProduceMime";
    public static final String PATH_ANNOTATION = "Path";
    public static final String QUERY_PARAM_ANNOTATION = "QueryParam";
    public static final String DEFAULT_VALUE_ANNOTATION = "DefaultValue";

    public RestWrapperForSoapGenerator(WSService wSService, WSPort wSPort, WSOperation wSOperation, FileObject fileObject) {
        this.service = wSService;
        this.port = wSPort;
        this.operation = wSOperation;
        this.targetFile = fileObject;
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public Set<FileObject> generate() throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.targetFile);
        final String string = this.operation.getReturnTypeName();
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree classTree = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                ClassTree classTree2 = RestWrapperForSoapGenerator.this.addGetMethod("application/xml", string, workingCopy, classTree);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }

            public void cancel() {
            }
        };
        javaSource.runModificationTask((Task)cancellableTask).commit();
        return new HashSet<FileObject>(Collections.EMPTY_LIST);
    }

    public List<WSParameter> getOutputParameters() {
        ArrayList<WSParameter> arrayList = new ArrayList<WSParameter>();
        for (WSParameter wSParameter : this.operation.getParameters()) {
            if (!wSParameter.isHolder()) continue;
            arrayList.add(wSParameter);
        }
        return arrayList;
    }

    private ClassTree addGetMethod(String string, String string2, WorkingCopy workingCopy, ClassTree classTree) throws IOException {
        Object object;
        String[] stringArray;
        Modifier[] modifierArray = PUBLIC;
        String string3 = "result";
        String string4 = string2;
        if (string4.equals("void")) {
            stringArray = this.getOutputParameters();
            for (WSParameter object22 : stringArray) {
                if (!object22.isHolder()) continue;
                object = object22.getTypeName();
                int stringArray2 = ((String)object).indexOf("<");
                int objectArray2 = ((String)object).lastIndexOf(">");
                string4 = ((String)object).substring(stringArray2 + 1, objectArray2);
                string3 = object22.getName() + ".value";
                break;
            }
        }
        stringArray = new String[]{GET_ANNOTATION, PRODUCE_MIME_ANNOTATION, PATH_ANNOTATION};
        Object[] objectArray = new Object[]{null, "application/xml", this.operation.getName() + "/"};
        if (string2 == null) {
            string2 = String.class.getName();
        }
        String string5 = this.getSOAPClientInvocation(string4, string3);
        object = this.operation.getParameters();
        String[] stringArray2 = this.getGetParamNames((List<WSParameter>)object);
        Object[] objectArray2 = this.getGetParamTypes((List<WSParameter>)object);
        String[][] stringArray3 = this.getGetParamAnnotations((List<WSParameter>)object);
        Object[][] objectArray3 = this.getGetParamAnnotationAttrs((List<WSParameter>)object);
        String string6 = "Invokes the SOAP method " + this.operation.getName() + "\n";
        for (String string7 : stringArray2) {
            string6 = string6 + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", string7);
        }
        string6 = string6 + "@return an instance of " + string4;
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, this.getMethodName(Constants.HttpMethodType.GET), string4, stringArray2, objectArray2, (Object[])stringArray3, (Object[])objectArray3, string5, string6);
    }

    private String[] getGetParamTypes(List<WSParameter> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WSParameter wSParameter : list) {
            if (wSParameter.isHolder()) continue;
            arrayList.add(wSParameter.getTypeName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getGetParamNames(List<WSParameter> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WSParameter wSParameter : list) {
            if (wSParameter.isHolder()) continue;
            arrayList.add(wSParameter.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Object generateDefaultValue(Class clazz) {
        if (clazz == Integer.class || clazz == Short.class || clazz == Long.class || clazz == Float.class || clazz == Double.class) {
            try {
                return clazz.getConstructor(String.class).newInstance("0");
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (clazz == Boolean.class) {
            return Boolean.FALSE;
        }
        if (clazz == Character.class) {
            return new Character('\u0000');
        }
        return null;
    }

    private String[][] getGetParamAnnotations(List<WSParameter> list) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = null;
        for (WSParameter wSParameter : list) {
            Class clazz = this.getType(this.project, wSParameter.getTypeName());
            stringArray = this.generateDefaultValue(clazz) != null ? new String[]{QUERY_PARAM_ANNOTATION, DEFAULT_VALUE_ANNOTATION} : new String[]{QUERY_PARAM_ANNOTATION};
            arrayList.add(stringArray);
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    public Class getGenericRawType(String string, ClassLoader classLoader) {
        int n = string.indexOf(60);
        if (n < 1) {
            return null;
        }
        String string2 = string.substring(0, n);
        try {
            return classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.global.log(Level.INFO, "", classNotFoundException);
            return null;
        }
    }

    public Class getType(Project project, String string) {
        List<ClassPath> list = RestWrapperForSoapGenerator.getClassPath(project);
        for (ClassPath classPath : list) {
            try {
                Class clazz = this.getPrimitiveType(string);
                if (clazz != null) {
                    return clazz;
                }
                ClassLoader classLoader = classPath.getClassLoader(true);
                clazz = this.getGenericRawType(string, classLoader);
                if (clazz != null) {
                    return clazz;
                }
                if (classLoader == null) continue;
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getInputParameterTypes() {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (WSParameter wSParameter : this.operation.getParameters()) {
            if (wSParameter.isHolder()) continue;
            Class clazz = null;
            RestWrapperForSoapGenerator restWrapperForSoapGenerator = this;
            synchronized (restWrapperForSoapGenerator) {
                try {
                    for (int i = 0; i < 60 && (clazz = this.getType(this.project, wSParameter.getTypeName())) == null; ++i) {
                        this.wait(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = Object.class;
            }
            arrayList.add(clazz);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private Object[][] getGetParamAnnotationAttrs(List<WSParameter> list) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Object[] objectArray = null;
        for (WSParameter wSParameter : list) {
            Class clazz = this.getType(this.project, wSParameter.getTypeName());
            Object object = this.generateDefaultValue(clazz);
            objectArray = this.generateDefaultValue(clazz) != null ? new Object[]{wSParameter.getName(), object.toString()} : new Object[]{wSParameter.getName()};
            arrayList.add(objectArray);
        }
        return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
    }

    private String getMethodName(Constants.HttpMethodType httpMethodType) {
        String string = this.camelize(this.operation.getName(), true);
        if (string.startsWith(httpMethodType.prefix())) {
            return string;
        }
        return httpMethodType.prefix() + this.camelize(string, false);
    }

    protected String getCustomMethodBody() throws IOException {
        String string = INDENT;
        string = string + JaxWsCodeGenerator.getWSInvocationCode(this.targetFile, false, this.service, this.port, this.operation);
        return string;
    }

    private String getSOAPClientInvocation(String string, String string2) throws IOException {
        String string3 = "{\n";
        string3 = string3 + "        try {\n";
        string3 = string3 + this.getCustomMethodBody() + "\n";
        if (!string.equals("void")) {
            string3 = string3 + "return " + string2 + ";\n";
        }
        string3 = string3 + "        } catch (Exception ex) {\n";
        string3 = string3 + "             ex.printStackTrace();\n";
        string3 = string3 + "        }\n";
        if (!string.equals("void")) {
            string3 = string3 + "return null;\n";
        }
        string3 = string3 + "}\n";
        return string3;
    }

    public Class getPrimitiveType(String string) {
        if (this.primitiveTypes == null) {
            this.primitiveTypes = new HashMap<String, Class>();
            this.primitiveTypes.put("int", Integer.class);
            this.primitiveTypes.put("int[]", Integer[].class);
            this.primitiveTypes.put("boolean", Boolean.class);
            this.primitiveTypes.put("boolean[]", Boolean[].class);
            this.primitiveTypes.put("byte", Byte.class);
            this.primitiveTypes.put("byte[]", Byte[].class);
            this.primitiveTypes.put("char", Character.class);
            this.primitiveTypes.put("char[]", Character[].class);
            this.primitiveTypes.put("double", Double.class);
            this.primitiveTypes.put("double[]", Double[].class);
            this.primitiveTypes.put("float", Float.class);
            this.primitiveTypes.put("float[]", Float[].class);
            this.primitiveTypes.put("long", Long.class);
            this.primitiveTypes.put("long[]", Long[].class);
            this.primitiveTypes.put("short", Short.class);
            this.primitiveTypes.put("short[]", Short[].class);
        }
        return this.primitiveTypes.get(string);
    }

    public static List<ClassPath> getClassPath(Project project) {
        ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>();
        ArrayList<SourceGroup> arrayList2 = new ArrayList<SourceGroup>();
        arrayList2.addAll(Arrays.asList(ProjectUtils.getSources((Project)project).getSourceGroups("java")));
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        for (SourceGroup sourceGroup : arrayList2) {
            ClassPath classPath = classPathProvider.findClassPath(sourceGroup.getRootFolder(), "classpath/compile");
            if (classPath != null) {
                arrayList.add(classPath);
            }
            if ((classPath = classPathProvider.findClassPath(sourceGroup.getRootFolder(), "classpath/source")) == null) continue;
            arrayList.add(classPath);
        }
        return arrayList;
    }

    public String camelize(String string, boolean bl) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (bl) {
            stringBuffer.append(Character.toLowerCase(string.charAt(0)));
        } else {
            stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        }
        boolean bl2 = false;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuffer.append(Character.toUpperCase(c));
                bl2 = false;
                continue;
            }
            if (c == '_') {
                bl2 = true;
                continue;
            }
            if (c == '/') {
                bl2 = true;
                stringBuffer.append('.');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

