/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.core.JaxWsStackProvider;
import org.netbeans.modules.websvc.serverapi.api.WSStack;
import org.netbeans.modules.websvc.serverapi.api.WSStackProvider;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class JaxWsArtifactsClassPathProvider
implements ClassPathProvider {
    private Project project;
    private ClassPath sourceCP;
    private ClassPath compileCP;
    private ClassPath bootCP;
    private static final Logger LOG = Logger.getLogger(JaxWsArtifactsClassPathProvider.class.getName());

    JaxWsArtifactsClassPathProvider(Project project) {
        this.project = project;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        FileObject fileObject2 = this.project.getProjectDirectory().getFileObject("build/generated/wsimport/client");
        if (fileObject2 != null && (fileObject.equals(fileObject2) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            if ("classpath/source".equals(string)) {
                if (this.sourceCP == null) {
                    this.sourceCP = this.getClassPath("classpath/source");
                }
                return this.sourceCP;
            }
            if ("classpath/compile".equals(string)) {
                if (this.compileCP == null) {
                    this.compileCP = this.getClassPath("classpath/compile");
                }
                return this.compileCP;
            }
            if ("classpath/boot".equals(string)) {
                if (this.bootCP == null) {
                    this.bootCP = this.getBootClassPath();
                }
                return this.bootCP;
            }
        } else {
            FileObject fileObject3 = this.project.getProjectDirectory().getFileObject("build/generated/wsimport/service");
            if (fileObject3 != null && (fileObject.equals(fileObject3) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
                if ("classpath/source".equals(string)) {
                    if (this.sourceCP == null) {
                        this.sourceCP = this.getClassPath("classpath/source");
                    }
                    return this.sourceCP;
                }
                if ("classpath/compile".equals(string)) {
                    if (this.compileCP == null) {
                        this.compileCP = this.getClassPath("classpath/compile");
                    }
                    return this.compileCP;
                }
                if ("classpath/boot".equals(string)) {
                    if (this.bootCP == null) {
                        this.bootCP = this.getBootClassPath();
                    }
                    return this.bootCP;
                }
            }
        }
        return null;
    }

    private ClassPath getClassPath(String string) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray.length > 0) {
            return ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)string);
        }
        return null;
    }

    private ClassPath getBootClassPath() {
        Object object;
        Object object2;
        HashSet<File> hashSet = new HashSet<File>();
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            object2 = j2eeModuleProvider.getServerInstanceID();
            if (object2 != null) {
                try {
                    object = Deployment.getDefault().getServerInstance((String)object2).getJ2eePlatform();
                    WSStack wSStack = JaxWsStackProvider.getJaxWsStackForTool(object, "tool_wsimport");
                    if (wSStack != null && wSStack.getWSStackProvider() == WSStackProvider.SERVER) {
                        hashSet.addAll(Arrays.asList(wSStack.getToolClassPathEntries("tool_wsimport")));
                    }
                }
                catch (InstanceRemovedException instanceRemovedException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to find J2eePlatform", instanceRemovedException);
                }
            }
        } else {
            object2 = InstalledFileLocator.getDefault().locate("modules/ext/jaxws21/api", null, false);
            hashSet.addAll(Arrays.asList(((File)object2).listFiles()));
        }
        object2 = new LinkedList<PathResourceImplementation>();
        object = null;
        for (File file : hashSet) {
            try {
                object = FileUtil.getArchiveRoot((URL)file.toURI().toURL());
                object2.add(ClassPathSupport.createResource((URL)object));
            }
            catch (MalformedURLException malformedURLException) {
                LOG.severe(malformedURLException.getMessage());
            }
        }
        object = null;
        return ClassPathSupport.createClassPath(object2);
    }
}

